/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.balance.server.service;

import jakarta.jws.WebService;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Reserve;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.ReserveType;
import ru.bitel.bgbilling.kernel.contract.balance.common.service.ReserveService;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.ReserveDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.ReserveTypeDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.ContractBalanceChangedEvent;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.common.model.Period;

@WebService(endpointInterface="ru.bitel.bgbilling.kernel.contract.balance.common.service.ReserveService")
public class ReserveServiceImpl
extends AbstractService
implements ReserveService {
    private ReserveDao reserveDao;
    private ReserveTypeDao reserveTypeDao;

    private ReserveDao getReserveDao() {
        this.reserveDao = new ReserveDao(this.getConnection());
        return Optional.ofNullable(this.reserveDao).orElse(this.reserveDao);
    }

    private ReserveTypeDao getReserveTypeDao() {
        this.reserveTypeDao = new ReserveTypeDao(this.getConnection());
        return Optional.ofNullable(this.reserveTypeDao).orElse(this.reserveTypeDao);
    }

    @Override
    public List<Reserve> reserveList(int contractId, Period period, int reserveMembers) throws BGException {
        return this.tryReturn(() -> this.getReserveDao().getReserveList(contractId, period, reserveMembers));
    }

    @Override
    public int updateReserve(Reserve reserve) throws BGException {
        return this.tryReturn(() -> {
            BigDecimal sumChange = reserve.getId() < 1 ? reserve.getSum() : reserve.getSum().subtract(((Reserve)this.getReserveDao().get(reserve.getId())).getSum());
            this.getReserveDao().update(reserve);
            if (sumChange.compareTo(BigDecimal.ZERO) != 0) {
                this.getReserveDao().recalculationSumReserve(reserve.getContractId());
                if (ReserveDao.flagReserve) {
                    EventProcessor.getInstance().publishAfterCommit(new ContractBalanceChangedEvent(reserve.getContractId(), 5, new Date(), sumChange));
                }
            }
            return reserve.getId();
        });
    }

    @Override
    public void closeReserve(int reserveId) throws BGException {
        this.tryCall(() -> {
            if (this.getReserveDao().closeReserve(reserveId)) {
                Reserve reserve = (Reserve)this.getReserveDao().get(reserveId);
                this.getReserveDao().recalculationSumReserve(reserve.getContractId());
                if (ReserveDao.flagReserve) {
                    EventProcessor.getInstance().publishAfterCommit(new ContractBalanceChangedEvent(reserve.getContractId(), 6, new Date(), reserve.getSum()));
                }
            }
        });
    }

    @Override
    public BigDecimal reserveSum(int contractId) throws BGException {
        return this.tryReturn(() -> this.getReserveDao().getReserveSum(contractId));
    }

    @Override
    public ReserveType reserveTypeGet(int id) throws BGException {
        return this.context.getDirectory(ReserveType.class, 0).get(id);
    }

    @Override
    public List<ReserveType> reserveTypeList(boolean used) throws BGException {
        return this.tryReturn(() -> used ? this.getReserveTypeDao().list(used) : this.context.getDirectory(ReserveType.class, 0).list());
    }

    @Override
    public int reserveTypeUpdate(ReserveType reserveType) throws BGException {
        return this.tryReturn(() -> {
            this.context.getDirectory(ReserveType.class, 0).update(reserveType);
            return reserveType.getId();
        });
    }

    @Override
    public int reserveTypeDelete(int reserveTypeId) throws BGException {
        return this.tryReturn(() -> {
            if (this.getReserveDao().isUseReserveType(reserveTypeId)) {
                throw new BGMessageException("\u0414\u0430\u043d\u043d\u044b\u0439 \u0442\u0438\u043f \u0440\u0435\u0437\u0435\u0440\u0432\u0430 \u043d\u0435 \u0431\u044b\u043b \u0443\u0434\u0430\u043b\u0435\u043d, \u0442\u0430\u043a \u043a\u0430\u043a \u0435\u0441\u0442\u044c \u0440\u0435\u0437\u0435\u0440\u0432\u044b \u0441 \u0442\u0430\u043a\u0438\u043c \u0442\u0438\u043f\u043e\u043c.");
            }
            return this.context.getDirectory(ReserveType.class, 0).delete(reserveTypeId);
        });
    }
}

