/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.param.client;

import bitel.billing.module.admin.TransferManager;
import bitel.billing.module.common.BGTabbedPane;
import bitel.billing.module.common.table.BGTable;
import bitel.billing.module.contract.AddressUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.bushe.swing.event.EventBus;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.field.BGIntTextField;
import ru.bitel.bgbilling.client.common.field.BGTextArea;
import ru.bitel.bgbilling.client.common.field.BGTextField;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.RadioTableCellRenderer;
import ru.bitel.bgbilling.client.event.UpdateContractTreeEvent;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.common.model.KeyValue;
import ru.bitel.bgbilling.kernel.contract.api.common.service.ContractService;
import ru.bitel.bgbilling.kernel.contract.object.common.service.ContractObjectService;
import ru.bitel.bgbilling.kernel.contract.param.client.AddressHouseAddNewDialog;
import ru.bitel.bgbilling.kernel.contract.param.client.AddressHouseSearchDialog;
import ru.bitel.bgbilling.kernel.contract.param.client.ContractParamEditorData;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGTitleLabel;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.function.Async;
import ru.bitel.oss.kernel.directories.address.common.bean.House;
import ru.bitel.oss.kernel.directories.address.common.bean.HouseData;
import ru.bitel.oss.kernel.directories.address.common.service.AddressService;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttr;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrAddress;

public class ContractParamAddressEditorDialog
extends BGEditorDialog<ContractParamEditorData> {
    private EntityAttrAddress attrAddress;
    private BGButton newHouseButton = new BGButton("+");
    private JTabbedPane directoryOrCustomPanel = new JTabbedPane();
    private JCheckBox addressNone = new JCheckBox("\u0443\u0434\u0430\u043b\u0438\u0442\u044c \u0430\u0434\u0440\u0435\u0441\u043d\u044b\u0439 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440");
    private BGTextField flat = new BGTextField();
    private BGTextField room = new BGTextField();
    private BGIntTextField pod = new BGIntTextField();
    private BGTextField floor = new BGTextField();
    private BGTextArea addressCustom = new BGTextArea(10, 70);
    private BGTextArea addressComment = new BGTextArea(2, 70);
    private JButton houseButton = new JButton();
    private BGTable additionalInfoTable;
    private AddressFormatTableModel addressFormatTableModel = new AddressFormatTableModel();
    private BGUTable addressFormatTable = new BGUTable(this.addressFormatTableModel);
    private String entranceRange = null;
    private String floorRange = null;
    private boolean needUpdateFormatTable = true;
    private boolean canCreateHouse = false;
    private boolean addressCustomFlag = true;

    public ContractParamAddressEditorDialog(String title, ContractParamEditorData data) {
        super(title, data);
    }

    @Override
    public void doDialogPanel() {
        JPanel directoryPanel = new JPanel(new GridBagLayout());
        directoryPanel.add((Component)this.getHousePanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
        directoryPanel.add((Component)this.getFlatPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        directoryPanel.add((Component)this.getTabPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        JPanel customPanel = new JPanel(new GridBagLayout());
        customPanel.add((Component)BGSwingUtilites.wrapScrollPane(this.addressCustom, 100, 300), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.directoryOrCustomPanel.add((Component)directoryPanel, "\u0430\u0434\u0440\u0435\u0441 \u0438\u0437 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0430");
        this.directoryOrCustomPanel.add((Component)customPanel, "\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u0441\u043a\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0430\u0434\u0440\u0435\u0441\u0430");
        this.addressComment.getDocument().addDocumentListener(new AddressDocumentListener());
        this.panel.setFocusTraversalPolicy(this.getFocus());
        this.panel.setFocusCycleRoot(true);
        this.panel.add((Component)new BGTitleLabel(((ContractParamEditorData)this.data).parameterTitle), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.panel.add((Component)this.directoryOrCustomPanel, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 0, 0, 0), 0, 0));
        this.panel.add((Component)new JLabel("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.panel.add((Component)new JScrollPane(this.addressComment), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 1, new Insets(2, 0, 0, 0), 0, 0));
        this.panel.add((Component)this.addressNone, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 0, 0, 0), 0, 0));
        int entityId = 0;
        switch (((ContractParamEditorData)this.data).entityType) {
            case CONTRACT_PARAMETER: {
                entityId = ((ContractParamEditorData)this.data).contractId;
                try {
                    this.attrAddress = (EntityAttrAddress)((ContractParamEditorData)this.data).clientContext.getWebService(ContractService.class, 0).contractParameterGet(((ContractParamEditorData)this.data).contractId, ((ContractParamEditorData)this.data).parameterId);
                }
                catch (Exception ex) {
                    ClientUtils.showErrorMessageDialog(ex);
                }
                break;
            }
            case OBJECT_PARAMETER: {
                entityId = ((ContractParamEditorData)this.data).objectId;
                try {
                    this.attrAddress = (EntityAttrAddress)((ContractParamEditorData)this.data).clientContext.getWebService(ContractObjectService.class, 0).objectParameterGet(((ContractParamEditorData)this.data).contractId, ((ContractParamEditorData)this.data).objectId, ((ContractParamEditorData)this.data).parameterId);
                }
                catch (Exception ex) {
                    ClientUtils.showErrorMessageDialog(ex);
                }
                break;
            }
            case NEW_CONTRACT_PARAMETER: 
            case ATTRIBUTE_PARAMETER: {
                this.attrAddress = (EntityAttrAddress)((ContractParamEditorData)this.data).getValue();
                break;
            }
        }
        if (this.attrAddress == null) {
            this.attrAddress = EntityAttrAddress.builder((int)entityId, (int)((ContractParamEditorData)this.data).parameterId).setFormatKey("").setHouseId(-1).setFloor(-100).build();
        }
        if (this.attrAddress.getHouseId() > 0) {
            this.setSelectedHouse(this.attrAddress.getHouseId());
        } else {
            this.houseButton.setText((String)(this.attrAddress.getHouseId() > 0 ? "<html><div style=\"text-align: center;\">" + this.attrAddress.getTitle() + "</div></html>" : "\u043d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d"));
        }
        this.needUpdateFormatTable = false;
        this.flat.setText(this.attrAddress.getFlat());
        this.room.setText(this.attrAddress.getRoom());
        this.floor.setText(this.attrAddress.getFloor() > -100 ? String.valueOf(this.attrAddress.getFloor()) : "");
        this.pod.setText(String.valueOf(this.attrAddress.getPod()));
        this.addressComment.setText(this.attrAddress.getComment());
        this.needUpdateFormatTable = true;
        this.directoryOrCustomPanel.setSelectedIndex(this.attrAddress.getHouseId() == 0 ? 1 : 0);
        this.addressCustom.setText(this.attrAddress.getHouseId() == 0 ? this.attrAddress.getTitle() : "");
        try {
            this.setAddressFormatTableData(this.attrAddress);
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
    }

    @Override
    public boolean doApply() throws Exception {
        if (this.addressNone.isSelected()) {
            this.deleteAddress();
            return true;
        }
        int tabIndex = this.directoryOrCustomPanel.getSelectedIndex();
        if (tabIndex == 0) {
            if (!this.checkAddresParameter()) {
                return false;
            }
            this.updateAddress();
        } else if (tabIndex == 1) {
            this.updateAddressCustom();
        }
        return true;
    }

    private BGTabbedPane getTabPanel() {
        this.addressFormatTable.setSelectionMode(0);
        this.addressFormatTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                AddressFormatRow row;
                if (mouseEvent.getClickCount() == 1 && (row = (AddressFormatRow)ContractParamAddressEditorDialog.this.addressFormatTableModel.getSelectedRow()) != null) {
                    ContractParamAddressEditorDialog.this.addressFormatTableModel.getRows().forEach(a -> a.setSelect(false));
                    row.setSelect(true);
                    ContractParamAddressEditorDialog.this.addressFormatTable.updateUI();
                    ContractParamAddressEditorDialog.this.addressFormatTable.repaint();
                }
            }
        });
        this.additionalInfoTable = new BGTable();
        this.additionalInfoTable.addColumn("paramName", "\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440", new int[]{100, 150, 200}, false);
        this.additionalInfoTable.setAutoResizeMode(1);
        this.additionalInfoTable.addColumn("paramValue", "\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435", new int[]{-1, -1, -1}, false);
        JPanel infoPanel = new JPanel(new BorderLayout());
        infoPanel.add((Component)new JScrollPane(this.additionalInfoTable), "Center");
        BGTabbedPane additionalHouseInfoPanel = new BGTabbedPane();
        additionalHouseInfoPanel.add((Component)new JScrollPane(this.addressFormatTable), "\u0424\u043e\u0440\u043c\u0430\u0442 \u0430\u0434\u0440\u0435\u0441\u0430");
        additionalHouseInfoPanel.add((Component)infoPanel, "\u0414\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u0430\u044f \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f");
        BGSwingUtilites.setDimension(additionalHouseInfoPanel, 500, 150);
        return additionalHouseInfoPanel;
    }

    private JPanel getFlatPanel() {
        AddressDocumentListener addressDocumentListener = new AddressDocumentListener();
        this.room.setHorizontalAlignment(0);
        this.room.getDocument().addDocumentListener(addressDocumentListener);
        this.floor.setColumns(3);
        this.floor.setHorizontalAlignment(0);
        this.floor.getDocument().addDocumentListener(addressDocumentListener);
        this.pod.setColumns(3);
        this.pod.getDocument().addDocumentListener(addressDocumentListener);
        this.flat.setColumns(10);
        this.flat.setHorizontalAlignment(0);
        this.flat.setMinimumSize(new Dimension(80, 10));
        this.flat.getDocument().addDocumentListener(addressDocumentListener);
        this.flat.addActionListener(e -> this.onFlatChanged());
        this.flat.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                ContractParamAddressEditorDialog.this.onFlatChanged();
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(new BGTitleBorder("\u041f\u043e\u043c\u0435\u0449\u0435\u043d\u0438\u0435 ( \u043a\u0432\u0430\u0440\u0442\u0438\u0440\u0430, \u043e\u0444\u0438\u0441 \u0438 \u0442.\u0434.)"));
        panel.add((Component)new JLabel("\u041d\u043e\u043c\u0435\u0440: "), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        panel.add((Component)this.flat, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        panel.add((Component)new JLabel("\u041a\u043e\u043c\u043d\u0430\u0442\u0430: "), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        panel.add((Component)this.room, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        panel.add((Component)new JLabel("\u041f\u043e\u0434\u044a\u0435\u0437\u0434: "), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        panel.add((Component)this.pod, new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        panel.add((Component)new JLabel("\u042d\u0442\u0430\u0436: "), new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        panel.add((Component)this.floor, new GridBagConstraints(3, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        return panel;
    }

    private JPanel getHousePanel() {
        this.newHouseButton.setToolTipText("\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u043d\u043e\u0432\u044b\u0439 \u0434\u043e\u043c");
        this.newHouseButton.addActionListener(e -> new AddressHouseAddNewDialog("\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u043d\u043e\u0432\u044b\u0439 \u0434\u043e\u043c", this, ((ContractParamEditorData)this.data).clientContext).open());
        Dimension dimension = new Dimension(400, 60);
        this.houseButton.setMinimumSize(dimension);
        this.houseButton.setPreferredSize(dimension);
        this.houseButton.requestFocusInWindow();
        this.houseButton.addActionListener(e -> {
            House house = new House();
            new AddressHouseSearchDialog("\u0412\u044b\u0431\u043e\u0440 \u0434\u043e\u043c\u0430 \u0438\u0437 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0430", house, ((ContractParamEditorData)this.data).clientContext).getDialog().setVisible(true);
            if (house.getId() > 0) {
                this.setSelectedHouse(house.getId());
            }
        });
        this.houseButton.setBackground(UIManager.getColor("TextField.background"));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(new BGTitleBorder(" \u0414\u043e\u043c "));
        panel.add((Component)this.houseButton, new GridBagConstraints(-1, 0, 1, 2, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        panel.add((Component)this.newHouseButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 1.0, 11, 3, new Insets(0, 5, 5, 5), 0, 0));
        return panel;
    }

    private boolean updateAddress() throws Exception {
        AddressFormatRow formatRow;
        boolean result = true;
        switch (((ContractParamEditorData)this.data).entityType) {
            case CONTRACT_PARAMETER: {
                Request request = new Request().setModule("contract").setAction("CheckAddressInfo").setAttribute("pid", ((ContractParamEditorData)this.data).parameterId).setContractId(((ContractParamEditorData)this.data).contractId);
                this.setAddressDataToRequest(request);
                Document doc = TransferManager.getDocument(request);
                String status = doc.getDocumentElement().getAttribute("status");
                if (status.equals("ok")) break;
                StringBuilder message = new StringBuilder().append("\u0410\u043d\u0430\u043b\u043e\u0433\u0438\u0447\u043d\u044b\u0439 \u0430\u0434\u0440\u0435\u0441 \u0435\u0441\u0442\u044c \u0432 ").append(doc.getDocumentElement().getAttribute("count")).append(" \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430\u0445");
                String contracts = doc.getDocumentElement().getAttribute("contract");
                if (contracts != null && contracts.length() > 0) {
                    message.append("\n( ").append(contracts).append(" )");
                }
                message.append("\n\u041f\u0440\u043e\u0434\u043e\u043b\u0436\u0438\u0442\u044c?");
                result = JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), message.toString(), "\u0414\u0443\u0431\u043b\u0438\u0440\u0443\u0435\u0442\u0441\u044f \u0430\u0434\u0440\u0435\u0441", 0) == 0;
                break;
            }
            case NEW_CONTRACT_PARAMETER: {
                ((ContractParamEditorData)this.data).value = this.attrAddress;
                result = false;
                break;
            }
            case ATTRIBUTE_PARAMETER: {
                ((ContractParamEditorData)this.data).value = this.attrAddress;
                break;
            }
        }
        this.attrAddress.setComment(this.addressComment.getText().trim());
        if (this.attrAddress.getHouseId() > 0 && (formatRow = (AddressFormatRow)this.addressFormatTableModel.getRows().stream().filter(a -> a.select).findFirst().orElse(null)) != null) {
            this.attrAddress.setTitle(formatRow.getAddress());
            this.attrAddress.setFormatKey(formatRow.getKey());
        }
        if (result) {
            result = this.updateAddressParameter();
        }
        return result;
    }

    protected boolean updateAddressParameter() throws Exception {
        boolean result = true;
        switch (((ContractParamEditorData)this.data).entityType) {
            case CONTRACT_PARAMETER: {
                ((ContractParamEditorData)this.data).clientContext.getWebService(ContractService.class, 0).contractParameterAddressUpdate(((ContractParamEditorData)this.data).contractId, this.attrAddress);
                break;
            }
            case OBJECT_PARAMETER: {
                ((ContractParamEditorData)this.data).clientContext.getWebService(ContractObjectService.class).objectParameterAddressUpdate(((ContractParamEditorData)this.data).contractId, this.attrAddress);
                break;
            }
            default: {
                return result;
            }
        }
        EventBus.publish((Object)new UpdateContractTreeEvent(0, ((ContractParamEditorData)this.data).contractId));
        return result;
    }

    protected void setAddressDataToRequest(Request request) {
        request.setAttribute("hid", this.attrAddress.getHouseId()).setAttribute("flat", this.attrAddress.getFlat().trim()).setAttribute("room", this.attrAddress.getRoom().trim()).setAttribute("pod", this.attrAddress.getPod()).setAttribute("floor", this.attrAddress.getFloor()).setAttribute("comment", this.attrAddress.getComment());
    }

    protected void updateAddressCustom() throws Exception {
        this.attrAddress.setHouseId(0);
        this.attrAddress.setFlat("");
        this.attrAddress.setRoom("");
        this.attrAddress.setFloor(0);
        this.attrAddress.setPod(0);
        switch (((ContractParamEditorData)this.data).entityType) {
            case CONTRACT_PARAMETER: {
                this.attrAddress.setTitle(this.addressCustom.getText());
                this.attrAddress.setComment(this.addressComment.getText());
                ((ContractParamEditorData)this.data).clientContext.getWebService(ContractService.class, 0).contractParameterUpdate(((ContractParamEditorData)this.data).contractId, (EntityAttr)this.attrAddress);
                break;
            }
            case OBJECT_PARAMETER: {
                this.attrAddress.setTitle(this.addressCustom.getText());
                this.attrAddress.setComment(this.addressComment.getText());
                ((ContractParamEditorData)this.data).clientContext.getWebService(ContractObjectService.class, 0).objectParameterAddressUpdate(((ContractParamEditorData)this.data).contractId, this.attrAddress);
                break;
            }
            case NEW_CONTRACT_PARAMETER: 
            case ATTRIBUTE_PARAMETER: {
                this.attrAddress.setTitle(this.addressCustom.getText());
                this.attrAddress.setComment(this.addressComment.getText());
                ((ContractParamEditorData)this.data).value = this.attrAddress;
                break;
            }
        }
    }

    protected void deleteAddress() throws Exception {
        switch (((ContractParamEditorData)this.data).entityType) {
            case CONTRACT_PARAMETER: {
                this.attrAddress.setHouseId(-1);
                ((ContractParamEditorData)this.data).clientContext.getWebService(ContractService.class, 0).contractParameterAddressUpdate(((ContractParamEditorData)this.data).contractId, this.attrAddress);
                break;
            }
            case OBJECT_PARAMETER: {
                ((ContractParamEditorData)this.data).clientContext.getWebService(ContractObjectService.class, 0).objectParameterAddressDelete(((ContractParamEditorData)this.data).contractId, ((ContractParamEditorData)this.data).objectId, ((ContractParamEditorData)this.data).parameterId);
                break;
            }
            case NEW_CONTRACT_PARAMETER: 
            case ATTRIBUTE_PARAMETER: {
                ((ContractParamEditorData)this.data).value = null;
                break;
            }
        }
    }

    private boolean checkAddresParameter() {
        String value = this.flat.getText().trim();
        if (value.length() > 10) {
            ClientUtils.showMessageDialog("\u041d\u043e\u043c\u0435\u0440 \u043a\u0432\u0430\u0440\u0442\u0438\u0440\u044b \u043c\u043e\u0436\u0435\u0442 \u0441\u043e\u0434\u0435\u0440\u0436\u0430\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e 10 \u0441\u0438\u043c\u0432\u043e\u043b\u043e\u0432");
            return false;
        }
        this.attrAddress.setFlat(value);
        value = this.room.getText().trim();
        if (value.length() > 5) {
            ClientUtils.showMessageDialog("\u041d\u043e\u043c\u0435\u0440 \u043a\u043e\u043c\u043d\u0430\u0442\u044b \u043c\u043e\u0436\u0435\u0442 \u0441\u043e\u0434\u0435\u0440\u0436\u0430\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e 5 \u0441\u0438\u043c\u0432\u043e\u043b\u043e\u0432");
            return false;
        }
        this.attrAddress.setRoom(value);
        String pd = this.pod.getText().trim();
        if (!pd.isEmpty() && Utils.parseInt(pd, -1) < 0) {
            ClientUtils.showMessageDialog("\"\u041f\u043e\u0434\u044a\u0435\u0437\u0434\" \u0441\u043b\u0438\u0448\u043a\u043e\u043c \u0431\u043e\u043b\u044c\u0448\u043e\u0435 \u0447\u0438\u0441\u043b\u043e");
            return false;
        }
        this.attrAddress.setPod(Utils.parseInt(pd, -1));
        String fl = this.floor.getText();
        if (!fl.isEmpty() && !fl.matches("^-?\\d+$")) {
            ClientUtils.showMessageDialog("\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \"\u042d\u0442\u0430\u0436\"");
            return false;
        }
        this.attrAddress.setFloor(Utils.parseInt(fl, -100));
        return true;
    }

    private void onFlatChanged() {
        String flt = this.flat.getText();
        if (Utils.notBlankString(flt)) {
            int val;
            if (this.entranceRange != null) {
                val = AddressUtil.getEntrance(this.entranceRange, Utils.parseInt(flt));
                this.pod.setText(val == -1 ? this.pod.getText() : String.valueOf(val));
            }
            if (this.floorRange != null) {
                val = AddressUtil.getFloor(this.floorRange, Utils.parseInt(flt));
                this.floor.setText(val == -100 ? this.floor.getText() : String.valueOf(val));
            }
        }
    }

    private FocusTraversalPolicy getFocus() {
        Vector<Component> focusOrder = new Vector<Component>();
        focusOrder.add(this.houseButton);
        focusOrder.add(this.flat);
        focusOrder.add(this.room);
        focusOrder.add(this.pod);
        focusOrder.add(this.floor);
        focusOrder.add(this.addressComment);
        return new AddressEditorFocusTraversalPolicy(this, focusOrder);
    }

    private void setAdditionalInfo(Map<String, String> info) {
        this.additionalInfoTable.removeRows();
        for (String paramName : info.keySet()) {
            this.addAdditionalParameter(paramName, info.get(paramName));
        }
    }

    private void addAdditionalParameter(String name, String value) {
        Vector<String> paramRow = new Vector<String>();
        paramRow.add(name);
        paramRow.add(value);
        this.additionalInfoTable.addRow(paramRow);
    }

    private void setAddressFormatTableData(EntityAttrAddress attrAddress) throws Exception {
        ArrayList addressFormatData = new ArrayList();
        if (attrAddress.getHouseId() > 0) {
            ((ContractParamEditorData)this.data).clientContext.getWebService(AddressService.class, 0).addressFormat(attrAddress, ((ContractParamEditorData)this.data).entityType).forEach(i -> {
                AddressFormatRow formatRow = new AddressFormatRow();
                formatRow.setKey(i.getKey());
                formatRow.setSelect(i.getKey().equals(attrAddress.getFormatKey()));
                formatRow.setAddress(i.getValue());
                addressFormatData.add(formatRow);
            });
        }
        this.addressFormatTableModel.setData(addressFormatData);
    }

    public void setDocument(Document doc) throws Exception {
        if (ClientUtils.checkStatus(doc)) {
            Element selectRadio;
            Element address = XMLUtils.selectElement(doc, "data/address");
            String addressCustomValue = XMLUtils.getAttribute(address, "address", null);
            if (addressCustomValue != null && this.addressCustomFlag) {
                this.attrAddress.setTitle(addressCustomValue);
            }
            if (this.attrAddress.getHouseId() > 0) {
                String houseAndFrac = XMLUtils.getAttribute(address, "house", "") + XMLUtils.getAttribute(address, "frac", "");
                this.attrAddress.setTitle(XMLUtils.getAttribute(address, "city", "") + ", " + XMLUtils.getAttribute(address, "street", "") + ", " + houseAndFrac);
            }
            this.attrAddress.setFormatKey((selectRadio = XMLUtils.selectElement(doc, "//selected")) != null ? selectRadio.getAttribute("selected_id") : "0");
            HashMap<String, String> additionalHouseInfo = new HashMap<String, String>();
            additionalHouseInfo.put("\u0438\u043d\u0434\u0435\u043a\u0441", XMLUtils.getAttribute(address, "index", ""));
            additionalHouseInfo.put("\u0440\u0430\u0439\u043e\u043d", XMLUtils.getAttribute(address, "area", ""));
            additionalHouseInfo.put("\u043a\u0432\u0430\u0440\u0442\u0430\u043b", XMLUtils.getAttribute(address, "quarter", ""));
            this.addExtraParamsToMap(XMLUtils.selectElement(doc, "data/extraParams"), additionalHouseInfo);
            this.setAdditionalInfo(additionalHouseInfo);
            Boolean b = Utils.parseBoolean(XMLUtils.selectText(doc, "data/address/create/@value"));
            this.canCreateHouse = b == null ? false : b;
            this.newHouseButton.setEnabled(this.canCreateHouse);
        }
    }

    protected void setSelectedHouse(int houseId) {
        Async.ofWithTry(() -> {
            HouseData houseInfo = ((ContractParamEditorData)this.data).clientContext.getWebService(AddressService.class, 0).houseDataGet(houseId);
            this.floorRange = houseInfo.getFloorRange();
            this.entranceRange = houseInfo.getEntranceRange();
            this.additionalInfoTable.removeRows();
            this.additionalInfoTable.addRow(new Vector<String>(Arrays.asList("\u041a\u0432\u0430\u0440\u0442\u0438\u0440", String.valueOf(houseInfo.getFlatCount()))));
            this.additionalInfoTable.addRow(new Vector<String>(Arrays.asList("\u0418\u043d\u0434\u0435\u043a\u0441", houseInfo.getPostIndex())));
            this.additionalInfoTable.addRow(new Vector<String>(Arrays.asList("\u0420\u0430\u0439\u043e\u043d", houseInfo.getAreaTitle())));
            this.additionalInfoTable.addRow(new Vector<String>(Arrays.asList("\u041a\u0432\u0430\u0440\u0442\u0430\u043b", houseInfo.getQuarterTitle())));
            for (KeyValue keyValue : houseInfo.getParams()) {
                this.additionalInfoTable.addRow(new Vector<String>(Arrays.asList(keyValue.getKey(), keyValue.getValue())));
            }
            this.houseButton.setText("<html><div style=\"text-align: center;\">" + houseInfo.getCityTitle() + ", " + houseInfo.getStreetTitle() + ", " + houseInfo.getHouse() + "</div></html>");
        });
        this.attrAddress.setHouseId(houseId);
        try {
            this.attrAddress.setFormatKey(this.attrAddress.getFormatKey() == null ? "0" : this.attrAddress.getFormatKey());
            this.setAddressFormatTableData(this.attrAddress);
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
    }

    private void addExtraParamsToMap(Element extraParams, Map<String, String> map) {
        if (extraParams != null) {
            this.entranceRange = null;
            this.floorRange = null;
            for (Element item : XMLUtils.elements(extraParams.getChildNodes())) {
                String key = item.getAttribute("param_title");
                String value = item.getAttribute("param_value");
                String id = item.getAttribute("param_id");
                if (id.equals("floorRange")) {
                    this.floorRange = value;
                } else if (id.equals("entranceRange")) {
                    this.entranceRange = value;
                }
                map.put(key, value);
            }
        }
    }

    class AddressFormatTableModel
    extends BGTableModel<AddressFormatRow> {
        public AddressFormatTableModel() {
            super(AddressFormatTableModel.class.getName());
        }

        @Override
        protected void initColumns() {
            this.addColumn("X", 30, 30, 30, "select", true, new RadioTableCellRenderer(0));
            this.addColumn("\u0410\u0434\u0440\u0435\u0441", -1, -1, -1, "address", true, HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("ID", 50, 50, 50, "key", true, HorizontalAlignmentTableCellRenderer.CENTER());
        }
    }

    class AddressDocumentListener
    implements DocumentListener {
        AddressDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.updateTable(e);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.updateTable(e);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.updateTable(e);
        }

        private void updateTable(DocumentEvent e) {
            if (ContractParamAddressEditorDialog.this.needUpdateFormatTable && ContractParamAddressEditorDialog.this.attrAddress.getHouseId() > 0) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ContractParamAddressEditorDialog.this.attrAddress.setFlat(ContractParamAddressEditorDialog.this.flat.getText().trim());
                            ContractParamAddressEditorDialog.this.attrAddress.setRoom(ContractParamAddressEditorDialog.this.room.getText().trim());
                            ContractParamAddressEditorDialog.this.attrAddress.setFloor(Utils.parseInt(ContractParamAddressEditorDialog.this.floor.getText(), -100));
                            ContractParamAddressEditorDialog.this.attrAddress.setPod(Utils.parseInt(ContractParamAddressEditorDialog.this.pod.getText()));
                            ContractParamAddressEditorDialog.this.attrAddress.setComment(ContractParamAddressEditorDialog.this.addressComment.getText());
                            ContractParamAddressEditorDialog.this.setAddressFormatTableData(ContractParamAddressEditorDialog.this.attrAddress);
                        }
                        catch (Exception ex) {
                            ClientUtils.showErrorMessageDialog(ex);
                        }
                    }
                });
            }
        }
    }

    public static class AddressFormatRow {
        private String key;
        private boolean select;
        private String address;

        public String getKey() {
            return this.key;
        }

        public boolean isSelect() {
            return this.select;
        }

        public String getAddress() {
            return this.address;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public void setSelect(boolean select) {
            this.select = select;
        }

        public void setAddress(String address) {
            this.address = address;
        }
    }

    class AddressEditorFocusTraversalPolicy
    extends FocusTraversalPolicy {
        Vector<Component> order = null;

        public AddressEditorFocusTraversalPolicy(ContractParamAddressEditorDialog this$0, Vector<Component> order) {
            this.order = new Vector(order.size());
            this.order.addAll(order);
        }

        @Override
        public Component getComponentAfter(Container focusCycleRoot, Component aComponent) {
            int idx = (this.order.indexOf(aComponent) + 1) % this.order.size();
            return this.order.get(idx);
        }

        @Override
        public Component getComponentBefore(Container focusCycleRoot, Component aComponent) {
            int idx = this.order.indexOf(aComponent) - 1;
            if (idx < 0) {
                idx = this.order.size() - 1;
            }
            return this.order.get(idx);
        }

        @Override
        public Component getDefaultComponent(Container focusCycleRoot) {
            return this.order.get(0);
        }

        @Override
        public Component getLastComponent(Container focusCycleRoot) {
            return this.order.lastElement();
        }

        @Override
        public Component getFirstComponent(Container focusCycleRoot) {
            return this.order.get(0);
        }
    }
}

