/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.softline.server.service;

import jakarta.annotation.PostConstruct;
import jakarta.jws.WebService;
import jakarta.xml.bind.DatatypeConverter;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.security.MessageDigest;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.admin.mail.server.MailMsg;
import ru.bitel.bgbilling.kernel.admin.mail.server.bean.MailData;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.parameter.ContractParameterGroupAttr;
import ru.bitel.bgbilling.kernel.contract.api.common.service.ContractParameterService;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.modules.softline.common.SoftLineUtils;
import ru.bitel.bgbilling.modules.softline.common.bean.SoftLineProduct;
import ru.bitel.bgbilling.modules.softline.common.bean.SoftLineSubscription;
import ru.bitel.bgbilling.modules.softline.common.bean.SoftLineSubscriptionHistory;
import ru.bitel.bgbilling.modules.softline.common.bean.SoftLineSubscriptionStatus;
import ru.bitel.bgbilling.modules.softline.common.bean.SoftLineSubscriptionSuspendReason;
import ru.bitel.bgbilling.modules.softline.common.service.SoftLineSubscriptionService;
import ru.bitel.bgbilling.modules.softline.server.bean.ErrorCodes;
import ru.bitel.bgbilling.modules.softline.server.bean.SoftLineSubscriptionDao;
import ru.bitel.bgbilling.modules.softline.server.bean.SoftLineURL;
import ru.bitel.bgbilling.modules.softline.server.bean.SoftlineProductDao;
import ru.bitel.bgbilling.modules.softline.server.bean.SubscriptionHistoryDao;
import ru.bitel.bgbilling.modules.softline.server.mail.MailSendDownloadData;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Pair;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.SearchResult;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrEmail;

@WebService(endpointInterface="ru.bitel.bgbilling.modules.softline.common.service.SoftLineSubscriptionService")
public class SoftLineSubscriptionServiceImpl
extends AbstractService
implements SoftLineSubscriptionService {
    private static final int TYPE_EMAIL = 9;
    private SoftLineSubscriptionDao softLineSubscriptionDao;
    private SoftlineProductDao productDao;
    private SubscriptionHistoryDao historyDao;

    @PostConstruct
    public void init() {
        this.softLineSubscriptionDao = new SoftLineSubscriptionDao(this.getConnection(), this.moduleId);
        this.productDao = new SoftlineProductDao(this.getConnection(), this.moduleId);
        this.historyDao = new SubscriptionHistoryDao(this.getConnection(), this.moduleId);
    }

    public SearchResult<SoftLineSubscription> searchSubscriptions(Page page, Period period, int contractId, int subscriptionId, SoftLineSubscriptionStatus status, int productId) throws BGException {
        SearchResult searchResult = new SearchResult();
        if (page != null) {
            searchResult.setPage(page);
        }
        if (period != null) {
            searchResult.setPeriod(period);
        }
        this.softLineSubscriptionDao.searchSubscriptions((SearchResult<SoftLineSubscription>)searchResult, contractId, subscriptionId, status, productId);
        return searchResult;
    }

    public void activateSubscription(SoftLineSubscription subscription) throws BGException {
        this.tryCall(() -> {
            int productId = subscription.getProductId();
            int contractId = subscription.getContractId();
            SoftLineProduct product = (SoftLineProduct)this.productDao.get(productId);
            if (product == null) {
                throw new BGMessageException("\u041f\u0440\u043e\u0434\u0443\u043a\u0442 \u0434\u043b\u044f \u0434\u0430\u043d\u043d\u043e\u0439 \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0438 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d");
            }
            if (!SoftLineUtils.checkActivation((Connection)this.getConnection(), (SoftLineSubscription)subscription, (SoftLineProduct)product)) {
                throw new BGMessageException("\u041d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043e\u0447\u043d\u043e \u0441\u0440\u0435\u0434\u0441\u0442\u0432 \u0434\u043b\u044f \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438 \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0438");
            }
            HttpURLConnection urlConnection = this.getURLConnection(SoftLineURL.ACTIVATE, this.getActivateHeader(contractId, product.getSoftLineCode(), subscription.getEmail()));
            String response = this.getResponse(urlConnection);
            JSONObject responseJson = new JSONObject(response);
            int errorCode = responseJson.getInt("code");
            if (errorCode == 0) {
                this.softLineSubscriptionDao.update(subscription);
                SoftLineUtils.addContractAccount((Connection)this.getConnection(), (int)this.moduleId, (SoftLineSubscription)subscription, (Date)new Date());
                this.insertDownloadData(subscription);
            } else {
                String errorMessage = ErrorCodes.getMessage(errorCode);
                if (Utils.isBlankString((String)errorMessage)) {
                    errorMessage = "\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430";
                }
                this.processException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432 \u043e\u0442\u0432\u0435\u0442\u0435 \u043e\u0442 SoftLine \u043f\u0440\u0438 \u043f\u043e\u043f\u044b\u0442\u043a\u0435 \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438 \u0434\u043b\u044f \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430: " + contractId + ". \u041e\u0448\u0438\u0431\u043a\u0430: " + errorMessage + ". \u0422\u0435\u043a\u0441\u0442 \u043e\u0448\u0438\u0431\u043a\u0438 \u0432 \u043e\u0442\u0432\u0435\u0442\u0435 \u043e\u0442 \u0441\u0435\u0440\u0432\u0435\u0440\u0430: " + String.valueOf(responseJson.get("message")), null);
            }
        });
    }

    private String getActivateHeader(int contractId, String softLineCode, String email) throws Exception {
        softLineCode = softLineCode.trim();
        String header = "?productCode=" + softLineCode + "&userId=" + contractId;
        if (Utils.notBlankString((String)email)) {
            header = header + "&email=" + email;
            header = header + "&sign=" + this.getSignString(email, softLineCode, String.valueOf(contractId));
        } else {
            header = header + "&sign=" + this.getSignString(softLineCode, String.valueOf(contractId));
        }
        return header;
    }

    public void insertDownloadData(SoftLineSubscription subscription) throws BGException {
        this.tryCall(() -> {
            if (subscription.getStatus() != SoftLineSubscriptionStatus.ACTIVE.getCode()) {
                throw new BGMessageException("\u041f\u043e\u0434\u043f\u0438\u0441\u043a\u0430 \u043d\u0435 \u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u043d\u0430. \u041f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0435 \u0434\u0430\u043d\u043d\u044b\u0445 \u0434\u043b\u044f \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0438 \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430 \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e.");
            }
            SoftLineProduct product = (SoftLineProduct)this.productDao.get(subscription.getProductId());
            if (product == null) {
                throw new BGMessageException("\u041f\u0440\u043e\u0434\u0443\u043a\u0442 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d");
            }
            HttpURLConnection connection = this.getURLConnection(SoftLineURL.GET_SHIPPING_DATA, this.getHeaderShippingData(String.valueOf(subscription.getContractId()), product.getSoftLineCode()));
            String response = this.getResponse(connection);
            JSONObject responseJson = new JSONObject(response);
            int responseCode = responseJson.getInt("code");
            if (responseCode != 0) {
                throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0438 \u0434\u0438\u0441\u0442\u0440\u0438\u0431\u0443\u0442\u0438\u0432\u0430 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0438. \u041a\u043e\u0434 \u043e\u0442\u0432\u0435\u0442\u0430 \u043e\u0442 SoftLine: " + responseCode + " \u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435: " + ErrorCodes.getMessage(responseCode));
            }
            subscription.setDownloadData(responseJson.toString());
        });
    }

    public void subscriptionPause(SoftLineSubscription subscription, SoftLineSubscriptionSuspendReason reason) throws BGException {
        this.tryCall(() -> {
            SoftLineProduct product = (SoftLineProduct)this.productDao.get(subscription.getProductId());
            if (product == null) {
                throw new BGMessageException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u043f\u0440\u043e\u0434\u0443\u043a\u0442 \u0434\u043b\u044f \u0434\u0430\u043d\u043d\u043e\u0439 \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0438");
            }
            String header = this.getPauseHeader(subscription.getContractId(), product.getSoftLineCode(), reason == null ? SoftLineSubscriptionSuspendReason.FIN_BLOCK : reason);
            HttpURLConnection connection = this.getURLConnection(SoftLineURL.PAUSE, header);
            JSONObject response = new JSONObject(this.getResponse(connection));
            int errorCode = response.getInt("code");
            if (errorCode == 0 || errorCode == -6) {
                if (this.checkSuspendSubscription(subscription)) {
                    subscription.setStatus(SoftLineSubscriptionStatus.SUSPEND.getCode());
                    subscription.setSuspendReason(reason);
                    subscription.setEndDate(new Date());
                    this.softLineSubscriptionDao.update(subscription);
                }
            } else {
                this.processException(ErrorCodes.getMessage(errorCode), null);
            }
        });
    }

    private boolean checkSuspendSubscription(SoftLineSubscription subscription) throws Exception {
        HttpURLConnection connection = this.getURLConnection(SoftLineURL.GET_ACCOUNT_INFO, this.getAccountInfoHeader(subscription.getContractId()));
        JSONObject response = new JSONObject(this.getResponse(connection));
        int errorCode = response.getInt("code");
        if (errorCode == 0) {
            JSONArray subscriptions = response.getJSONArray("subscriptions");
            if (subscriptions == null) {
                return false;
            }
            SoftLineProduct product = (SoftLineProduct)new SoftlineProductDao(this.getConnection(), this.moduleId).get(subscription.getProductId());
            for (int x = 0; x < subscriptions.length(); ++x) {
                String status;
                JSONObject sub = subscriptions.getJSONObject(x);
                if (!sub.getString("productCode").equals(product.getSoftLineCode()) || !(status = sub.getString("status")).equals("suspend")) continue;
                return true;
            }
        } else {
            this.processException(ErrorCodes.getMessage(errorCode), null);
        }
        return false;
    }

    public void checkSubscriptionStatus(SoftLineSubscription subscription) throws BGException {
        this.tryCall(() -> {
            boolean isSuspend = this.checkSuspendSubscription(subscription);
            if (subscription.getStatus() == SoftLineSubscriptionStatus.SUSPEND.getCode() && isSuspend || subscription.getStatus() == SoftLineSubscriptionStatus.ACTIVE.getCode() && !isSuspend) {
                if (isSuspend) {
                    subscription.setStatus(SoftLineSubscriptionStatus.SUSPEND.getCode());
                } else {
                    subscription.setStatus(SoftLineSubscriptionStatus.ACTIVE.getCode());
                }
                this.softLineSubscriptionDao.update(subscription);
            }
        });
    }

    private String getAccountInfoHeader(int contractId) throws Exception {
        return "?userId=" + contractId + "&sign=" + this.getSignString(String.valueOf(contractId));
    }

    private String getPauseHeader(int contractId, String productCode, SoftLineSubscriptionSuspendReason reason) throws Exception {
        return "?userId=" + contractId + "&productCode=" + productCode + "&reason=" + String.valueOf(reason) + "&sign=" + this.getSignString(productCode, reason.toString(), String.valueOf(contractId));
    }

    public void deleteSubscription(SoftLineSubscription subscription, boolean cancelActiveSubscription) throws BGException {
        this.tryCall(() -> {
            if (cancelActiveSubscription && subscription.getStatus() == SoftLineSubscriptionStatus.ACTIVE.getCode()) {
                this.subscriptionPause(subscription, SoftLineSubscriptionSuspendReason.FIN_BLOCK);
            }
            SoftLineSubscription actual = (SoftLineSubscription)this.softLineSubscriptionDao.get(subscription.getId());
            if (cancelActiveSubscription && actual.getStatus() == SoftLineSubscriptionStatus.ACTIVE.getCode()) {
                throw new BGMessageException("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0443. \u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u043d\u0435 \u0431\u044b\u043b\u043e \u043f\u0440\u043e\u0438\u0437\u0432\u0435\u0434\u0435\u043d\u043e");
            }
            try (SubscriptionHistoryDao historyDao = new SubscriptionHistoryDao(this.getConnection(), this.moduleId);){
                historyDao.deleteHistoryOfSubscription(subscription.getId());
            }
            this.softLineSubscriptionDao.delete(subscription.getId());
        });
    }

    public void updateSubscription(SoftLineSubscription actualSubscription) throws BGException {
        this.tryCall(() -> {
            int subsId = actualSubscription.getId();
            if (subsId > 0) {
                SoftLineSubscription oldSubs = (SoftLineSubscription)this.softLineSubscriptionDao.get(subsId);
                if (oldSubs.getStatus() != actualSubscription.getStatus()) {
                    SoftLineSubscriptionStatus actualStatus = SoftLineSubscriptionStatus.valueOf((int)actualSubscription.getStatus());
                    if (actualStatus == null) {
                        return;
                    }
                    switch (actualStatus) {
                        case ACTIVE: {
                            SoftLineProduct product = (SoftLineProduct)this.productDao.get(actualSubscription.getProductId());
                            if (!SoftLineUtils.checkActivation((Connection)this.getConnection(), (SoftLineSubscription)actualSubscription, (SoftLineProduct)product)) {
                                throw new BGMessageException("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0443. \u041d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043e\u0447\u043d\u043e \u0441\u0440\u0435\u0434\u0441\u0442\u0432");
                            }
                            this.activateSubscription(actualSubscription);
                            break;
                        }
                        case SUSPEND: {
                            this.subscriptionPause(actualSubscription, SoftLineSubscriptionSuspendReason.USER_REFUSE);
                        }
                    }
                }
                this.softLineSubscriptionDao.update(actualSubscription);
            } else if (actualSubscription.getStatus() == SoftLineSubscriptionStatus.ACTIVE.getCode()) {
                this.activateSubscription(actualSubscription);
            } else {
                this.softLineSubscriptionDao.update(actualSubscription);
            }
        });
    }

    public void checkStatusSoftLine() throws BGException {
        this.tryCall(() -> {
            HttpURLConnection connection = this.getURLConnection(SoftLineURL.CHECK_SYSTEM, "");
            JSONObject responseJson = new JSONObject(this.getResponse(connection));
            int responseCode = connection.getResponseCode();
            if (responseCode != 200 && !responseJson.get("status").equals("0")) {
                throw new BGMessageException("\u041d\u0430 \u0434\u0430\u043d\u043d\u044b\u0439 \u043c\u043e\u043c\u0435\u043d\u0442 \u0441\u0438\u0441\u0442\u0435\u043c\u044b SoftLine \u043d\u0435\u0434\u043e\u0441\u0442\u0443\u043f\u043d\u044b, \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0430 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043d\u0435 \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0430");
            }
        });
    }

    private String getHeaderShippingData(String contractId, String softLineCode) throws Exception {
        return "?userId=" + contractId + "&productCode=" + softLineCode + "&sign=" + this.getSignString(softLineCode, contractId);
    }

    private HttpURLConnection getURLConnection(SoftLineURL method, String header) throws Exception {
        ModuleSetup moduleSetup = Setup.getSetup().getModuleSetup(Integer.valueOf(this.moduleId));
        boolean isTestWork = moduleSetup.getBoolean("testWork", false);
        String softLineURL = moduleSetup.get("URL");
        if (!isTestWork && Utils.isBlankString((String)softLineURL)) {
            throw new BGMessageException("\u0412 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438 \u043c\u043e\u0434\u0443\u043b\u044f \u043d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d\u0430 \u0441\u0441\u044b\u043b\u043a\u0430 \u0434\u043b\u044f \u0440\u0430\u0431\u043e\u0442\u044b \u0441 SoftLine!");
        }
        String body = method.getMethod() + header;
        URL url = URI.create(isTestWork ? SoftLineURL.TEST_URL.getMethod() + body : softLineURL + body).toURL();
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("\u0417\u0430\u043f\u0440\u043e\u0441 \u043a SoftLine: " + String.valueOf(url));
        }
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        connection.connect();
        return connection;
    }

    private String getResponse(HttpURLConnection connection) throws Exception {
        StringBuilder resultJson = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
            String line = null;
            while ((line = reader.readLine()) != null) {
                resultJson.append(line);
            }
        }
        this.getLogger().info("Response from SoftLine >> " + String.valueOf(resultJson));
        return resultJson.toString();
    }

    private String getSignString(String ... values) throws Exception {
        ModuleSetup moduleSetup = Setup.getSetup().getModuleSetup(Integer.valueOf(this.moduleId));
        String secret = moduleSetup.get("secret");
        if (Utils.isBlankString((String)secret)) {
            throw new BGMessageException("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u0441\u0435\u043a\u0440\u0435\u0442\u043d\u044b\u0439 \u043a\u043b\u044e\u0447 \u0438\u0437 \u043a\u043e\u043d\u0444\u0438\u0433\u0430 \u043c\u043e\u0434\u0443\u043b\u044f");
        }
        StringBuilder result = new StringBuilder();
        for (String value : values) {
            if (Utils.isBlankString((String)value)) continue;
            result.append(value);
            result.append(",");
        }
        result.append(secret);
        MessageDigest md = MessageDigest.getInstance("MD5");
        md.update(result.toString().getBytes());
        return DatatypeConverter.printHexBinary((byte[])md.digest()).toLowerCase();
    }

    public void sendDownloadDataOnUserEmail(SoftLineSubscription subscription, String userEmail) throws BGException {
        this.tryCall(() -> {
            if (subscription.getDownloadData() == null) {
                this.insertDownloadData(subscription);
            }
            ModuleSetup setup = Setup.getSetup().getModuleSetup(Integer.valueOf(this.moduleId));
            String headerText = setup.get("softline.email.header");
            MailSendDownloadData mailData = new MailSendDownloadData();
            mailData.setModuleId(this.moduleId);
            mailData.setRecipients(userEmail);
            mailData.setSubject(Utils.isBlankString((String)headerText) ? "\u0414\u0430\u043d\u043d\u044b\u0435 \u0434\u043b\u044f \u043e\u0444\u043e\u0440\u043c\u043b\u0435\u043d\u043d\u043e\u0439 \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0438" : headerText);
            mailData.addTextPart("text", this.getEmailMessage(subscription, setup.get("softline.email.message")));
            new MailMsg((Preferences)this.getSetup()).sendMessage((MailData)mailData);
        });
    }

    private String getEmailMessage(SoftLineSubscription subscription, String message) {
        Pair<String, String> pair;
        Map<String, String> distributionsList;
        StringBuilder mailBody = new StringBuilder();
        String guideLink = this.getGuideLink(subscription.getDownloadData());
        if (Utils.notBlankString((String)guideLink)) {
            mailBody.append("\u0418\u043d\u0441\u0442\u0440\u0443\u043a\u0446\u0438\u044f \u043f\u043e \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0435:\t").append(guideLink).append("\n");
        }
        if ((distributionsList = this.getDistributionsList(subscription.getDownloadData())).size() > 0) {
            mailBody.append("\n\u0414\u0438\u0441\u0442\u0440\u0438\u0431\u0443\u0442\u0438\u0432\u044b \u0434\u043b\u044f \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0438:\n");
            distributionsList.forEach((key, value) -> mailBody.append((String)key).append("\t").append((String)value).append("\n"));
        }
        if ((pair = this.getInstallKey(subscription.getDownloadData())) != null) {
            mailBody.append("\n\u041a\u043b\u044e\u0447:\t");
            mailBody.append((String)pair.getSecond());
        }
        if (Utils.notBlankString((String)message)) {
            mailBody.append("\n\n\t").append(message);
        }
        return mailBody.toString();
    }

    public void recalculate(int contractId, Calendar month) throws BGException {
        throw new UnsupportedOperationException("\u041f\u043e\u043a\u0430 \u043d\u0435 \u0440\u0435\u0430\u043b\u0438\u0437\u043e\u0432\u0430\u043d\u043e");
    }

    private void processException(String errorMessage, Exception exception) throws Exception {
        String exceptionMessage = exception == null ? "" : exception.getMessage();
        this.getLogger().error(errorMessage + " " + exceptionMessage);
        if (exception == null) {
            throw new BGMessageException(errorMessage);
        }
        throw new Exception(exception);
    }

    public String getGuideLink(String downloadData) {
        JSONObject downloadDataJSON;
        if (Utils.notBlankString((String)downloadData) && (downloadDataJSON = new JSONObject(downloadData)).has("guideList")) {
            JSONObject link = (JSONObject)downloadDataJSON.get("guideList");
            return link.getString("\u0418\u043d\u0441\u0442\u0440\u0443\u043a\u0446\u0438\u044f \u043f\u043e \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0435");
        }
        return "";
    }

    public Map<String, String> getDistributionsList(String downloadData) {
        JSONObject downloadDataJSON;
        HashMap<String, String> result = new HashMap<String, String>();
        if (Utils.notBlankString((String)downloadData) && (downloadDataJSON = new JSONObject(downloadData)).has("distrList")) {
            JSONArray distrList = downloadDataJSON.getJSONArray("distrList");
            for (int x = 0; x < distrList.length(); ++x) {
                JSONObject entry = distrList.getJSONObject(x);
                result.put(entry.getString("name"), entry.getString("value"));
            }
        }
        return result;
    }

    public Pair<String, String> getInstallKey(String downloadData) {
        int embeddedKey;
        JSONObject downloadDataJSON;
        Pair result = null;
        if (Utils.notBlankString((String)downloadData) && (downloadDataJSON = new JSONObject(downloadData)).has("embeddedKey") && (embeddedKey = downloadDataJSON.getInt("embeddedKey")) == 0) {
            result = new Pair();
            JSONArray array = downloadDataJSON.getJSONArray("keyList");
            JSONObject json = array.getJSONObject(0);
            result.setFirst((Object)json.optString("name"));
            result.setSecond((Object)json.optString("value"));
        }
        return result;
    }

    public List<IdTitle> getEmailsByContract(int cid) throws BGException {
        ArrayList<IdTitle> emailsByContract = new ArrayList<IdTitle>();
        ServerContext serverContext = (ServerContext)ServerContext.get();
        ArrayList emailsParams = new ArrayList();
        ((ContractParameterService)serverContext.getService(ContractParameterService.class, this.moduleId)).contractParameterGroupAttrList().stream().filter(p -> p.getType() == 9).forEach(p -> emailsParams.add(p));
        try (ContractDao contractDao = new ContractDao(this.getConnection(), this.userId);){
            for (ContractParameterGroupAttr groupAttr : emailsParams) {
                Optional attrEmail = contractDao.getContractParameterEmail(cid, groupAttr.getId());
                if (!attrEmail.isPresent()) continue;
                emailsByContract.addAll(((EntityAttrEmail)attrEmail.get()).getAddressList().stream().map(a -> new IdTitle(groupAttr.getId(), a)).toList());
            }
        }
        return emailsByContract;
    }

    public SearchResult<SoftLineSubscriptionHistory> searchHistory(Page page, Period period, int contractId, int subscriptionId, int productId) throws BGException {
        return (SearchResult)this.tryReturn(() -> {
            this.historyDao = new SubscriptionHistoryDao(this.getConnection(), this.moduleId);
            SearchResult searchResult = new SearchResult();
            if (page != null) {
                searchResult.setPage(page);
            }
            if (period != null) {
                searchResult.setPeriod(period);
            }
            this.historyDao.searchHistory((SearchResult<SoftLineSubscriptionHistory>)searchResult, contractId, subscriptionId, productId);
            return searchResult;
        });
    }
}

