/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.server.dhcp.connection;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.inet.server.dhcp.InetDhcpDevice;
import ru.bitel.bgbilling.modules.inet.server.dhcp.InetDhcpDeviceMap;
import ru.bitel.bgbilling.modules.inet.server.dhcp.connection.InetDhcpConnectionEntry;
import ru.bitel.bgbilling.modules.inet.server.dhcp.connection.InetDhcpConnectionKey;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetApplication;
import ru.bitel.bgbilling.modules.inet.server.runtime.connection.InetConnectionMap;
import ru.bitel.common.Utils;
import ru.bitel.common.util.CopyOnWriteArrayMap;

public class InetDhcpConnectionMap
extends InetConnectionMap<InetDhcpDevice, InetDhcpConnectionKey, InetDhcpConnectionEntry> {
    private static final Pattern macrosPattern = Pattern.compile("\\$\\w+");
    private final ConcurrentMap<String, KeyPattern> patternMap = new ConcurrentHashMap<String, KeyPattern>();
    private final InetDhcpDeviceMap deviceMap;
    protected final AddressMap addressMap = new AddressMap();
    protected final boolean needConnectionMap;
    protected final boolean needAddressMap;
    private volatile Set<Integer> keyDeviceTypeIds;

    private KeyPattern getPattern(String pattern) {
        KeyPattern result = (KeyPattern)this.patternMap.get(pattern);
        if (result != null) {
            return result;
        }
        result = new KeyPattern(pattern);
        this.patternMap.putIfAbsent(pattern, result);
        return result;
    }

    public InetDhcpConnectionMap(InetApplication application, InetDhcpDeviceMap deviceMap, boolean needConnectionMap, boolean needAddressMap) throws BGException {
        super(application, true, needConnectionMap, needConnectionMap || needAddressMap);
        this.deviceMap = deviceMap;
        this.needConnectionMap = needConnectionMap;
        this.needAddressMap = needAddressMap;
        this.init();
    }

    public void load(Set<Integer> keyDeviceTypeIds) {
        this.keyDeviceTypeIds = keyDeviceTypeIds;
        super.load();
    }

    public void setKeyDeviceTypeIds(Set<Integer> keyDeviceTypeIds) {
        this.keyDeviceTypeIds = keyDeviceTypeIds;
    }

    @Override
    protected InetDhcpConnectionEntry put(Object key, boolean accounting, int ipResourceId, byte[] address, int servId, long connectionId) {
        InetDhcpConnectionEntry entry = this.newEntry(ipResourceId, address, servId, connectionId);
        if (this.needConnectionMap) {
            InetDhcpConnectionEntry oldEntry = this.connectionMap.put(key, entry);
            if (this.needAddressMap && oldEntry != null && oldEntry.address > 0) {
                this.addressMap.remove(oldEntry.address, oldEntry);
            }
        }
        if (this.needAddressMap && entry.address != 0 && entry.connectionId > 0L) {
            this.addressMap.add(entry.address, entry);
        }
        return null;
    }

    @Override
    protected void remove(Object key, byte[] address, InetDhcpConnectionEntry entry) {
        if (this.needConnectionMap) {
            this.connectionMap.remove(key, entry);
        }
        if (this.needAddressMap && entry.address != 0 && entry.connectionId > 0L) {
            this.addressMap.remove(entry.address, entry);
        }
    }

    protected InetDhcpConnectionEntry[] newArray(int size) {
        return new InetDhcpConnectionEntry[size];
    }

    protected InetDhcpConnectionEntry[] newArray(InetDhcpConnectionEntry e) {
        return new InetDhcpConnectionEntry[]{e};
    }

    @Override
    protected long getConnectionId(InetDhcpConnectionEntry entry) {
        return entry.connectionId;
    }

    @Override
    protected String getPattern(InetDhcpDevice device) {
        return device != null ? device.dhcpKeyPattern : "$deviceId:$remoteId:$circuitId:$mac";
    }

    @Override
    protected InetDhcpConnectionKey getKey(InetDhcpDevice device, int deviceId, int agentDeviceId, int circuitId, String mac, byte[] address) {
        KeyPattern pattern = this.getPattern(this.getPattern(device));
        return pattern.newKey(deviceId, agentDeviceId, circuitId, mac, address);
    }

    @Override
    protected InetDhcpConnectionEntry newEntry(int ipResourceId, byte[] address, int servId, long connectionId) {
        return new InetDhcpConnectionEntry(ipResourceId, Utils.convertBytesToInt((byte[])address), servId, connectionId);
    }

    public InetDhcpConnectionEntry[] get(int address) {
        return this.addressMap.get(address);
    }

    @Override
    protected int getServSearchMode(InetDhcpDevice device) {
        Set<Integer> keyDeviceTypeIds = this.keyDeviceTypeIds;
        if (keyDeviceTypeIds != null && keyDeviceTypeIds.contains(device.deviceRuntime.inetDevice.getDeviceTypeId())) {
            return device.radiusServSearchModes[0][0];
        }
        return device.servSearchModes[0][0];
    }

    @Override
    protected InetDhcpDevice getDevice(int deviceId) {
        return this.deviceMap.get(deviceId);
    }

    @Override
    protected boolean isAccessAcceptUsed(InetDhcpDevice device) {
        if (device == null) {
            return false;
        }
        Set<Integer> keyDeviceTypeIds = this.keyDeviceTypeIds;
        return keyDeviceTypeIds != null && keyDeviceTypeIds.contains(device.deviceRuntime.inetDevice.getDeviceTypeId());
    }

    @Override
    protected boolean isAccountingUsed(InetDhcpDevice device) {
        return device != null;
    }

    static class KeyPattern {
        final boolean deviceId;
        final boolean agentDeviceId;
        final boolean circuitId;
        final boolean mac;
        final boolean ipAddress;
        private static final Pattern macClearPattern = Pattern.compile("[\\s\\.:\\-\\\\\\$]+");

        KeyPattern(String pattern) {
            boolean deviceId = false;
            boolean agentDeviceId = false;
            boolean circuitId = false;
            boolean mac = false;
            boolean ipAddress = false;
            Matcher m = macrosPattern.matcher(pattern);
            while (m.find()) {
                String param = m.group();
                if ("$deviceId".equals(param)) {
                    deviceId = true;
                    continue;
                }
                if ("$remoteId".equals(param)) {
                    agentDeviceId = true;
                    continue;
                }
                if ("$circuitId".equals(param)) {
                    circuitId = true;
                    continue;
                }
                if ("$mac".equals(param)) {
                    mac = true;
                    continue;
                }
                if (!"$ip".equals(param)) continue;
                ipAddress = true;
            }
            this.deviceId = deviceId;
            this.agentDeviceId = agentDeviceId;
            this.circuitId = circuitId;
            this.mac = mac;
            this.ipAddress = ipAddress;
        }

        public InetDhcpConnectionKey newKey(int deviceId, int agentDeviceId, int circuitId, String mac, byte[] address) {
            if (this.mac && mac != null && mac.length() > 0) {
                mac = macClearPattern.matcher(mac).replaceAll("").toUpperCase();
            }
            return new InetDhcpConnectionKey(this.deviceId ? deviceId : 0, this.agentDeviceId ? agentDeviceId : 0, this.circuitId ? circuitId : 0, this.mac ? mac : null, this.ipAddress ? Utils.convertBytesToInt((byte[])address) : 0);
        }
    }

    static final class AddressMap
    extends CopyOnWriteArrayMap<Integer, InetDhcpConnectionEntry> {
        public AddressMap() {
            super(64);
        }

        protected InetDhcpConnectionEntry[] newArray(int size) {
            return new InetDhcpConnectionEntry[size];
        }

        protected InetDhcpConnectionEntry[] newArray(InetDhcpConnectionEntry r) {
            return new InetDhcpConnectionEntry[]{r};
        }

        public InetDhcpConnectionEntry[] get(Integer key) {
            return (InetDhcpConnectionEntry[])this.arrayMap.get(key);
        }
    }
}

