/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.admin.license.server.service;

import bitel.billing.common.VersionInfo;
import bitel.billing.server.Server;
import bitel.billing.server.util.FileUtils;
import jakarta.jws.WebService;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.admin.license.common.bean.LicenseData;
import ru.bitel.bgbilling.kernel.admin.license.common.bean.LicenseDataDTO;
import ru.bitel.bgbilling.kernel.admin.license.common.bean.LicenseItemData;
import ru.bitel.bgbilling.kernel.admin.license.common.bean.Storage;
import ru.bitel.bgbilling.kernel.admin.license.common.service.LicenseService;
import ru.bitel.bgbilling.kernel.admin.license.server.bean.LicenseLocalDao;
import ru.bitel.bgbilling.kernel.admin.license.server.bean.LicenseRemoteDao;
import ru.bitel.bgbilling.kernel.admin.license.server.bean.Temp;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

@WebService(endpointInterface="ru.bitel.bgbilling.kernel.admin.license.common.service.LicenseService")
public class LicenseServiceImpl
extends AbstractService
implements LicenseService {
    private static final String FILE_LICENSE = "data" + File.separatorChar + "lic.properties";
    private static List<LicenseData> remoteList = new ArrayList<LicenseData>();
    private static LicenseData fileLicenseData = null;
    private Date maximumBuildTime = null;

    @Override
    public void init() throws BGException {
        this.tryCall(() -> {
            LicenseRemoteDao licenseRemoteDao = new LicenseRemoteDao();
            File file = new File(FILE_LICENSE);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try (FileInputStream fileInputStream = new FileInputStream(file);){
                byte[] buf = new byte[1024];
                int b = 0;
                while ((b = fileInputStream.read(buf)) > -1) {
                    byteArrayOutputStream.write(buf, 0, b);
                }
            }
            String hash = Utils.bytesToHexString(Utils.getDigestBytes(byteArrayOutputStream.toByteArray(), "SHA-256"));
            fileLicenseData = new LicenseData().setActive(true).setCreateDate(new Date(file.lastModified())).setCount(new String(byteArrayOutputStream.toByteArray()).split("\n").length - 2).setStorage(Storage.FILE).setHash(hash);
            boolean setActive = false;
            LicenseLocalDao licenseLocalDao = new LicenseLocalDao(this.getConnection());
            for (LicenseData licenseData : licenseLocalDao.getLicenseDataList()) {
                if (!licenseData.getHash().equals(hash)) continue;
                if (!licenseData.isActive()) {
                    this.licenseDataActivate(licenseData.getId());
                }
                setActive = true;
                break;
            }
            remoteList = licenseRemoteDao.list();
            if (!setActive) {
                remoteList.stream().filter(a -> a.getHash().equals(hash)).forEach(a -> a.setActive(true));
            }
        });
    }

    @Override
    public List<LicenseDataDTO> licenseDataList() throws BGException {
        return this.tryReturn(() -> {
            ArrayList<LicenseDataDTO> list = new ArrayList<LicenseDataDTO>();
            boolean fl = false;
            LicenseLocalDao licenseLocalDao = new LicenseLocalDao(this.getConnection());
            list.addAll(licenseLocalDao.getLicenseDataList().stream().map(LicenseData::toLicenseDataDTO).toList());
            List<LicenseData> rList = remoteList;
            ArrayList<LicenseDataDTO> added = new ArrayList<LicenseDataDTO>();
            for (LicenseData licenseData : rList) {
                if (list.stream().anyMatch(a -> a.getId() == licenseData.getId())) continue;
                added.add(licenseData.toLicenseDataDTO());
            }
            list.addAll(added);
            Collections.sort(list, Collections.reverseOrder());
            if (fileLicenseData != null) {
                for (LicenseDataDTO licenseDataDTO : list) {
                    if (!fileLicenseData.getHash().equals(licenseDataDTO.getHash())) continue;
                    if (!licenseDataDTO.isActive()) {
                        this.licenseDataActivate(licenseDataDTO.getId());
                    }
                    fl = true;
                    break;
                }
                if (!fl) {
                    list.add(0, fileLicenseData.toLicenseDataDTO());
                }
            } else {
                System.out.println("fileLicenseData = " + String.valueOf(fileLicenseData));
            }
            return list;
        });
    }

    @Override
    public LicenseData licenseDataGet(int licenseId) throws BGException {
        return this.tryReturn(() -> {
            LicenseData licenseData = new LicenseLocalDao(this.getConnection()).getLicenseData(licenseId);
            if (licenseData == null) {
                licenseData = this.licenseDataLoad(licenseId);
            }
            return licenseData;
        });
    }

    @Override
    public LicenseData licenseDataLoad(int licenseId) throws BGException {
        return this.tryReturn(() -> {
            LicenseData licenseData = null;
            String licenseText = null;
            LicenseRemoteDao licenseRemoteDao = new LicenseRemoteDao();
            licenseText = licenseRemoteDao.getLicenseText(licenseId);
            if (licenseText != null && licenseText.startsWith("{")) {
                JSONObject licenseJson = new JSONObject(licenseText);
                if (licenseJson.has("license")) {
                    JSONArray licenseItems = licenseJson.getJSONArray("license");
                    String encryptData = new String(Base64.getDecoder().decode(licenseJson.getString("encrypt").getBytes("UTF-8")), "UTF-8");
                    licenseData = new LicenseData().setId(licenseId).setActive(false).setCreateDate(new Date(licenseJson.optLong("date"))).setCount(licenseItems.length()).setPlainData(licenseItems.toString()).setEncryptData(encryptData).setStorage(Storage.DATABASE).setHash(Utils.getDigest(encryptData, "UTF-8", "SHA-256"));
                    new LicenseLocalDao(this.getConnection()).update(licenseData);
                }
            } else {
                throw new BGMessageException("\u0421\u0431\u043e\u0439 \u043f\u0440\u0438 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0435 \u0434\u0430\u043d\u043d\u044b\u0445 \u043b\u0438\u0446\u0435\u043d\u0437\u0438\u0438, \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u043e:\n\n" + licenseText);
            }
            return licenseData;
        });
    }

    @Override
    public void licenseDataDelete(int licenseId) throws BGException {
        this.tryCall(() -> new LicenseLocalDao(this.getConnection()).deleteLicenseData(licenseId));
    }

    @Override
    public void licenseDataActivate(int licenseId) throws BGException {
        this.tryCall(() -> {
            LicenseData licenseData = this.licenseDataGet(licenseId);
            if (licenseData != null) {
                LicenseLocalDao licenseLocalDao = new LicenseLocalDao(this.getConnection());
                licenseLocalDao.activateLicenseData(licenseId);
                List<LicenseData> rList = remoteList;
                rList.stream().forEach(a -> a.setActive(false));
                try (FileOutputStream fileOutputStream = new FileOutputStream(FILE_LICENSE);){
                    fileOutputStream.write(licenseData.getEncryptData().getBytes("Cp1251"));
                    fileOutputStream.flush();
                }
                FileUtils.getInstance().reload();
                Temp.getTemp().init();
                licenseData.setActive(true);
                licenseData.setStorage(Storage.FILE);
                fileLicenseData = licenseData;
            }
        });
    }

    @Override
    public List<LicenseItemData> currentLicenseList() throws BGException {
        ArrayList<LicenseItemData> list = new ArrayList<LicenseItemData>();
        Temp temp = Temp.getTemp();
        for (String name : temp.getMName()) {
            list.add(new LicenseItemData().setTitle(name).setCount(temp.getMCurrContract(name) + ":" + temp.getMMaxContract(name)).setDate(temp.getMDateAvail(name).format(DateTimeFormatter.ofPattern("dd.MM.yyyy"))));
        }
        return list;
    }

    @Override
    public String aboutGet() throws BGException {
        return this.tryReturn(() -> {
            JSONObject client = new JSONObject();
            JSONObject server = new JSONObject();
            JSONArray modules = new JSONArray();
            String query = "SELECT name FROM installed_modules WHERE type IN ('module', 'plugin') ORDER BY name";
            try (Statement st = this.getConnection().createStatement();
                 ResultSet rs = st.executeQuery(query);){
                while (rs.next()) {
                    String name = rs.getString(1);
                    VersionInfo vi = VersionInfo.getVersionInfo(name);
                    JSONObject module = new JSONObject().put("name", (Object)name).put("version", (Object)vi.getVersion()).put("build.time", (Object)vi.getBuildTime()).put("build.number", (Object)vi.getBuildNumber()).put("versionstring", (Object)vi.getVersionString());
                    this.checkLastBuildTime(vi.getBuildTime());
                    modules.put((Object)module);
                }
            }
            server.put("server", (Object)Utils.getOsJavaVersion(false));
            server.put("serverfull", (Object)Utils.getOsJavaVersion(true));
            SimpleDateFormat df = new SimpleDateFormat("dd.MM.yyyy HH:mm z Z");
            server.put("servertime", (Object)(df.format(new Date()) + " (" + TimeZone.getDefault().getID() + ")"));
            server.put("memory", (Object)Utils.memoryStatusShort());
            server.put("serverlocale", (Object)Locale.getDefault().toString());
            server.put("servercharset", (Object)Charset.defaultCharset().toString());
            server.put("serverdbtime", (Object)this.getDbInfos());
            server.put("serverdbcharset", (Object)this.getDbCharsets());
            server.put("uptimestatus", (Object)ServerUtils.uptimeStatus((Date)Server.START_TIME).replace('\t', ' '));
            try {
                Utils.checkJava();
            }
            catch (BGException e) {
                for (String line : Utils.toList(e.getMessage(), "\n")) {
                    server.put("server", (Object)(server.getString("server") + "\n    \u0412\u041d\u0418\u041c\u0410\u041d\u0418\u0415: " + line));
                }
            }
            VersionInfo versionInfo = VersionInfo.getVersionInfo("kernel");
            server.put("version", (Object)versionInfo.getVersion());
            server.put("build.time", (Object)versionInfo.getBuildTime());
            server.put("build.number", (Object)versionInfo.getBuildNumber());
            server.put("versionstring", (Object)versionInfo.getVersionString());
            this.checkLastBuildTime(versionInfo.getBuildTime());
            VersionInfo clientVersionInfo = VersionInfo.getVersionInfo("kernel");
            if (clientVersionInfo != null) {
                client.put("version", (Object)clientVersionInfo.getVersion());
                client.put("build.time", (Object)clientVersionInfo.getBuildTime());
                client.put("build.number", (Object)clientVersionInfo.getBuildNumber());
                client.put("versionstring", (Object)clientVersionInfo.getVersionString());
                this.checkLastBuildTime(clientVersionInfo.getBuildTime());
            }
            if (this.maximumBuildTime != null && this.maximumBuildTime.after(Server.START_TIME)) {
                server.put("uptimestatus_warning", (Object)"\u041a\u0430\u0436\u0435\u0442\u0441\u044f, \u0441\u0435\u0440\u0432\u0435\u0440 \u043d\u0435 \u043f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0436\u0430\u043b\u0441\u044f \u043f\u043e\u0441\u043b\u0435 \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f");
            }
            return new JSONObject().put("modules", (Object)modules).put("server", (Object)server).put("client", (Object)client).toString();
        });
    }

    private String getDbInfos() throws Exception {
        Connection baseCon;
        StringBuilder sb = new StringBuilder();
        HashSet<String> allvalues = new HashSet<String>();
        String dbNow = LicenseServiceImpl.getDbNow(this.getConnection());
        sb.append("master: ").append(dbNow);
        allvalues.add(dbNow);
        for (String id : this.getSetup().getSlaveBaseId()) {
            baseCon = this.getSetup().getSlaveConnectionFromPool(id);
            try {
                dbNow = LicenseServiceImpl.getDbNow(baseCon);
                sb.append(", ").append("slave@" + id + ": ").append(dbNow);
                allvalues.add(dbNow);
            }
            finally {
                if (baseCon == null) continue;
                baseCon.close();
            }
        }
        for (String id : this.getSetup().getTrashBaseId()) {
            baseCon = this.getSetup().getTrashConnectionFromPool(id);
            try {
                dbNow = LicenseServiceImpl.getDbNow(baseCon);
                sb.append(", ").append("trash@" + id + ": ").append(dbNow);
                allvalues.add(dbNow);
            }
            finally {
                if (baseCon == null) continue;
                baseCon.close();
            }
        }
        if (allvalues.size() != 1) {
            sb.append("\n    \u0412\u041d\u0418\u041c\u0410\u041d\u0418\u0415: \u0432 \u043d\u0435\u043a\u043e\u0442\u043e\u0440\u044b\u0445 \u0411\u0414 \u043f\u043e\u043f\u043b\u044b\u043b\u043e \u0432\u0440\u0435\u043c\u044f");
        }
        return sb.toString();
    }

    private static String getDbNow(Connection con) {
        Object serverdbtime = "?";
        String query = "SELECT DATE_FORMAT(NOW(),'%d.%m.%Y %H:%i'), if (@@session.time_zone = 'SYSTEM', @@system_time_zone, @@session.time_zone)";
        try (Statement st = con.createStatement();
             ResultSet rs = st.executeQuery(query);){
            if (rs.next()) {
                serverdbtime = rs.getString(1) + " " + rs.getString(2);
            }
        }
        catch (Exception ex) {
            serverdbtime = ex.toString();
        }
        return serverdbtime;
    }

    private String getDbCharsets() throws Exception {
        Object serverdbcharsets = "?";
        String query = "SELECT @@character_set_connection, @@collation_connection, @@character_set_database, @@collation_database";
        try (Statement st = this.getConnection().createStatement();
             ResultSet rs = st.executeQuery(query);){
            if (rs.next()) {
                String character_set_connection = rs.getString(1);
                String collation_connection = rs.getString(2);
                String character_set_database = rs.getString(3);
                String collation_database = rs.getString(4);
                serverdbcharsets = "connection: " + character_set_connection + "(" + collation_connection + "), database: " + character_set_database + "(" + collation_database + ")";
                if (!character_set_connection.equals(character_set_database) || !collation_connection.equals(collation_database)) {
                    serverdbcharsets = (String)serverdbcharsets + "\n    \u0412\u041d\u0418\u041c\u0410\u041d\u0418\u0415: \u043a\u043e\u0434\u0438\u0440\u043e\u0432\u043a\u0438 \u0432 \u043a\u043e\u043d\u043d\u0435\u043a\u0448\u0435\u043d\u0435 \u043a \u0411\u0414 \u043d\u0435 \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0443\u044e\u0442 \u043a\u043e\u0434\u0438\u0440\u043e\u0432\u043a\u0430\u043c \u0411\u0414";
                }
            }
        }
        return serverdbcharsets;
    }

    private void checkLastBuildTime(String buildTime) {
        Date date = TimeUtils.parseDate(buildTime, "dd.MM.yyyy HH:mm:ss", TimeZone.getTimeZone("Asia/Yekaterinburg"));
        if (date != null && (this.maximumBuildTime == null || date.after(this.maximumBuildTime))) {
            this.maximumBuildTime = date;
        }
    }
}

