/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.common;

import bitel.billing.module.common.MyCompoundEdit;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import ru.bitel.bgbilling.client.BGClientInit;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.common.function.TryCall;

public class BGUndoManager
extends AbstractUndoableEdit
implements UndoableEditListener {
    String lastEditName = null;
    ArrayList<MyCompoundEdit> edits = new ArrayList();
    MyCompoundEdit current;
    int pointer = -1;

    @Override
    public void undoableEditHappened(UndoableEditEvent e) {
        UndoableEdit edit = e.getEdit();
        if (edit instanceof AbstractDocument.DefaultDocumentEvent) {
            try {
                AbstractDocument.DefaultDocumentEvent event = (AbstractDocument.DefaultDocumentEvent)edit;
                int start = event.getOffset();
                int len = event.getLength();
                if (event.getDocument().getLength() < start + len) {
                    while (this.pointer < this.edits.size() - 1) {
                        this.edits.remove(this.edits.size() - 1);
                    }
                    this.createCompoundEdit();
                    this.current.addEdit(edit);
                    this.lastEditName = edit.getPresentationName();
                    return;
                }
                String text = event.getDocument().getText(start, len);
                boolean isNeedStart = false;
                if (this.current == null) {
                    isNeedStart = true;
                } else if (text.contains(" ") || text.contains("\n")) {
                    isNeedStart = true;
                } else if (this.lastEditName == null || !this.lastEditName.equals(edit.getPresentationName())) {
                    isNeedStart = true;
                }
                while (this.pointer < this.edits.size() - 1) {
                    this.edits.remove(this.edits.size() - 1);
                    isNeedStart = true;
                }
                if (isNeedStart && (event.getType() != DocumentEvent.EventType.CHANGE || this.current == null)) {
                    this.createCompoundEdit();
                }
                this.current.addEdit(edit);
                this.lastEditName = edit.getPresentationName();
            }
            catch (BadLocationException ex) {
                ClientUtils.showErrorMessageDialog(ex);
            }
        }
    }

    public void createCompoundEdit() {
        if (this.current == null || this.current.getLength() > 0) {
            this.current = new MyCompoundEdit();
        }
        this.edits.add(this.current);
        ++this.pointer;
    }

    @Override
    public void undo() throws CannotUndoException {
        if (!this.canUndo()) {
            throw new CannotUndoException();
        }
        MyCompoundEdit u = this.edits.get(this.pointer);
        u.undo();
        --this.pointer;
    }

    @Override
    public void redo() throws CannotUndoException {
        if (!this.canRedo()) {
            --this.pointer;
            throw new CannotUndoException();
        }
        MyCompoundEdit u = this.edits.get(++this.pointer);
        u.redo();
    }

    @Override
    public boolean canUndo() {
        return this.pointer >= 0;
    }

    @Override
    public boolean canRedo() {
        return this.edits.size() > 0 && this.pointer < this.edits.size() - 1;
    }

    public synchronized void discardAllEdits() {
        for (UndoableEdit undoableEdit : this.edits) {
            undoableEdit.die();
        }
        this.pointer = -1;
        this.edits = new ArrayList();
    }

    public void setActionUndoAndRedo(JTextComponent component) {
        component.getDocument().addUndoableEditListener(this);
        AbstractAction undo = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TryCall.call(() -> {
                    if (BGUndoManager.this.canUndo()) {
                        BGUndoManager.this.undo();
                    }
                });
            }
        };
        AbstractAction redo = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    if (BGUndoManager.this.canRedo()) {
                        BGUndoManager.this.redo();
                    }
                }
                catch (CannotRedoException ex) {
                    ClientUtils.showErrorMessageDialog(ex);
                }
            }
        };
        InputMap imap = component.getInputMap();
        imap.put(KeyStroke.getKeyStroke(90, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), "undo");
        if (BGClientInit.isMacOs()) {
            imap.put(KeyStroke.getKeyStroke(90, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 0x40), "redo");
        } else {
            imap.put(KeyStroke.getKeyStroke("ctrl Y"), "redo");
        }
        ActionMap amap = component.getActionMap();
        amap.put("undo", undo);
        amap.put("redo", redo);
    }
}

