/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.period.server.service;

import jakarta.jws.WebService;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Objects;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.contract.period.common.bean.ContractPeriod;
import ru.bitel.bgbilling.kernel.contract.period.common.service.ContractPeriodService;
import ru.bitel.bgbilling.kernel.contract.period.server.bean.ContractPeriodCloseEventJob;
import ru.bitel.bgbilling.kernel.contract.period.server.bean.ContractPeriodDao;
import ru.bitel.bgbilling.kernel.contract.period.server.event.ContractPeriodDeleteEvent;
import ru.bitel.bgbilling.kernel.contract.period.server.event.ContractPeriodUpdateEvent;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;
import ru.bitel.oss.kernel.job.server.JobScheduler;

@WebService(endpointInterface="ru.bitel.bgbilling.kernel.contract.period.common.service.ContractPeriodService")
public class ContractPeriodServiceImpl
extends AbstractService
implements ContractPeriodService {
    private static final String KEY_CLOSE_JOB_ENABLE = "contract.period.job.close.event.enable";
    private Setup setup = Setup.getSetup();

    @Override
    public SearchResult<ContractPeriod> contractPeriodSearch(int contractId, String[] sort, Page page) throws BGException {
        return this.tryReturn(() -> {
            SearchResult<ContractPeriod> searchResult = new SearchResult<ContractPeriod>(page, sort);
            new ContractPeriodDao(this.getConnection()).searchContractPeriod(searchResult, contractId);
            return searchResult;
        });
    }

    @Override
    public ContractPeriod contractPeriodGet(int id) throws BGException {
        return this.tryReturn(() -> (ContractPeriod)new ContractPeriodDao(this.getConnection()).get(id));
    }

    @Override
    public ContractPeriod contractPeriodUpdate(ContractPeriod contractPeriod) throws BGException {
        Objects.requireNonNull(contractPeriod);
        return this.tryReturn(() -> {
            ContractPeriodDao contractPeriodDao = new ContractPeriodDao(this.getConnection());
            ContractPeriod oldContractPeriod = contractPeriod.getId() < 1 ? null : (ContractPeriod)contractPeriodDao.get(contractPeriod.getId());
            contractPeriod.setUserId(this.userId);
            contractPeriodDao.update(contractPeriod);
            EventProcessor.getInstance().publish(new ContractPeriodUpdateEvent(oldContractPeriod, contractPeriod, contractPeriod.getContractId(), this.userId));
            if (this.setup.getBoolean(KEY_CLOSE_JOB_ENABLE, false)) {
                long jobId;
                boolean dateToChange;
                LocalDateTime oldTo = oldContractPeriod == null ? null : oldContractPeriod.getPeriod().getLocalDateTimeTo();
                LocalDateTime newTo = contractPeriod.getPeriod().getLocalDateTimeTo();
                boolean bl = dateToChange = oldTo == null || newTo != null || oldTo != null && newTo != null && !oldTo.isEqual(newTo);
                if ((!contractPeriod.isGenerateCloseEvent() || dateToChange) && (jobId = oldContractPeriod.getJobId()) > 0L) {
                    JobScheduler.getInstance((String)"contract_period", (int)0).cancel(jobId);
                }
                if (contractPeriod.isGenerateCloseEvent() && dateToChange) {
                    HashMap<String, String> params = new HashMap<String, String>();
                    params.put("contractPeriodId", String.valueOf(contractPeriod.getId()));
                    long jobId2 = JobScheduler.getInstance((String)"contract_period", (int)0).schedule(ContractPeriodCloseEventJob.class, (ParameterMap)new ParameterMap.DefaultParameterMap(params), contractPeriod.getPeriod().getDateTo());
                    contractPeriod.setJobId(jobId2);
                    contractPeriodDao.update(contractPeriod);
                }
            }
            return contractPeriod;
        });
    }

    @Override
    public boolean contractPeriodDelete(int id) throws BGException {
        return this.tryReturn(() -> {
            boolean result;
            long jobId;
            ContractPeriodDao contractPeriodDao = new ContractPeriodDao(this.getConnection());
            ContractPeriod oldContractPeriod = (ContractPeriod)contractPeriodDao.get(id);
            if (this.setup.getBoolean(KEY_CLOSE_JOB_ENABLE, false) && oldContractPeriod != null && (jobId = oldContractPeriod.getJobId()) > 0L) {
                JobScheduler.getInstance((String)"contract_period", (int)0).cancel(jobId);
            }
            boolean bl = result = contractPeriodDao.delete(id) > 0;
            if (result) {
                EventProcessor.getInstance().publish(new ContractPeriodDeleteEvent(oldContractPeriod, this.userId));
            }
            return result;
        });
    }
}

