/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.status.client;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import ru.bitel.bgbilling.kernel.table.common.bean.BGUTableRowData;
import ru.bitel.common.Utils;

public class StatusChartPanel
extends JLabel {
    private int monthCount = 1;
    private int padX = 10;
    private int padY = 10;
    private int rowH = 20;
    private int rowW = 30;
    private int monthW = 130;
    private int dayH = 25;
    private int areaW = 2 * this.padX + this.monthW + 31 * this.rowW;
    private List<StatusData> statusDatas = new ArrayList<StatusData>();
    private LocalDate now;
    private LocalDate from = this.now = LocalDate.now().withDayOfMonth(1);
    private LocalDate to = this.now;

    public StatusChartPanel() {
        this.setOpaque(true);
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(this.areaW, this.monthCount * this.rowH + this.dayH + 2 * this.padY);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dim = super.getPreferredSize();
        return new Dimension(Math.max(dim.width, this.areaW), Math.max(dim.height, this.monthCount * this.rowH + this.dayH + 2 * this.padY));
    }

    public void setData(List<BGUTableRowData> data) {
        DateTimeFormatter dateFormat = DateTimeFormatter.ofPattern("dd.MM.yyyy");
        this.statusDatas = data.stream().map(a -> {
            String[] period = a.optValue("period").orElse("").split("-");
            if (period == null || period.length != 2) {
                return null;
            }
            StatusData statusData = new StatusData(this);
            statusData.from = LocalDate.parse(period[0], dateFormat);
            statusData.to = period[1].length() < 10 ? LocalDate.now() : LocalDate.parse(period[1], dateFormat);
            statusData.status = Utils.parseInt(a.optValue("statusId").orElse("0"));
            statusData.statusTitle = a.optValue("status").orElse("?");
            statusData.comment = a.optValue("comment").orElse("");
            return statusData;
        }).filter(a -> a != null).toList();
        this.to = this.statusDatas.isEmpty() ? this.now : this.statusDatas.getLast().from;
        this.monthCount = (int)ChronoUnit.MONTHS.between(this.to, this.now) + 1;
        this.revalidate();
        this.repaint();
    }

    @Override
    public void paint(Graphics g) {
        Color[] colors = new Color[]{Color.GREEN, Color.BLUE, Color.GRAY, Color.YELLOW, Color.RED, Color.CYAN, Color.ORANGE};
        Dimension dim = this.getPreferredSize();
        g.clearRect(0, 0, dim.width, this.monthCount * this.rowH + this.dayH + 2 * this.padY);
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, dim.width, this.monthCount * this.rowH + this.dayH + 2 * this.padY);
        g.setColor(Color.BLACK);
        g.setFont(this.getFont().deriveFont(1));
        DateTimeFormatter dateFormat = DateTimeFormatter.ofPattern("LLLL YYYY");
        int y = this.padY + this.dayH;
        for (int d = 1; d < 32; ++d) {
            String strDay = d < 10 ? "0" + d : "" + d;
            int strW = g.getFontMetrics().charsWidth(strDay.toCharArray(), 0, strDay.length());
            g.drawString(strDay, this.padX + this.monthW + (d - 1) * this.rowW + (this.rowW - strW) / 2, y - 4);
        }
        y += this.rowH;
        this.from = this.now;
        while (this.from.isAfter(this.to)) {
            String monthYear = dateFormat.format(this.from);
            int strW = g.getFontMetrics().charsWidth(monthYear.toCharArray(), 0, monthYear.length());
            g.setColor(Color.BLACK);
            g.drawString(monthYear, this.padX + (this.monthW - strW) / 2, y - 4);
            for (int d = 0; d < this.from.lengthOfMonth(); ++d) {
                LocalDate date = this.from.withDayOfMonth(d + 1);
                int status = this.statusDatas.stream().filter(a -> !date.isBefore(a.from) && !date.isAfter(a.to)).findFirst().map(a -> a.status).orElse(0);
                g.setColor(colors[status]);
                g.fillRect(this.padX + this.monthW + d * this.rowW, y - this.rowH, this.rowW, this.rowH);
                g.setColor(Color.BLACK);
                g.drawRect(this.padX + this.monthW + d * this.rowW, y - this.rowH, this.rowW, this.rowH);
            }
            y += this.rowH;
            this.from = this.from.minusMonths(1L);
        }
    }

    class StatusData {
        LocalDate from;
        LocalDate to;
        int status;
        String statusTitle;
        String comment;

        StatusData(StatusChartPanel this$0) {
        }
    }
}

