/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.call.action.web;

import bitel.billing.server.call.action.base.ActionBase;
import jakarta.servlet.http.HttpSession;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractUtils;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Utils;

public class ActionChangeLoginPassword
extends ActionBase {
    private String login_id = null;

    @Override
    public void doAction() throws Exception {
        this.changeLoginPassword();
    }

    private void changeLoginPassword() throws Exception {
        HttpSession ses = this.request.getSession(true);
        Document doc = this.rootNode.getOwnerDocument();
        if (this.mid < 0) {
            return;
        }
        this.login_id = this.getParameter("login", "");
        String old_pswd = this.getParameter("old_pswd", null);
        String pswd1 = this.getParameter("pswd1", null);
        String pswd2 = this.getParameter("pswd2", null);
        if (old_pswd != null && pswd1 != null && pswd2 != null) {
            String error = ContractUtils.checkPassword((ParameterMap)this.moduleSetup, pswd1, pswd2);
            if (error != null) {
                this.dataMap.put("error", error);
                this.setWebErrorMessage(error);
            } else {
                try {
                    boolean is_pswd_valid = false;
                    String query = "SELECT pswd FROM user_login_" + this.mid + " WHERE id=?";
                    PreparedStatement psSelectPswd = this.con.prepareStatement(query);
                    psSelectPswd.setString(1, this.login_id);
                    ResultSet rs = psSelectPswd.executeQuery();
                    if (rs.next()) {
                        String pswd = rs.getString(1);
                        if (Utils.getDigest((String)old_pswd, (String)"cp1251").equals(pswd)) {
                            is_pswd_valid = true;
                        } else if (old_pswd.equals(pswd)) {
                            is_pswd_valid = true;
                        }
                    }
                    if (!is_pswd_valid) {
                        this.dataMap.put("error", "\u041d\u0435\u0432\u0435\u0440\u043d\u043e \u0432\u0432\u0435\u0434\u0435\u043d \u0441\u0442\u0430\u0440\u044b\u0439 \u043f\u0430\u0440\u043e\u043b\u044c!");
                        this.rootNode.setAttribute("status", "error");
                        this.rootNode.appendChild(doc.createTextNode("\u041d\u0435\u0432\u0435\u0440\u043d\u043e \u0432\u0432\u0435\u0434\u0435\u043d \u0441\u0442\u0430\u0440\u044b\u0439 \u043f\u0430\u0440\u043e\u043b\u044c!"));
                    } else if (this.con != null) {
                        PreparedStatement ps = this.con.prepareStatement("UPDATE user_login_" + this.mid + " SET pswd=? WHERE id=?");
                        ps.setString(1, pswd1.trim());
                        ps.setString(2, this.login_id);
                        ps.executeUpdate();
                        ps.close();
                        this.rootNode.setAttribute("status", "ok");
                        this.dataMap.put("status", "ok");
                        boolean is_admin = ses.getAttribute("admin") != null;
                        this.logPswdChange(Integer.parseInt(this.login_id), is_admin ? 0 : -1);
                    }
                }
                catch (SQLException e) {
                    this.rootNode.setAttribute("status", "error");
                    this.rootNode.appendChild(doc.createTextNode(e.getLocalizedMessage()));
                    this.dataMap.put("error", doc.createTextNode(e.getLocalizedMessage()));
                }
            }
        }
        this.setData();
    }

    public void logPswdChange(int lid, int userId) {
        String query = "INSERT INTO log_login_pswd VALUES ( now(), ?, ?, ? )";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, userId);
            ps.setInt(2, this.mid);
            ps.setInt(3, lid);
            ps.executeUpdate();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void setDataForXslt() {
        Element logins = this.createElement(this.rootNode, "logins");
        this.getLoginManager().loginsList(logins, this.cid);
        logins.setAttribute("id", this.login_id);
    }

    @Override
    protected void setDataToRequest() {
        this.dataMap.put("id", this.login_id);
        this.dataMap.put("module", this.module);
        this.dataMap.put("mid", this.mid);
        this.dataMap.put("loginList", this.getLoginManager().getContractLogins(this.cid));
    }
}

