/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceOption;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.dao.AbstractDirectoryIdDao;

public class VoiceOptionDao
extends AbstractDirectoryIdDao<VoiceOption> {
    public VoiceOptionDao(Connection con, int mid) {
        super(con, mid, "voice_option");
    }

    protected VoiceOption getFromRS(ResultSet rs) throws SQLException, BGException {
        VoiceOption result = new VoiceOption();
        result.setId(rs.getInt("id"));
        result.setTitle(rs.getString("title"));
        result.setConfig(rs.getString("config"));
        result.setComment(rs.getString("comment"));
        return result;
    }

    protected void updateImpl(VoiceOption b) throws BGException, SQLException {
        PreparedStatement ps;
        if (Utils.isBlankString((String)b.getTitle())) {
            throw new BGIllegalArgumentException();
        }
        if (b.getId() <= 0) {
            ps = this.con.prepareStatement("INSERT INTO " + this.tableName + " ( title, config, comment) VALUES (?,?,?)", 1);
        } else {
            ps = this.con.prepareStatement("UPDATE " + this.tableName + " SET  title=?,  config=?, comment=? WHERE id=?");
            ps.setInt(4, b.getId());
        }
        ps.setString(1, b.getTitle());
        ps.setString(2, b.getConfig());
        ps.setString(3, b.getComment());
        ps.executeUpdate();
        if (b.getId() <= 0) {
            b.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
        }
        ps.close();
    }

    public VoiceOption get(String title) throws BGException {
        return (VoiceOption)this.get("title=?", new Object[]{title});
    }

    public List<VoiceOption> list() throws BGException {
        return this.list(null, "title", new Object[0]);
    }
}

