/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.customer.common.bean;

import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.json.JSONObject;
import ru.bitel.bgbilling.kernel.customer.common.bean.CustomerBankInfo;
import ru.bitel.bgbilling.kernel.customer.common.bean.CustomerContact;
import ru.bitel.bgbilling.kernel.customer.common.bean.CustomerDirector;
import ru.bitel.bgbilling.kernel.customer.common.bean.CustomerF;
import ru.bitel.bgbilling.kernel.customer.common.bean.CustomerU;
import ru.bitel.common.Utils;

public class Customer {
    private int id = 0;
    private CustomerType customerType = CustomerType.FIZ_CUSTOMER;
    private String data;
    private int contractCount;
    public static final List<Keys> U_VALUES = Arrays.asList(Keys.NAME, Keys.INN, Keys.KPP, Keys.OGRN, Keys.U_ADDRESS, Keys.P_ADDRESS);
    public static final List<Keys> U_BANK_VALUES = Arrays.asList(Keys.BANK_ACCOUNT, Keys.BANK_BIK);
    public static final List<Keys> U_DIRECTOR_VALUES = Arrays.asList(Keys.DIRECTOR_POSITION, Keys.DIRECTOR_NAME, Keys.DIRECTOR_REASON);
    public static final List<Keys> F_VALUES = Arrays.asList(Keys.FIRST_NAME, Keys.LAST_NAME, Keys.MIDDLE_NAME, Keys.INN, Keys.GENDER, Keys.BIRTHDAY);
    public static final List<Keys> CONTACT_VALUES = Arrays.asList(Keys.PHONE, Keys.MOBILE, Keys.EMAIL);

    @XmlAttribute
    public int getId() {
        return this.id;
    }

    @XmlAttribute
    public CustomerType getCustomerType() {
        return this.customerType;
    }

    @XmlElement
    public String getData() {
        return this.data;
    }

    @XmlAttribute
    public int getContractCount() {
        return this.contractCount;
    }

    public Customer setId(int id) {
        this.id = id;
        return this;
    }

    public Customer setCustomerType(CustomerType customerType) {
        this.customerType = customerType;
        return this;
    }

    public Customer setData(String data) {
        this.data = data;
        return this;
    }

    public Customer setContractCount(int contractCount) {
        this.contractCount = contractCount;
        return this;
    }

    public CustomerF toCustomerF() {
        JSONObject json = new JSONObject(this.data);
        JSONObject jsonCustomer = Optional.ofNullable(json.optJSONObject("customer")).orElse(new JSONObject());
        JSONObject fioCustomer = Optional.ofNullable(jsonCustomer.optJSONObject("fio")).orElse(new JSONObject());
        JSONObject contactCustomer = Optional.ofNullable(jsonCustomer.optJSONObject("contact")).orElse(new JSONObject());
        return new CustomerF().setNameFirst(fioCustomer.optString("first")).setNameLast(fioCustomer.optString("last")).setNameMiddle(fioCustomer.optString("middle")).setInn(jsonCustomer.optString("inn")).setGender(jsonCustomer.optString("gender")).setBirthday(jsonCustomer.optString("birthday")).setContact(CustomerContact.fromJson(contactCustomer));
    }

    public CustomerU toCustomerU() {
        JSONObject json = new JSONObject(this.data);
        JSONObject jsonCustomer = Optional.ofNullable(json.optJSONObject("customer")).orElse(new JSONObject());
        JSONObject directorCustomer = Optional.ofNullable(jsonCustomer.optJSONObject("director")).orElse(new JSONObject());
        JSONObject contactCustomer = Optional.ofNullable(jsonCustomer.optJSONObject("contact")).orElse(new JSONObject());
        List<CustomerBankInfo> bankInfos = CustomerBankInfo.forCustomer(jsonCustomer);
        return new CustomerU().setName(jsonCustomer.optString("name")).setInn(jsonCustomer.optString("inn")).setKpp(jsonCustomer.optString("kpp")).setAddress(jsonCustomer.optString("address")).setPostAddress(jsonCustomer.optString("post_address")).setDirector(CustomerDirector.fromJson(directorCustomer)).setBanks(bankInfos).setContact(CustomerContact.fromJson(contactCustomer));
    }

    public static <T> T define(String key, Class<T> enumWithKey) {
        if (Utils.isBlankString(key) || enumWithKey == null) {
            return null;
        }
        if (CustomerFizDocument.class.isAssignableFrom(enumWithKey)) {
            for (CustomerFizDocument document : CustomerFizDocument.values()) {
                if (!document.key.equals(key)) continue;
                return (T)((Object)document);
            }
        }
        return null;
    }

    public static enum CustomerType {
        JUR_CUSTOMER("u", "\u044e\u0440. \u043b\u0438\u0446\u043e"),
        FIZ_CUSTOMER("f", "\u0444\u0438\u0437. \u043b\u0438\u0446\u043e");

        private String type;
        private String title;

        private CustomerType(String type, String title) {
            this.type = type;
            this.title = title;
        }

        public String getType() {
            return this.type;
        }

        public String getTitle() {
            return this.title;
        }

        public static CustomerType defineType(String type) {
            return Stream.of(CustomerType.values()).filter(a -> a.getType().equals(type)).findFirst().orElse(null);
        }
    }

    public static enum CustomerFizDocument {
        DOCUMENT_TYPE("list", "/customer/document/type", "\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442"),
        PASSPORT_RF("list", "/customer/document/passport_rf", "\u041f\u0430\u0441\u043f\u043e\u0440\u0442 \u0420\u0424"),
        PASSPORT_RF_SERIAL("text", "/customer/document/passport_rf/series", "\u0421\u0435\u0440\u0438\u044f"),
        PASSPORT_RF_NUMBER("text", "/customer/document/passport_rf/number", "\u041d\u043e\u043c\u0435\u0440"),
        PASSPORT_RF_CODE("text", "/customer/document/passport_rf/code", "\u041a\u043e\u0434"),
        PASSPORT_RF_WHO_GIVE("text", "/customer/document/passport_rf/issued", "\u0412\u044b\u0434\u0430\u043d"),
        PASSPORT_RF_WHEN_GIVE("date", "/customer/document/passport_rf/date", "\u0414\u0430\u0442\u0430 \u0432\u044b\u0434\u0430\u0447\u0438"),
        PASSPORT_RF_ADDRESS("text", "/customer/document/passport_rf/address", "\u0410\u0434\u0440\u0435\u0441"),
        PASSPORT_FOREIGN("list", "/customer/document/passport_foreign", "\u0417\u0430\u0433\u0440\u0430\u043d\u0438\u0447\u043d\u044b\u0439 \u043f\u0430\u0441\u043f\u043e\u0440\u0442"),
        PASSPORT_FOREIGN_COUNTRY("text", "/customer/document/passport_foreign/country", "\u0421\u0442\u0440\u0430\u043d\u0430"),
        PASSPORT_FOREIGN_NUMBER("text", "/customer/document/passport_foreign/number", "\u041d\u043e\u043c\u0435\u0440"),
        PASSPORT_FOREIGN_WHO_GIVE("text", "/customer/document/passport_foreign/issued", "\u0412\u044b\u0434\u0430\u043d"),
        PASSPORT_FOREIGN_WHEN_GIVE("date", "/customer/document/passport_foreign/date", "\u0414\u0430\u0442\u0430 \u0432\u044b\u0434\u0430\u0447\u0438"),
        PASSPORT_FOREIGN_WHEN_EXPIRE("date", "/customer/document/passport_foreign/expire", "\u0414\u0435\u0439\u0441\u0442\u0432\u0443\u0435\u0442 \u0434\u043e"),
        RESIDENCE_PERMIT("list", "/customer/document/residence_permit", "\u0412\u0438\u0434 \u043d\u0430 \u0436\u0438\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u043e"),
        RESIDENCE_PERMIT_NUMBER("text", "/customer/document/residence_permit/number", "\u041d\u043e\u043c\u0435\u0440"),
        RESIDENCE_PERMIT_WHO_GIVE("text", "/customer/document/residence_permit/issued", "\u0412\u044b\u0434\u0430\u043d"),
        RESIDENCE_PERMIT_WHEN_GIVE("date", "/customer/document/residence_permit/date", "\u0414\u0430\u0442\u0430 \u0432\u044b\u0434\u0430\u0447\u0438"),
        RESIDENCE_PERMIT_WHEN_EXPIRE("date", "/customer/document/residence_permit/expire", "\u0414\u0435\u0439\u0441\u0442\u0432\u0443\u0435\u0442 \u0434\u043e"),
        IDENT_CARD("list", "/customer/document/ident_card", "\u041f\u0430\u0441\u043f\u043e\u0440\u0442 \u0438\u043d\u043e\u0441\u0442\u0440\u0430\u043d\u0446\u0430"),
        IDENT_CARD_SERIAL("text", "/customer/document/ident_card/serial", "\u0421\u0435\u0440\u0438\u044f"),
        IDENT_CARD_NUMBER("text", "/customer/document/ident_card/number", "\u041d\u043e\u043c\u0435\u0440"),
        IDENT_CARD_WHO_GIVE("text", "/customer/document/ident_card/issued", "\u0412\u044b\u0434\u0430\u043d"),
        IDENT_CARD_WHEN_GIVE("date", "/customer/document/ident_card/date", "\u0414\u0430\u0442\u0430 \u0432\u044b\u0434\u0430\u0447\u0438");

        private String type;
        private String key;
        private String description;

        private CustomerFizDocument(String type, String key, String description) {
            this.type = type;
            this.key = key;
            this.description = description;
        }

        public String type() {
            return this.type;
        }

        public String key() {
            return this.key;
        }

        public String description() {
            return this.description;
        }
    }

    public static enum Keys {
        INN("/customer/inn", "\u0418\u041d\u041d"),
        NAME("/customer/name", "\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435"),
        KPP("/customer/kpp", "\u041a\u041f\u041f"),
        OGRN("/customer/ogrn", "\u041e\u0413\u0420\u041d"),
        OGRNIP("/customer/ogrnip", "\u041e\u0413\u0420\u041d\u0418\u041f"),
        OKPO("/customer/okpo", "\u041e\u041a\u041f\u041e"),
        U_ADDRESS("/customer/address", "\u042e\u0440\u0438\u0434\u0438\u0447\u0435\u0441\u043a\u0438\u0439 \u0430\u0434\u0440\u0435\u0441"),
        P_ADDRESS("/customer/post_address", "\u041f\u043e\u0447\u0442\u043e\u0432\u044b\u0439 \u0430\u0434\u0440\u0435\u0441"),
        FIRST_NAME("/customer/fio/first", "\u0418\u043c\u044f"),
        LAST_NAME("/customer/fio/last", "\u0424\u0430\u043c\u0438\u043b\u0438\u044f"),
        MIDDLE_NAME("/customer/fio/middle", "\u041e\u0442\u0447\u0435\u0441\u0442\u0432\u043e"),
        GENDER("/customer/gender", "\u041f\u043e\u043b"),
        BIRTHDAY("/customer/birthday", "\u0414\u0430\u0442\u0430 \u0440\u043e\u0436\u0434\u0435\u043d\u0438\u044f"),
        BANK_ACCOUNT("/customer/bank/account", "\u0420/\u0441"),
        BANK_BIK("/customer/bank/bik", "\u0411\u0418\u041a"),
        DIRECTOR_POSITION("/customer/director/post", "\u0414\u043e\u043b\u0436\u043d\u043e\u0441\u0442\u044c"),
        DIRECTOR_NAME("/customer/director/fio", "\u0424\u0418\u041e"),
        DIRECTOR_REASON("/customer/director/acts", "\u0414\u0435\u0439\u0441\u0442\u0432\u0443\u0435\u0442 \u043d\u0430 \u043e\u0441\u043d\u043e\u0432\u0430\u043d\u0438\u0438"),
        MOBILE("/customer/contact/mobile", "\u041c\u043e\u0431\u0438\u043b\u044c\u043d\u044b\u0439 \u043d\u043e\u043c\u0435\u0440"),
        PHONE("/customer/contact/phone", "\u0421\u0442\u0430\u0446\u0438\u043e\u043d\u0430\u0440\u043d\u044b\u0439 \u043d\u043e\u043c\u0435\u0440"),
        EMAIL("/customer/contact/email", "E-mail");

        private String key;
        private String description;

        private Keys(String key, String description) {
            this.key = key;
            this.description = description;
        }

        public String key() {
            return this.key;
        }

        public String description() {
            return this.description;
        }
    }
}

