/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.bgsecure.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import ru.bitel.bgbilling.common.dao.AbstractIdDao;
import ru.bitel.bgbilling.kernel.bgsecure.common.bean.RightType;
import ru.bitel.bgbilling.kernel.bgsecure.common.bean.UserRightRule;

public class UserRightRuleDao
extends AbstractIdDao<UserRightRule> {
    public UserRightRuleDao(Connection con) {
        super(con, "user_right_rule");
    }

    public List<UserRightRule> getUserRightRules(int rightGroupId) throws SQLException {
        return this.list("group_id=?", "title", rightGroupId);
    }

    @Override
    protected UserRightRule getFromRS(ResultSet rs) throws SQLException {
        return new UserRightRule().setId(rs.getInt("id")).setRightGroupId(rs.getInt("group_id")).setTitle(rs.getString("title")).setModuleId(rs.getInt("module_id")).setRightType(RightType.getRightTypeByCode(rs.getByte("type"))).setActive(rs.getBoolean("active")).setRule(rs.getString("rule"));
    }

    @Override
    public void update(UserRightRule userRightRule) throws SQLException {
        super.update(userRightRule);
    }

    @Override
    protected void updateImpl(UserRightRule userRightRule) throws SQLException {
        int index;
        String sql;
        boolean insert;
        boolean bl = insert = userRightRule.getId() < 1;
        if (insert) {
            sql = "SELECT id FROM " + this.tableName + " WHERE group_id=? AND module_id=? AND title=? AND type=? AND rule=?";
            try (PreparedStatement psSelect = this.con.prepareStatement(sql);){
                index = 1;
                psSelect.setInt(index++, userRightRule.getRightGroupId());
                psSelect.setInt(index++, userRightRule.getModuleId());
                psSelect.setString(index++, userRightRule.getTitle());
                psSelect.setByte(index++, userRightRule.getRightType().getCode());
                psSelect.setString(index++, userRightRule.getRule());
                try (ResultSet rs = psSelect.executeQuery();){
                    while (rs.next()) {
                        userRightRule.setId(rs.getInt(1));
                    }
                }
            }
            if (userRightRule.getId() > 0) {
                return;
            }
        }
        sql = (insert ? "INSERT INTO " : "UPDATE ") + this.tableName + " SET group_id=?, module_id=?, title=?, type=?, rule=?" + (insert ? "" : " WHERE id=?");
        try (PreparedStatement ps = this.con.prepareStatement(sql, 1);){
            index = 1;
            ps.setInt(index++, userRightRule.getRightGroupId());
            ps.setInt(index++, userRightRule.getModuleId());
            ps.setString(index++, userRightRule.getTitle());
            ps.setByte(index++, userRightRule.getRightType().getCode());
            ps.setString(index++, userRightRule.getRule());
            this.executeUpdate(userRightRule, index, ps);
        }
    }
}

