/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.module.server.service;

import jakarta.activation.DataHandler;
import jakarta.activation.DataSource;
import jakarta.jws.WebService;
import jakarta.xml.ws.Holder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractModuleManager;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.module.common.bean.BGInstalledModule;
import ru.bitel.bgbilling.kernel.module.common.bean.BGModule;
import ru.bitel.bgbilling.kernel.module.common.bean.Service;
import ru.bitel.bgbilling.kernel.module.common.enums.ComponentType;
import ru.bitel.bgbilling.kernel.module.common.service.ModuleService;
import ru.bitel.bgbilling.kernel.module.server.ModuleCache;
import ru.bitel.bgbilling.kernel.module.server.bean.ModuleManager;
import ru.bitel.bgbilling.kernel.module.server.bean.ServiceDao;
import ru.bitel.bgbilling.kernel.module.server.event.ModulesChangedEvent;
import ru.bitel.bgbilling.kernel.module.server.event.ServicesChangedEvent;
import ru.bitel.bgbilling.kernel.task.server.TaskCache;
import ru.bitel.bgbilling.server.installer.InstallerModule;
import ru.bitel.bgbilling.server.installer.ScanUtils;
import ru.bitel.common.Utils;

@WebService(endpointInterface="ru.bitel.bgbilling.kernel.module.common.service.ModuleService")
public class ModuleServiceImpl
extends AbstractService
implements ModuleService {
    private String version = null;
    private String versionSet = null;

    @Override
    public int moduleAdd(String module, String title) throws BGException {
        return this.tryReturn(() -> {
            BGInstalledModule installedModule = ModuleCache.getInstance().getInstalledModule(module);
            if (installedModule == null) {
                throw new BGMessageException("\u041c\u043e\u0434\u0443\u043b\u044c " + module + " \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d!");
            }
            int result = new ModuleManager(this.getConnection()).addModule(installedModule, title, this.userId);
            TaskCache.getInstance().reloadTasks();
            this.context.publishAfterCommit(new ModulesChangedEvent(this.userId));
            return result;
        });
    }

    @Override
    public void moduleUpdate(BGModule module) throws BGException {
        this.tryCall(() -> {
            if (module.getId() <= 0) {
                throw new BGIllegalArgumentException();
            }
            new ModuleManager(this.getConnection()).updateModule(module);
            this.context.publishAfterCommit(new ModulesChangedEvent(this.userId));
        });
    }

    @Override
    public void moduleDelete(int id) throws BGException {
        ModuleCache cache = ModuleCache.getInstance();
        if (cache.getModuleServicesList(id).size() > 0) {
            throw new BGMessageException("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u043c\u043e\u0434\u0443\u043b\u044c \u0441\u043e\u0434\u0435\u0440\u0436\u0430\u0449\u0438\u0439 \u0443\u0441\u043b\u0443\u0433\u0438.");
        }
        BGModule module = cache.getModule(id);
        if (module == null) {
            throw new BGMessageException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u043c\u043e\u0434\u0443\u043b\u044c \u0441 \u043a\u043e\u0434\u043e\u043c: " + id);
        }
        new ModuleManager(this.getConnection()).deleteModule(module.getInstalledModule(), id);
        this.context.publishAfterCommit(new ModulesChangedEvent(this.userId));
    }

    @Override
    public List<BGModule> moduleList() throws BGException {
        return ModuleCache.getInstance().getModulesList();
    }

    @Override
    public List<BGModule> moduleByNameList(String name) throws BGException {
        return ModuleCache.getInstance().getModulesList(name);
    }

    @Override
    public List<BGInstalledModule> installedModuleList() throws BGException {
        return ModuleCache.getInstance().getInstalledModulesList().stream().filter(n -> n.getType() == ComponentType.MODULE).toList();
    }

    @Override
    public List<BGInstalledModule> installedPluginList() throws BGException {
        return ModuleCache.getInstance().getInstalledModulesList().stream().filter(n -> n.getType() == ComponentType.PLUGIN).toList();
    }

    @Override
    public Set<Integer> contractModuleIds(int contractId) throws BGException {
        return this.tryReturn(() -> new ContractModuleManager(this.getConnection()).getContractModuleSet(contractId));
    }

    @Override
    public List<BGModule> contractModules(int contractId) throws BGException {
        return this.tryReturn(() -> new ContractModuleManager(this.getConnection()).getContractModules(contractId));
    }

    @Override
    public List<BGInstalledModule> installedClientModuleList() throws BGException {
        ArrayList<BGInstalledModule> result = new ArrayList<BGInstalledModule>();
        for (ScanUtils.ModuleInfo mi : new ScanUtils(this.getConnection()).getModulesInfo(null)) {
            BGInstalledModule module = new BGInstalledModule().setTitle(mi.name).setName(mi.packetName).setBuild(mi.build).setName(mi.packetName);
            result.add(module);
        }
        return result;
    }

    @Override
    public void installedClientModulePacketGet(final String name, Holder<DataHandler> result) throws BGException {
        this.tryCall(() -> {
            File nameJarDir;
            if (Utils.isBlankString(name)) {
                throw new BGIllegalArgumentException();
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream(100000);
            boolean fl = false;
            File clientJarDir = new File("client.jars");
            if (clientJarDir.exists() && (nameJarDir = new File(clientJarDir, name)).exists()) {
                ZipOutputStream zipOutputStream = new ZipOutputStream(baos);
                for (String jarName : nameJarDir.list(new FilenameFilter(this){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name != null && name.endsWith(".jar");
                    }
                })) {
                    int count;
                    ZipEntry zipEntry = new ZipEntry(jarName);
                    zipEntry.setTime(System.currentTimeMillis());
                    zipOutputStream.putNextEntry(zipEntry);
                    ByteBuffer buffer = ByteBuffer.allocate(1024);
                    FileInputStream fileInputStream = new FileInputStream(new File(nameJarDir, jarName));
                    FileChannel jarFileChannel = fileInputStream.getChannel();
                    while ((count = jarFileChannel.read(buffer)) != -1) {
                        buffer.flip();
                        zipOutputStream.write(buffer.array(), 0, count);
                        buffer.clear();
                    }
                    jarFileChannel.close();
                    fileInputStream.close();
                    zipOutputStream.closeEntry();
                }
                zipOutputStream.flush();
                zipOutputStream.close();
                fl = true;
            }
            if (!fl) {
                String query = "SELECT client_zip FROM installed_modules WHERE name=?";
                try (PreparedStatement ps = this.getConnection().prepareStatement(query);){
                    ps.setString(1, name);
                    try (ResultSet rs = ps.executeQuery();){
                        byte[] data;
                        if (rs.next() && (data = rs.getBytes(1)) != null) {
                            ByteArrayOutputStream out = baos;
                            out.write(data);
                            out.flush();
                            ((OutputStream)out).close();
                        }
                    }
                }
            }
            final ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            result.value = new DataHandler(new DataSource(){

                public String getContentType() {
                    return "application/octet-stream";
                }

                public InputStream getInputStream() throws IOException {
                    return bais;
                }

                public String getName() {
                    return name + ".zip";
                }

                public OutputStream getOutputStream() throws IOException {
                    return null;
                }
            });
        });
    }

    @Override
    public void componentInstall(String zipName) throws BGException {
        this.tryCall(() -> {
            if (zipName == null) {
                throw new BGMessageException("zipName == null");
            }
            URL libServerDirURL = ModuleServiceImpl.class.getResource("/lib/server");
            boolean ide = libServerDirURL == null;
            HttpClient client = HttpClient.newHttpClient();
            HttpRequest request = HttpRequest.newBuilder(URI.create("https://bgbilling.ru/download/" + this.getVersion() + "/sets/" + this.getVersionSet() + "/" + zipName)).header("accept", "application/zip").build();
            try (InputStream inputStream = client.send(request, HttpResponse.BodyHandlers.ofInputStream()).body();
                 ZipInputStream zipIn = new ZipInputStream(inputStream);){
                URL billingRootDirURL = ModuleServiceImpl.class.getResource("/lib");
                if (billingRootDirURL != null) {
                    Path billingRootDirPath = Paths.get(billingRootDirURL.toURI()).getParent();
                    ZipEntry entry = zipIn.getNextEntry();
                    while (entry != null) {
                        if (!ide || entry.getName().startsWith("components")) {
                            Path path = billingRootDirPath.resolve(entry.getName());
                            if (entry.isDirectory()) {
                                Files.createDirectories(path, new FileAttribute[0]);
                            } else {
                                Files.copy(zipIn, path, StandardCopyOption.REPLACE_EXISTING);
                            }
                        }
                        zipIn.closeEntry();
                        entry = zipIn.getNextEntry();
                    }
                }
            }
        });
    }

    @Override
    public void componentUninstall(String name) throws BGException {
        this.tryCall(() -> {
            ModuleManager moduleManager;
            BGInstalledModule installedModule = ModuleCache.getInstance().getInstalledModule(name);
            if (installedModule != null) {
                moduleManager = new ModuleManager(this.getConnection());
                List<BGModule> modules = moduleManager.getModules(installedModule.getName());
                if (!modules.isEmpty()) {
                    StringBuffer buf = new StringBuffer();
                    modules.forEach(m -> buf.append(buf.length() > 0 ? ", " : "").append(m.getTitle()));
                    throw new BGMessageException(String.format("\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u043d\u0435 \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u043e. \u0415\u0441\u0442\u044c \u044d\u043a\u0437\u0435\u043c\u043f\u043b\u044f\u0440\u044b \u043c\u043e\u0434\u0443\u043b\u044f (%s), \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0441\u043d\u0430\u0447\u0430\u043b\u0430 \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u0438\u0445", buf.toString()));
                }
            } else {
                throw new BGMessageException("installedModule == null");
            }
            moduleManager.deleteInstalledComponent(name);
            EventProcessor.getInstance().publish(new ModulesChangedEvent(0, true));
        });
    }

    @Override
    public List<String> componentAvailable() throws BGException {
        return this.tryReturn(() -> {
            ArrayList components = new ArrayList();
            List<BGInstalledModule> list = ModuleCache.getInstance().getInstalledModulesList();
            HttpClient client = HttpClient.newHttpClient();
            HttpRequest request = HttpRequest.newBuilder(URI.create("https://bgbilling.ru/download/" + this.getVersion() + "/sets/" + this.getVersionSet() + "/files.dat")).header("accept", "plain/text").build();
            client.send(request, HttpResponse.BodyHandlers.ofLines()).body().forEach(l -> {
                String name = l.split("\t")[0];
                if (name.startsWith("name:")) {
                    name = name.substring(5);
                }
                String nameFinal = name;
                if (!list.stream().anyMatch(c -> c.getName().equals(nameFinal))) {
                    components.add(l);
                }
            });
            return components;
        });
    }

    @Override
    public void componentReinstall(int id) throws BGException {
        ModuleCache moduleCache = ModuleCache.getInstance();
        BGInstalledModule bgInstalledModule = moduleCache.getInstalledModulesList().stream().filter(a -> a.getId() == id).findAny().orElse(null);
        if (bgInstalledModule == null) {
            return;
        }
        boolean plugin = ComponentType.PLUGIN == bgInstalledModule.getType();
        Path path = Paths.get("./components", new String[0]);
        if (Files.exists(path, new LinkOption[0])) {
            Path updatePath;
            String componentName = bgInstalledModule.getName();
            if (plugin) {
                String[] tokens = componentName.split("\\.");
                componentName = tokens[tokens.length - 1];
            }
            if (Files.exists(updatePath = Paths.get(path.toString(), componentName, "update"), new LinkOption[0]) && Files.isRegularFile(updatePath, new LinkOption[0])) {
                try {
                    Files.writeString(updatePath, (CharSequence)"true", new OpenOption[0]);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        for (BGModule bgModule : moduleCache.getModulesList()) {
            if (bgModule.getInstalledModule().getId() != id) continue;
            InstallerModule.clearHashById((String)((ComponentType.MODULE == bgInstalledModule.getType() ? "m" : "") + bgModule.getId()));
        }
        if (plugin) {
            InstallerModule.clearHashById((String)String.valueOf(bgInstalledModule.getId()));
        }
    }

    private String getVersion() throws Exception {
        if (this.version == null) {
            this.loadVesionInfo();
        }
        return this.version;
    }

    private String getVersionSet() throws Exception {
        if (this.versionSet == null) {
            this.loadVesionInfo();
        }
        return this.versionSet;
    }

    private void loadVesionInfo() throws Exception {
        URL filesDatURL = ModuleServiceImpl.class.getResource("/data/files.dat");
        if (filesDatURL != null) {
            Files.lines(Paths.get(filesDatURL.toURI())).forEach(l -> {
                if (l.startsWith("version:")) {
                    this.version = l.substring(8);
                } else if (l.startsWith("set:")) {
                    this.versionSet = l.substring(4);
                }
            });
        }
    }

    @Override
    public List<Service> moduleServiceList(int moduleId) throws BGException {
        return ModuleCache.getInstance().getModuleServicesList(moduleId);
    }

    @Override
    public List<Service> moduleUsedServiceList(int moduleId) throws BGException {
        return ModuleCache.getInstance().getModuleUsedServicesList(moduleId);
    }

    @Override
    public List<Service> serviceList(int moduleId) throws BGException {
        return this.tryReturn(() -> {
            if (moduleId > 0) {
                try (ServiceDao serviceDao = new ServiceDao(this.getConnection());){
                    List<Service> list = serviceDao.list(moduleId);
                    return list;
                }
            }
            return this.context.getDirectory(Service.class, 0).list();
        });
    }

    @Override
    public Service serviceGet(int serviceId) throws BGException {
        return this.context.getDirectory(Service.class, 0).get(serviceId);
    }

    @Override
    public int serviceUpdate(Service service) throws BGException {
        return this.tryReturn(() -> {
            this.context.getDirectory(Service.class, 0).update(service);
            this.context.publishAfterCommit(new ServicesChangedEvent(this.userId));
            return service.getId();
        });
    }

    @Override
    public void serviceDelete(int id) throws BGException {
        this.tryCall(() -> {
            this.context.getDirectory(Service.class, 0).delete(id);
            this.context.publishAfterCommit(new ServicesChangedEvent(this.userId));
        });
    }
}

