/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.container.managed;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import ru.bitel.bgbilling.kernel.container.managed.ManagedBeanInfo;

public abstract class AbstractManagedBeanInfoManager<I extends ManagedBeanInfo<B>, B> {
    private final ConcurrentMap<Class<? extends B>, ActionReference> actionMap = new ConcurrentHashMap<Class<? extends B>, ActionReference>(64);
    private final ReferenceQueue<I> actionReferenceQueue = new ReferenceQueue();
    private AtomicInteger counter = new AtomicInteger();

    public final I getManagedBeanInfo(Class<? extends B> clazz) {
        ManagedBeanInfo<Object> instance;
        Reference ref = (Reference)this.actionMap.get(clazz);
        if (ref == null || (instance = (ManagedBeanInfo)ref.get()) == null) {
            if (this.counter.incrementAndGet() % 300 == 0) {
                ActionReference remove;
                while ((remove = (ActionReference)this.actionReferenceQueue.poll()) != null) {
                    this.actionMap.remove(remove.clazz);
                }
                this.counter.set(0);
            }
            instance = this.newManagedBeanInfo(clazz);
            this.actionMap.put(clazz, new ActionReference(this, instance, this.actionReferenceQueue, clazz));
        }
        return (I)instance;
    }

    protected abstract I newManagedBeanInfo(Class<? extends B> var1);

    class ActionReference
    extends SoftReference<I> {
        final Class<? extends B> clazz;

        /*
         * WARNING - Possible parameter corruption
         */
        public ActionReference(I referent, ReferenceQueue<? super I> q, Class<? extends B> clazz) {
            super(referent, q);
            this.clazz = clazz;
        }
    }
}

