/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.cerbercrypt.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.Card;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.UserCard;
import ru.bitel.bgbilling.modules.cerbercrypt.server.bean.UserCardManager;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class CardManager {
    private Connection con;
    private int mid;
    private int userId;
    private String tableName;

    public CardManager(Connection con, int mid, int userId) {
        this.con = con;
        this.mid = mid;
        this.userId = userId;
        this.tableName = "card_" + mid;
    }

    public Card getCard(long number) throws BGException {
        Card result = null;
        try {
            String query = "SELECT * FROM " + this.tableName + " WHERE number=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setLong(1, number);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = CardManager.getCardFromRs(rs);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return result;
    }

    public boolean addCard(Card card) throws BGException {
        boolean result;
        block2: {
            result = false;
            try {
                String query = "INSERT INTO " + this.tableName + " (number, pswd, dealer_id, pass_dt) VALUES (?,?,?,?)";
                PreparedStatement ps = this.con.prepareStatement(query);
                ps.setLong(1, card.getNumber());
                ps.setString(2, card.getPassword());
                ps.setInt(3, card.getDealerId());
                ps.setDate(4, TimeUtils.convertCalendarToSqlDate((Calendar)card.getPassDate()));
                ps.executeUpdate();
                result = true;
                ps.close();
            }
            catch (SQLException e) {
                if (e.getErrorCode() == 1062) break block2;
                throw new BGException((Throwable)e);
            }
        }
        return result;
    }

    public void updateCard(Card card) throws BGException {
        try {
            String query = "UPDATE " + this.tableName + " SET dealer_id=?, pass_dt=?, cid=?, contract_dt=?, pswd=?, pairing_module=? WHERE number=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, card.getDealerId());
            ps.setDate(2, TimeUtils.convertCalendarToSqlDate((Calendar)card.getPassDate()));
            ps.setInt(3, card.getContractId());
            ps.setDate(4, TimeUtils.convertCalendarToSqlDate((Calendar)card.getContractDate()));
            ps.setString(5, card.getPassword());
            ps.setString(6, card.getPairingModule());
            ps.setLong(7, card.getNumber());
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    public void deleteCard(long number, boolean check) throws BGException {
        try {
            Card card;
            if (check && (card = this.getCard(number)) != null) {
                if (card.getDealerId() > 0) {
                    throw new BGMessageException("\u041d\u0435\u043b\u044c\u0437\u044f \u0443\u0434\u0430\u043b\u0438\u0442\u044c, \u043a\u0430\u0440\u0442\u0430 \u043f\u0440\u0438\u0432\u044f\u0437\u0430\u043d\u0430 \u043a \u0434\u0438\u043b\u0435\u0440\u0443");
                }
                UserCardManager ucm = new UserCardManager(this.con, this.mid, this.userId);
                List<UserCard> userCards = ucm.getListByNumber(number);
                if (Utils.notEmptyCollection(userCards)) {
                    throw new BGMessageException("\u041d\u0435\u043b\u044c\u0437\u044f \u0443\u0434\u0430\u043b\u0438\u0442\u044c, \u043a\u0430\u0440\u0442\u0430 \u0438\u043c\u0435\u0435\u0442 " + userCards.size() + " \u043f\u0440\u0438\u0432\u044f\u0437\u043e\u043a \u043a \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430\u043c");
                }
            }
            String query = "DELETE FROM " + this.tableName + " WHERE number=?";
            try (PreparedStatement ps = this.con.prepareStatement(query);){
                ps.setLong(1, number);
                ps.executeUpdate();
            }
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    public int removeCardsFromDealer(int dealerId, long numberFrom, long numberTo) throws BGException {
        int result = 0;
        try {
            String query = "UPDATE " + this.tableName + " SET dealer_id=0 WHERE dealer_id=? AND number<=? AND number>=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, dealerId);
            ps.setLong(2, numberFrom);
            ps.setLong(3, numberTo);
            result = ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return result;
    }

    public int addCardsToDealer(int dealerId, Calendar date, long numberFrom, long numberTo) throws BGException {
        int result = 0;
        try {
            String query = "UPDATE " + this.tableName + " SET dealer_id=?, pass_dt=? WHERE dealer_id=0 AND number<=? AND number>=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, dealerId);
            ps.setDate(2, TimeUtils.convertCalendarToSqlDate((Calendar)date));
            ps.setLong(3, numberFrom);
            ps.setLong(4, numberTo);
            result = ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return result;
    }

    public List<Card> getCardsOfDealer(int dealerId) throws BGException {
        ArrayList<Card> result = new ArrayList<Card>();
        try {
            String query = "SELECT * FROM " + this.tableName + " WHERE dealer_id=" + dealerId;
            PreparedStatement ps = this.con.prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(CardManager.getCardFromRs(rs));
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return result;
    }

    public boolean updateCardContract(Card card, Date date) throws Exception {
        UserCardManager userCardManager = new UserCardManager(this.con, this.mid, this.userId);
        UserCard userCard = userCardManager.getUserCard(card.getNumber(), date);
        boolean wasUpdated = false;
        if (userCard != null) {
            Calendar uc1 = TimeUtils.convertDateToCalendar((Date)userCard.getDate1());
            if (card.getContractId() != userCard.getContractId() || card.getContractDate() == null || !card.getContractDate().equals(uc1)) {
                card.setContractId(userCard.getContractId());
                card.setContractDate(uc1);
                this.updateCard(card);
                wasUpdated = true;
            }
        } else if (card.getContractId() != 0 || card.getContractDate() != null) {
            card.setContractId(0);
            card.setContractDate(null);
            this.updateCard(card);
            wasUpdated = true;
        }
        return wasUpdated;
    }

    public List<Card> getFullCardList() throws BGException {
        ArrayList<Card> result = new ArrayList<Card>();
        try {
            String query = "SELECT * FROM " + this.tableName;
            PreparedStatement ps = this.con.prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(CardManager.getCardFromRs(rs));
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return result;
    }

    private static Card getCardFromRs(ResultSet rs) throws SQLException {
        Card card = new Card();
        card.setNumber(rs.getLong("number"));
        card.setPassword(rs.getString("pswd"));
        card.setDealerId(rs.getInt("dealer_id"));
        card.setPassDate(TimeUtils.convertDateToCalendar((Date)rs.getDate("pass_dt")));
        card.setContractId(rs.getInt("cid"));
        card.setContractDate(TimeUtils.convertDateToCalendar((Date)rs.getDate("contract_dt")));
        card.setPairingModule(rs.getString("pairing_module"));
        return card;
    }

    public List<Long> getAllCardNumbers() throws BGException {
        ArrayList<Long> result = new ArrayList<Long>();
        try {
            String query = "SELECT number FROM " + this.tableName;
            Statement ps = this.con.createStatement();
            ResultSet rs = ps.executeQuery(query);
            while (rs.next()) {
                result.add(rs.getLong("number"));
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return result;
    }

    public List<Long> getFreeCardNumbers() throws BGException {
        ArrayList<Long> result = new ArrayList<Long>();
        try {
            String query = "SELECT c.number FROM " + this.tableName + " as c  WHERE c.number not in ( SELECT uc.number FROM user_card_" + this.mid + " as uc WHERE (uc.date1 IS NULL OR uc.date1<=NOW()) AND (uc.date2 IS NULL OR NOW()<=uc.date2) )";
            PreparedStatement ps = this.con.prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(rs.getLong("number"));
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return result;
    }
}

