/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.gar.server.service;

import jakarta.annotation.PostConstruct;
import jakarta.jws.WebService;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.plugins.gar.common.bean.GarAddressCity;
import ru.bitel.bgbilling.plugins.gar.common.bean.GarAddressHouse;
import ru.bitel.bgbilling.plugins.gar.common.bean.GarAddressStreet;
import ru.bitel.bgbilling.plugins.gar.common.bean.GarAddressType;
import ru.bitel.bgbilling.plugins.gar.common.bean.GarLoadedHistoryEntry;
import ru.bitel.bgbilling.plugins.gar.common.bean.GarLoadedReport;
import ru.bitel.bgbilling.plugins.gar.common.service.GarService;
import ru.bitel.bgbilling.plugins.gar.server.bean.GarAddressDao;
import ru.bitel.bgbilling.plugins.gar.server.service.GarLoader;
import ru.bitel.bgbilling.plugins.gar.server.service.GarServer;
import ru.bitel.common.Utils;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;
import ru.bitel.oss.kernel.directories.address.common.bean.City;
import ru.bitel.oss.kernel.directories.address.common.bean.Country;
import ru.bitel.oss.kernel.directories.address.common.bean.House;
import ru.bitel.oss.kernel.directories.address.common.bean.Street;
import ru.bitel.oss.kernel.directories.address.common.service.AddressService;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrAddress;

@WebService(endpointInterface="ru.bitel.bgbilling.plugins.gar.common.service.GarService")
public class GarServiceImpl
extends AbstractService
implements GarService {
    private GarServer garServer;

    @PostConstruct
    public void setUp() {
        this.garServer = new GarServer();
    }

    public List<IdTitle> regionList() throws BGException {
        ArrayList<IdTitle> regionList = new ArrayList<IdTitle>();
        JSONArray regions = new JSONArray(this.garServer.getRegionList());
        for (int i = 0; i < regions.length(); ++i) {
            JSONObject region = regions.getJSONObject(i);
            regionList.add(new IdTitle(region.getInt("regionId"), region.getString("regionTitle")));
        }
        return regionList;
    }

    public List<IdTitle> searchCitiesByContainsName(int regionId, String searchValue) throws BGException {
        ArrayList<IdTitle> cities = new ArrayList<IdTitle>();
        JSONArray citiesArray = new JSONArray(this.garServer.searchCitiesByContainsName(regionId, searchValue));
        for (int i = 0; i < citiesArray.length(); ++i) {
            JSONObject cityJson = citiesArray.optJSONObject(i);
            int cityId = cityJson.optInt("cityId");
            String cityTitle = cityJson.optString("cityPrefix") + "." + cityJson.optString("cityName");
            cities.add(new IdTitle(cityId, cityTitle));
        }
        return cities;
    }

    public GarAddressCity getGarCityInfoByCityId(long cityId) throws BGException {
        return this.cityFromJson(new JSONObject(this.garServer.getGarCityInfoByCityId(cityId)));
    }

    private GarAddressCity cityFromJson(JSONObject json) {
        if (json == null || json.isEmpty()) {
            return null;
        }
        GarAddressCity garAddressCity = new GarAddressCity(json.optInt("cityId"), json.optString("cityName"));
        garAddressCity.setCladrCode(json.optString("cladrCode"));
        garAddressCity.setGarObjectId(json.optLong("garObjectId"));
        garAddressCity.setTypeName(json.optString("cityPrefix"));
        garAddressCity.setFullName(json.optString("fullAddress"));
        return garAddressCity;
    }

    public List<GarAddressStreet> getStreetsByCityId(long cityId) throws BGException {
        ArrayList<GarAddressStreet> streets = new ArrayList<GarAddressStreet>();
        JSONArray streetsJson = new JSONObject(this.garServer.getStreetsByCityId(cityId)).optJSONArray("streets");
        for (int i = 0; i < streetsJson.length(); ++i) {
            JSONObject streetJson = streetsJson.optJSONObject(i);
            GarAddressStreet street = new GarAddressStreet();
            street.setId(streetJson.optInt("streetId"));
            street.setTitle(streetJson.optString("streetName"));
            street.setTypeName(streetJson.optString("streetPrefix"));
            street.setGarObjectId(streetJson.optLong("garObjectId"));
            ArrayList<GarAddressHouse> houseList = new ArrayList<GarAddressHouse>();
            JSONArray houses = streetJson.optJSONArray("houses");
            for (int j = 0; j < houses.length(); ++j) {
                JSONObject house = houses.optJSONObject(j);
                houseList.add(new GarAddressHouse(house.optInt("garObjectId"), house.optString("houseNumber"), house.optLong("streetId"), house.optString("postIndex"), house.optString("cadastralNumber")));
            }
            houseList.sort((house1, house2) -> Integer.compare(this.getHouseNum((GarAddressHouse)house1), this.getHouseNum((GarAddressHouse)house2)));
            street.setHouses(houseList);
            streets.add(street);
        }
        streets.sort(Comparator.comparing(IdTitle::getTitle));
        return streets;
    }

    private int getHouseNum(GarAddressHouse house) {
        if (Utils.isBlankString((String)house.getTitle())) {
            return -1;
        }
        String houseNumber = house.getTitle().replaceAll("[^0-9/]", "").split("/")[0];
        return Utils.parseInt((String)houseNumber, (int)-1);
    }

    public boolean checkLoadedRegion(int regionId) throws BGException {
        JSONObject response = new JSONObject(this.garServer.checkLoadedRegion(regionId));
        return !response.optBoolean("result");
    }

    public GarLoadedReport loadDataInDB(int countryId, GarAddressCity city, List<GarAddressStreet> streets, boolean streetWithHouses) throws BGException {
        if (city == null || Utils.isEmptyCollection(streets)) {
            throw new BGException("\u041d\u0435\u0442 \u0434\u0430\u043d\u043d\u044b\u0445 \u0434\u043b\u044f \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f");
        }
        if (countryId <= 0) {
            throw new BGException("\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d\u0430 \u0441\u0442\u0440\u0430\u043d\u0430 \u0434\u043b\u044f \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u0430\u0434\u0440\u0435\u0441\u043e\u0432");
        }
        return (GarLoadedReport)this.tryReturn(() -> {
            GarLoadedReport report = new GarLoadedReport();
            try (GarAddressDao garAddressDao = new GarAddressDao(this.getConnection());){
                GarLoader garLoader = new GarLoader(countryId, (ServerContext)ServerContext.get());
                String cityNameWithPrefix = city.getTypeName() + "." + city.getTitle();
                int cityId = garLoader.saveCityInDBIfNotExists(city);
                if (cityId > 0) {
                    report.setCreateNewCity(true);
                    report.setNewCityId(cityId);
                    report.setNewCityName(cityNameWithPrefix);
                    garAddressDao.update(new GarLoadedHistoryEntry(city.getGarObjectId(), GarAddressType.CITY, cityId, cityNameWithPrefix, this.userId));
                } else {
                    City oldCity = garLoader.findCityByTitle(city.getTitle());
                    cityId = oldCity.getId();
                }
                if (cityId <= 0) {
                    throw new BGException("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u0440\u0438\u0432\u044f\u0437\u0430\u0442\u044c \u0441\u043f\u0438\u0441\u043e\u043a \u0443\u043b\u0438\u0446 \u043a \u043d\u0430\u0441\u0435\u043b\u0451\u043d\u043d\u043e\u043c\u0443 \u043f\u0443\u043d\u043a\u0442\u0443. \u0423\u043b\u0438\u0446\u044b \u043d\u0435 \u0431\u0443\u0434\u0443\u0442 \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u044b.");
                }
                ArrayList<GarAddressStreet> loadedStreets = new ArrayList<GarAddressStreet>();
                for (GarAddressStreet street : streets) {
                    int streetIdInDB;
                    List<Street> oldStreets = garLoader.findStreet(cityId, street.getTitle());
                    if (Utils.isEmptyCollection(oldStreets)) {
                        streetIdInDB = garLoader.saveStreetInDB(cityId, street);
                        loadedStreets.add(street);
                        garAddressDao.update(new GarLoadedHistoryEntry(street.getGarObjectId(), GarAddressType.STREET, streetIdInDB, street.getTitle(), this.userId));
                    } else {
                        streetIdInDB = oldStreets.get(0).getId();
                    }
                    loadedStreets.add(street);
                    garAddressDao.update(new GarLoadedHistoryEntry(street.getGarObjectId(), GarAddressType.STREET, streetIdInDB, street.getTitle(), this.userId));
                    if (!streetWithHouses || streetIdInDB <= 0) continue;
                    garLoader.saveHousesByStreet(streetIdInDB, street);
                }
                report.setNewStreets(loadedStreets);
            }
            return report;
        });
    }

    public List<IdTitle> getCountries() throws BGException {
        return (List)this.tryReturn(() -> {
            ArrayList<IdTitle> result = new ArrayList<IdTitle>();
            AddressService addressService = (AddressService)this.context.getService(AddressService.class, 0);
            for (Country country : addressService.searchCountryList(null, null, null).getList()) {
                result.add(new IdTitle(country.getId(), country.getTitle()));
            }
            return result;
        });
    }

    public String loadRegion(int regionId) throws BGException {
        return this.garServer.startLoadRegion(regionId);
    }

    public SearchResult<GarLoadedHistoryEntry> getLoadedHistory(Page page, Date dateFrom, Date dateTo) throws BGException {
        try (GarAddressDao garAddressDao = new GarAddressDao(this.getConnection());){
            SearchResult result = new SearchResult(page);
            garAddressDao.searchEntries(dateFrom, dateTo, (SearchResult<GarLoadedHistoryEntry>)result);
            SearchResult searchResult = result;
            return searchResult;
        }
    }

    public JSONObject getCoordinatesByAddressString(String address) throws BGException {
        return this.garServer.getCoordinatesByAddress(address);
    }

    public String getCoordinatesByAddress(int houseId) throws BGException {
        return (String)this.tryReturn(() -> {
            AddressService addressService = (AddressService)this.context.getService(AddressService.class, 0);
            House house = addressService.houseGet(houseId);
            if (house == null) {
                throw new BGException("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c house \u0434\u043b\u044f houseId=" + houseId);
            }
            Street street = addressService.streetGet(house.getStreet().getId());
            StringBuilder addressStr = new StringBuilder();
            addressStr.append(street.getTitlePrefix()).append(" ").append(street.getTitle()).append(", ").append(house.getHouse()).append(", ").append(house.getCity().getTitle()).append(", ").append(house.getCountry().getTitle());
            return this.garServer.getCoordinatesByAddress(addressStr.toString().trim()).toString();
        });
    }

    public EntityAttrAddress getAddressByCoordinates(Double latitude, Double longitude) throws BGException {
        throw new UnsupportedOperationException("\u041f\u043e\u043a\u0430 \u043d\u0435 \u0440\u0435\u0430\u043b\u0438\u0437\u043e\u0432\u0430\u043d\u043e");
    }
}

