/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.admin.resource.bean;

import bitel.billing.server.admin.resource.bean.Resource;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import ru.bitel.bgbilling.common.BGException;

public abstract class ResourceManager<T extends Resource> {
    protected Connection con;
    protected int mid;
    protected String tableName;

    public ResourceManager(Connection con, int mid) {
        this.con = con;
        this.mid = mid;
        this.tableName = this.getTableName() + "_" + mid;
    }

    public void changeResourceCategory(String ids, int categoryId) throws SQLException {
        String query = "UPDATE " + this.tableName + " SET category_id=? WHERE id IN (" + ids + ")";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, categoryId);
            ps.executeUpdate();
        }
    }

    public int getResourceCount(int categoryId) throws SQLException {
        int result = 0;
        String query = "SELECT COUNT(*) FROM " + this.tableName + " WHERE category_id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, categoryId);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    result = rs.getInt(1);
                }
            }
        }
        return result;
    }

    public void deleteResource(String id) throws SQLException {
        String query = "DELETE FROM " + this.tableName + " WHERE id IN (" + id + ")";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.executeUpdate();
        }
    }

    protected void loadStandartResourceFromRs(ResultSet rs, Resource res) throws SQLException {
        res.setId(rs.getInt("id"));
        res.setDateFrom(rs.getDate("date1"));
        res.setDateTo(rs.getDate("date2"));
        res.setCategoryId(rs.getInt("category_id"));
    }

    public abstract void updateResource(T var1) throws SQLException;

    protected abstract T getResourceFromRs(ResultSet var1) throws SQLException;

    protected abstract String getTableName();

    public static ResourceManager<?> newResourceManager(String module, Connection con, int mid) throws BGException {
        return null;
    }

    public void syncResourceUse() throws BGException {
    }
}

