/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.customer.client.parameter;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.CalendarPanel;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.model.KeyValue;
import ru.bitel.bgbilling.kernel.customer.client.parameter.CustomerParamButton;
import ru.bitel.bgbilling.kernel.customer.client.parameter.CustomerParamCommonPanel;
import ru.bitel.bgbilling.kernel.customer.client.parameter.CustomerParamDate;
import ru.bitel.bgbilling.kernel.customer.client.parameter.CustomerParamPanel;
import ru.bitel.bgbilling.kernel.customer.client.parameter.CustomerParamTextField;
import ru.bitel.bgbilling.kernel.customer.common.bean.Customer;
import ru.bitel.bgbilling.kernel.customer.common.bean.CustomerContactType;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.list.BGUList;
import ru.bitel.common.client.table.BGTableModel;

public class CustomerParamFPanel
extends CustomerParamCommonPanel {
    private CustomerParamDate bDate = null;
    private CustomerParamButton gender = null;
    private CustomerParamTextField inn = null;
    private CustomerParamTextField name1 = null;
    private CustomerParamTextField name2 = null;
    private CustomerParamTextField name3 = null;
    private DocumentParamTableModel documentParamTableModel = new DocumentParamTableModel();
    List<DocumentParam> passport_rf = Arrays.asList(new DocumentParam(this, Customer.CustomerFizDocument.DOCUMENT_TYPE), new DocumentParam(this, Customer.CustomerFizDocument.PASSPORT_RF_SERIAL), new DocumentParam(this, Customer.CustomerFizDocument.PASSPORT_RF_NUMBER), new DocumentParam(this, Customer.CustomerFizDocument.PASSPORT_RF_CODE), new DocumentParam(this, Customer.CustomerFizDocument.PASSPORT_RF_WHO_GIVE), new DocumentParam(this, Customer.CustomerFizDocument.PASSPORT_RF_WHEN_GIVE), new DocumentParam(this, Customer.CustomerFizDocument.PASSPORT_RF_ADDRESS));
    List<DocumentParam> passport_foreign = Arrays.asList(new DocumentParam(this, Customer.CustomerFizDocument.DOCUMENT_TYPE), new DocumentParam(this, Customer.CustomerFizDocument.PASSPORT_FOREIGN_COUNTRY), new DocumentParam(this, Customer.CustomerFizDocument.PASSPORT_FOREIGN_NUMBER), new DocumentParam(this, Customer.CustomerFizDocument.PASSPORT_FOREIGN_WHO_GIVE), new DocumentParam(this, Customer.CustomerFizDocument.PASSPORT_FOREIGN_WHEN_GIVE), new DocumentParam(this, Customer.CustomerFizDocument.PASSPORT_FOREIGN_WHEN_EXPIRE));
    List<DocumentParam> residence_permit = Arrays.asList(new DocumentParam(this, Customer.CustomerFizDocument.DOCUMENT_TYPE), new DocumentParam(this, Customer.CustomerFizDocument.RESIDENCE_PERMIT_NUMBER), new DocumentParam(this, Customer.CustomerFizDocument.RESIDENCE_PERMIT_WHO_GIVE), new DocumentParam(this, Customer.CustomerFizDocument.RESIDENCE_PERMIT_WHEN_GIVE), new DocumentParam(this, Customer.CustomerFizDocument.RESIDENCE_PERMIT_WHEN_EXPIRE));
    List<DocumentParam> ident_card = Arrays.asList(new DocumentParam(this, Customer.CustomerFizDocument.DOCUMENT_TYPE), new DocumentParam(this, Customer.CustomerFizDocument.IDENT_CARD_SERIAL), new DocumentParam(this, Customer.CustomerFizDocument.IDENT_CARD_NUMBER), new DocumentParam(this, Customer.CustomerFizDocument.IDENT_CARD_WHO_GIVE), new DocumentParam(this, Customer.CustomerFizDocument.IDENT_CARD_WHEN_GIVE));

    public CustomerParamFPanel(CustomerParamPanel customerParamPanel) {
        super(customerParamPanel);
    }

    protected void jbInit() throws Exception {
        int gridx = 0;
        this.setLayout(new GridBagLayout());
        this.add(this.getF1Panel(), new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.getF2Panel(), new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.getContactsPanel(true, CustomerContactType.MOBILE, CustomerContactType.PHONE, CustomerContactType.EMAIL), new GridBagConstraints(gridx, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private JPanel getF1Panel() {
        this.name1 = new CustomerParamTextField(Customer.Keys.LAST_NAME, 20, this.clientSetup.get("dbinfo.customer.f.fio.last.regexp", "^[ \\-\u0410-\u042f\u0430-\u044f]*$"), this.customerParamPanel);
        this.name2 = new CustomerParamTextField(Customer.Keys.FIRST_NAME, 20, this.clientSetup.get("dbinfo.customer.f.fio.first.regexp", "^[ \\-\u0410-\u042f\u0430-\u044f]*$"), this.customerParamPanel);
        this.name3 = new CustomerParamTextField(Customer.Keys.MIDDLE_NAME, 20, this.clientSetup.get("dbinfo.customer.f.fio.middle.regexp", "^[ \\-\u0410-\u042f\u0430-\u044f]*$"), this.customerParamPanel);
        this.inn = new CustomerParamTextField(Customer.Keys.INN, 20, this.clientSetup.get("dbinfo.customer.f.inn.regexp", "^[0-9]{12}$"), this.customerParamPanel);
        int gridy = 0;
        Dimension dimension = new Dimension(400, 165);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setMinimumSize(dimension);
        panel.setPreferredSize(dimension);
        panel.setBorder(BorderFactory.createTitledBorder("\u041a\u043b\u0438\u0435\u043d\u0442"));
        panel.add((Component)new JLabel(this.name1.getTitle() + ":"), new GridBagConstraints(0, gridy, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 3, 3, 0), 0, 0));
        panel.add((Component)this.name1, new GridBagConstraints(1, gridy++, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 3, 5), 0, 0));
        panel.add((Component)new JLabel(this.name2.getTitle() + ":"), new GridBagConstraints(0, gridy, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 3, 3, 0), 0, 0));
        panel.add((Component)this.name2, new GridBagConstraints(1, gridy++, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 3, 5), 0, 0));
        panel.add((Component)new JLabel(this.name3.getTitle() + ":"), new GridBagConstraints(0, gridy, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 3, 3, 0), 0, 0));
        panel.add((Component)this.name3, new GridBagConstraints(1, gridy++, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 3, 5), 0, 0));
        panel.add((Component)new JLabel(this.inn.getTitle() + ":"), new GridBagConstraints(0, gridy, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 3, 0, 0), 0, 0));
        panel.add((Component)this.inn, new GridBagConstraints(1, gridy++, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        panel.add((Component)this.getF1aPanel(), new GridBagConstraints(0, gridy, 2, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 5, 0), 0, 0));
        return panel;
    }

    private JPanel getF1aPanel() {
        this.gender = new CustomerParamButton(new Dimension(30, 26), "\u041c", "\u0416", Customer.Keys.GENDER.key(), this.customerParamPanel);
        this.bDate = new CustomerParamDate(Customer.Keys.BIRTHDAY.key(), this.customerParamPanel);
        int gridx = 0;
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel(Customer.Keys.GENDER.description() + ":"), new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 3, 0, 0), 0, 0));
        panel.add((Component)this.gender, new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 5), 0, 0));
        panel.add((Component)new JLabel(Customer.Keys.BIRTHDAY.description() + ":"), new GridBagConstraints(gridx++, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 3, 0, 0), 0, 0));
        panel.add((Component)((Object)this.bDate), new GridBagConstraints(gridx, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
        return panel;
    }

    private JPanel getF2Panel() {
        BGUTable table = new BGUTable((TableModel)((Object)this.documentParamTableModel));
        table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2) {
                    DocumentParam documentParam = (DocumentParam)CustomerParamFPanel.this.documentParamTableModel.getSelectedRow();
                    if (documentParam == null) {
                        return;
                    }
                    if ("list".equals(documentParam.data.type())) {
                        List<KeyValue> values = Stream.of(Customer.CustomerFizDocument.PASSPORT_RF, Customer.CustomerFizDocument.PASSPORT_FOREIGN, Customer.CustomerFizDocument.RESIDENCE_PERMIT, Customer.CustomerFizDocument.IDENT_CARD).map(a -> {
                            String[] aa = a.key().split("/");
                            return new KeyValue(aa[aa.length - 1], a.description());
                        }).toList();
                        new ParamListEditor("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 \"" + documentParam.data.description() + "\"", documentParam, values).open();
                    } else if ("text".equals(documentParam.data.type())) {
                        new ParamTextEditor("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 \"" + documentParam.data.description() + "\"", documentParam).open();
                    } else if ("date".equals(documentParam.data.type())) {
                        new ParamDateEditor("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 \"" + documentParam.data.description() + "\"", documentParam).open();
                    }
                }
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createTitledBorder("\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442"));
        panel.add((Component)BGSwingUtilites.wrapScrollPane((JComponent)table, (int)550, (int)165), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 3, 5), 0, 0));
        return panel;
    }

    public void setData() {
        this.gender.setData();
        if (this.bDate != null) {
            this.bDate.setData();
        }
        this.inn.setData();
        this.name1.setData();
        this.name2.setData();
        this.name3.setData();
        this.contacts.forEach(CustomerParamCommonPanel.CustomerContactField::setData);
        Object object = ((ClientContext)this.customerParamPanel.getContext()).getCustomer().optQuery(Customer.CustomerFizDocument.DOCUMENT_TYPE.key());
        object = Optional.ofNullable(object).orElse("passport_rf");
        this.documentParamTableModel.setData(switch ((String)object) {
            case "passport_foreign" -> this.passport_foreign;
            case "residence_permit" -> this.residence_permit;
            case "ident_card" -> this.ident_card;
            default -> this.passport_rf;
        });
        this.documentParamTableModel.getRows().forEach(a -> this.setParamData((DocumentParam)a));
    }

    public void setParamData(DocumentParam documentParam) {
        String oldValue;
        Object object = ((ClientContext)this.customerParamPanel.getContext()).getCustomer().optQuery(documentParam.data.key());
        documentParam.value = oldValue = object == null ? "" : String.valueOf(object);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.setEnabledForContainer((JPanel)((Object)this), enabled);
    }

    private void setEnabledForContainer(JPanel container, boolean enabled) {
        for (Component component : container.getComponents()) {
            component.setEnabled(enabled);
            if (!(component instanceof JPanel)) continue;
            this.setEnabledForContainer((JPanel)component, enabled);
        }
    }

    class DocumentParamTableModel
    extends BGTableModel<DocumentParam> {
        public DocumentParamTableModel() {
            super(DocumentParamTableModel.class.getName());
        }

        protected void initColumns() {
            this.addColumn("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440", 100, 100, 100, "name", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435", 100, 200, -1, "value", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
        }

        public Object getValueAt(DocumentParam val, int column) throws Exception {
            String identifier = this.getIdentifier(column);
            if ("name".equals(identifier)) {
                return val.data.description();
            }
            if ("value".equals(identifier)) {
                if (val.data == Customer.CustomerFizDocument.DOCUMENT_TYPE) {
                    if ("".equals(val.value) || "passport_rf".equals(val.value)) {
                        return Customer.CustomerFizDocument.PASSPORT_RF.description();
                    }
                    if ("passport_foreign".equals(val.value)) {
                        return Customer.CustomerFizDocument.PASSPORT_FOREIGN.description();
                    }
                    if ("residence_permit".equals(val.value)) {
                        return Customer.CustomerFizDocument.RESIDENCE_PERMIT.description();
                    }
                    if ("ident_card".equals(val.value)) {
                        return Customer.CustomerFizDocument.IDENT_CARD.description();
                    }
                    return val.value;
                }
                if ("date".equals(val.data.type())) {
                    return TimeUtils.format((Date)TimeUtils.parseDate((String)val.value, (String)"yyyy-MM-dd"), (String)"dd.MM.yyyy");
                }
                return val.value;
            }
            return super.getValueAt((Object)val, column);
        }
    }

    class DocumentParam {
        private Customer.CustomerFizDocument data;
        private String value;

        public DocumentParam(CustomerParamFPanel this$0, Customer.CustomerFizDocument data) {
            this.data = data;
        }
    }

    class ParamDateEditor
    extends BGEditorDialog<DocumentParam> {
        private CalendarPanel controlPanelDate;

        public ParamDateEditor(String title, DocumentParam data) {
            super(title, (Object)data);
            this.controlPanelDate = new CalendarPanel();
        }

        public void doDialogPanel() {
            this.panel.add((Component)this.controlPanelDate, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 3, 3, 0), 0, 0));
            this.controlPanelDate.setCalendar(TimeUtils.parseCalendar((String)((DocumentParam)this.data).value, (String)"yyyy-MM-dd"));
        }

        public boolean doApply() throws Exception {
            String valueStr;
            Calendar value = this.controlPanelDate.getCalendar();
            if (value != null && ((ClientContext)CustomerParamFPanel.this.customerParamPanel.getContext()).getCustomerId() > 0 && !((DocumentParam)this.data).value.equals(valueStr = TimeUtils.format((Calendar)value, (String)"yyyy-MM-dd"))) {
                CustomerParamFPanel.this.customerParamPanel.updateCustomerValue(((DocumentParam)this.data).data.key(), valueStr);
                return true;
            }
            return false;
        }
    }

    class ParamTextEditor
    extends BGEditorDialog<DocumentParam> {
        private JTextField field;

        public ParamTextEditor(String title, DocumentParam data) {
            super(title, (Object)data);
            this.field = new JTextField(40);
        }

        public void doDialogPanel() {
            this.panel.add((Component)this.field, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 3, 3, 0), 0, 0));
            this.field.setText(((DocumentParam)this.data).value);
        }

        public boolean doApply() throws Exception {
            String value = this.field.getText();
            if (value != null && ((ClientContext)CustomerParamFPanel.this.customerParamPanel.getContext()).getCustomerId() > 0 && !((DocumentParam)this.data).value.equals(value)) {
                CustomerParamFPanel.this.customerParamPanel.updateCustomerValue(((DocumentParam)this.data).data.key(), value);
                return true;
            }
            return false;
        }
    }

    class ParamListEditor
    extends BGEditorDialog<DocumentParam> {
        private List<KeyValue> values;
        private BGUList<KeyValue> list;

        public ParamListEditor(String title, DocumentParam data, List<KeyValue> values) {
            super(title, (Object)data);
            this.list = new BGUList();
            this.values = values;
        }

        public void doDialogPanel() {
            this.list.setSelectionMode(0);
            this.list.setData(this.values);
            this.panel.add((Component)BGSwingUtilites.wrapScrollPane(this.list, (int)400, (int)300), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 3, 3, 0), 0, 0));
            ClientUtils.setKeyValueListSelection(this.list, (String)((DocumentParam)this.data).value, null);
        }

        public boolean doApply() throws Exception {
            KeyValue keyValue = (KeyValue)this.list.getSelectedValue();
            if (keyValue != null && ((ClientContext)CustomerParamFPanel.this.customerParamPanel.getContext()).getCustomerId() > 0 && !((DocumentParam)this.data).data.key().equals(keyValue.getKey())) {
                CustomerParamFPanel.this.customerParamPanel.updateCustomerValue(((DocumentParam)this.data).data.key(), keyValue.getKey());
                ((DocumentParam)this.data).value = keyValue.getKey();
                return true;
            }
            return false;
        }
    }
}

