/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.server.util;

import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.RedeliveryPolicy;

public class ActiveMQConnectionFactory
implements ConnectionFactory,
QueueConnectionFactory,
TopicConnectionFactory {
    private final org.apache.activemq.ActiveMQConnectionFactory factory;

    public ActiveMQConnectionFactory(String userName, String password, String brokerURL) {
        this.factory = new org.apache.activemq.ActiveMQConnectionFactory(userName, password, brokerURL);
    }

    public QueueConnection createQueueConnection() throws JMSException {
        return this.factory.createQueueConnection();
    }

    public QueueConnection createQueueConnection(String userName, String password) throws JMSException {
        return this.factory.createQueueConnection(userName, password);
    }

    public TopicConnection createTopicConnection() throws JMSException {
        return this.factory.createTopicConnection();
    }

    public TopicConnection createTopicConnection(String userName, String password) throws JMSException {
        return this.factory.createTopicConnection(userName, password);
    }

    public Connection createConnection() throws JMSException {
        ActiveMQConnection connection = (ActiveMQConnection)this.factory.createConnection();
        RedeliveryPolicy policy = connection.getRedeliveryPolicy();
        policy.setInitialRedeliveryDelay(1000L);
        policy.setBackOffMultiplier(5.0);
        policy.setUseExponentialBackOff(false);
        policy.setMaximumRedeliveries(100);
        return connection;
    }

    public Connection createConnection(String userName, String password) throws JMSException {
        ActiveMQConnection connection = (ActiveMQConnection)this.factory.createConnection(userName, password);
        RedeliveryPolicy policy = connection.getRedeliveryPolicy();
        policy.setInitialRedeliveryDelay(1000L);
        policy.setBackOffMultiplier(5.0);
        policy.setUseExponentialBackOff(false);
        policy.setMaximumRedeliveries(100);
        return connection;
    }
}

