/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.dynamic.client;

import bitel.billing.module.common.BSHEditor;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Box;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGToolTip;
import ru.bitel.bgbilling.client.common.BGUTabPanel;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.field.BGTextField;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.dynamic.client.DynamicCodeTemplatePanel;
import ru.bitel.bgbilling.kernel.dynamic.common.service.DynamicCodeService;
import ru.bitel.bgbilling.kernel.dynamic.common.templates.CustomTemplate;
import ru.bitel.common.Utils;

public class DynamicCodeTemplateEditPanel
extends BGUTabPanel {
    private DynamicCodeTemplatePanel parentPanel;
    private BGTextField titleField;
    private BGTextField extensionField;
    private String extensionPromptText = "(\u043d\u0430\u043f\u0440\u0438\u043c\u0435\u0440, java)";
    private JTextArea commentArea;
    private BSHEditor codeEditor;
    private CustomTemplate currentTemplate;
    private DynamicCodeService dynamicService;

    public DynamicCodeTemplateEditPanel(DynamicCodeTemplatePanel parentPanel) {
        this.parentPanel = parentPanel;
        this.dynamicService = ((ClientContext)parentPanel.getContext()).getPort(DynamicCodeService.class);
    }

    @Override
    protected void jbInit() throws Exception {
        JPanel leftPanel = new JPanel(new GridBagLayout());
        JPanel rightPanel = new JPanel(new GridBagLayout());
        this.titleField = new BGTextField();
        this.extensionField = new BGTextField();
        this.extensionField.setPromptText(this.extensionPromptText);
        this.commentArea = new JTextArea();
        this.commentArea.setMargin(new Insets(2, 2, 2, 2));
        this.commentArea.setLineWrap(true);
        BGButton saveButton = new BGButton("\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c");
        BGButton cancelButton = new BGButton("\u041e\u0442\u043c\u0435\u043d\u0430");
        this.codeEditor = new BSHEditor();
        leftPanel.add((Component)new Label("\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0448\u0430\u0431\u043b\u043e\u043d\u0430: *"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 2, new Insets(10, 5, 0, 10), 0, 0));
        leftPanel.add((Component)this.titleField, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 11, 2, new Insets(0, 5, 5, 5), 0, 0));
        leftPanel.add((Component)new Label("\u0420\u0430\u0441\u0448\u0438\u0440\u0435\u043d\u0438\u0435"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 11, 2, new Insets(5, 5, 0, 5), 0, 0));
        leftPanel.add((Component)this.extensionField, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 11, 2, new Insets(0, 5, 5, 5), 0, 0));
        leftPanel.add((Component)new Label("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439"), new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 11, 2, new Insets(5, 5, 0, 5), 0, 0));
        leftPanel.add((Component)new JScrollPane(this.commentArea), new GridBagConstraints(0, 5, 1, 1, 0.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        leftPanel.add(Box.createVerticalGlue(), new GridBagConstraints(0, 8, 1, 1, 1.0, 1.0, 11, 3, new Insets(0, 0, 0, 0), 0, 0));
        leftPanel.add(Box.createVerticalGlue(), new GridBagConstraints(0, 9, 1, 1, 1.0, 1.0, 11, 3, new Insets(0, 0, 0, 0), 0, 0));
        JPanel okCancelPanel = new JPanel(new GridBagLayout());
        okCancelPanel.add((Component)saveButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 5), 0, 0));
        okCancelPanel.add((Component)cancelButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 5), 0, 0));
        rightPanel.add((Component)okCancelPanel, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 15, 0, new Insets(5, 5, 0, 5), 0, 0));
        rightPanel.add((Component)this.codeEditor, new GridBagConstraints(0, 0, 3, 1, 1.0, 1.0, 18, 1, new Insets(10, 10, 0, 10), 0, 0));
        rightPanel.add(Box.createHorizontalGlue(), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 15, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.setLayout(new GridBagLayout());
        this.add((Component)leftPanel, new GridBagConstraints(0, 0, 1, 0, 0.0, 1.0, 11, 3, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)rightPanel, new GridBagConstraints(1, 0, 0, 0, 1.0, 1.0, 13, 1, new Insets(0, 0, 0, 0), 0, 0));
        saveButton.addActionListener(event -> {
            if (Utils.isBlankString(this.titleField.getText())) {
                BGToolTip.showErrorMessage(this.titleField, "\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0448\u0430\u0431\u043b\u043e\u043d\u0430!");
                return;
            }
            if (Utils.isBlankString(this.codeEditor.getText())) {
                BGToolTip.showErrorMessage(this.codeEditor, "\u0422\u0435\u043b\u043e \u0448\u0430\u0431\u043b\u043e\u043d\u0430 \u043d\u0435 \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u043f\u0443\u0441\u0442\u044b\u043c!");
                return;
            }
            this.saveCustomTemplate();
        });
        cancelButton.addActionListener(event -> {
            if (Utils.notBlankString(this.titleField.getText()) && Utils.notBlankString(this.codeEditor.getText())) {
                if (this.currentTemplate.getId() <= 0) {
                    if (ClientUtils.confirm("\u0412 \u0440\u0435\u0434\u0430\u043a\u0442\u043e\u0440\u0435 \u0435\u0441\u0442\u044c \u043d\u0435\u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u043d\u044b\u0435 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f. \u0425\u043e\u0442\u0438\u0442\u0435 \u0441\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u0434\u0430\u043d\u043d\u044b\u0435 \u043f\u0435\u0440\u0435\u0434 \u0437\u0430\u043a\u0440\u044b\u0442\u0438\u0435\u043c \u0432\u043a\u043b\u0430\u0434\u043a\u0438?", "\u041f\u0440\u0435\u0434\u0443\u043f\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435")) {
                        this.saveCustomTemplate();
                    }
                } else {
                    try {
                        CustomTemplate template = this.dynamicService.getTemplateById(this.currentTemplate.getId());
                        this.currentTemplate = this.getTemplateFromEditor();
                        if (!this.currentTemplate.equals(template) && ClientUtils.confirm("\u0412 \u0440\u0435\u0434\u0430\u043a\u0442\u043e\u0440\u0435 \u0435\u0441\u0442\u044c \u043d\u0435\u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u043d\u044b\u0435 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f. \u0425\u043e\u0442\u0438\u0442\u0435 \u0441\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u0434\u0430\u043d\u043d\u044b\u0435 \u043f\u0435\u0440\u0435\u0434 \u0437\u0430\u043a\u0440\u044b\u0442\u0438\u0435\u043c \u0432\u043a\u043b\u0430\u0434\u043a\u0438?", "\u041f\u0440\u0435\u0434\u0443\u043f\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435")) {
                            this.saveCustomTemplate();
                        }
                    }
                    catch (Exception ex) {
                        ClientUtils.showErrorMessageDialog(ex);
                    }
                }
            }
            this.showHidePanel(false);
        });
    }

    private void saveCustomTemplate() {
        try {
            this.dynamicService.updateTemplate(this.getTemplateFromEditor());
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
        this.parentPanel.performAction("refresh");
        this.showHidePanel(false);
    }

    private CustomTemplate getTemplateFromEditor() {
        CustomTemplate template = new CustomTemplate();
        if (this.currentTemplate.getId() > 0) {
            template.setId(this.currentTemplate.getId());
        }
        template.setTemplateData(this.codeEditor.getText());
        template.setComment(this.commentArea.getText());
        template.setExtension(this.getCurrectExtension(this.titleField.getText(), this.extensionField.getText()));
        template.setTitle(this.titleField.getText());
        return template;
    }

    protected void fillPanelEditor(CustomTemplate template) {
        if (template != null) {
            this.currentTemplate = (CustomTemplate)this.parentPanel.model.getSelectedRow();
            this.codeEditor.setText(this.currentTemplate.getTemplateData());
            this.titleField.setText(this.currentTemplate.getTitle());
            this.extensionField.setText(this.currentTemplate.getExtension());
            this.commentArea.setText(this.currentTemplate.getComment());
        } else {
            this.currentTemplate = new CustomTemplate();
            this.codeEditor.setText("");
            this.titleField.setText("");
            this.extensionField.setText("");
            this.extensionField.setPromptText(this.extensionPromptText);
            this.commentArea.setText("");
        }
        this.showHidePanel(true);
    }

    private String getCurrectExtension(String titleTemplate, String extension) {
        Matcher matcher;
        StringBuilder result = new StringBuilder("");
        Pattern pattern = Pattern.compile("[^\\s|\\d|\\W]|\\.");
        if (titleTemplate.contains(".")) {
            matcher = pattern.matcher(titleTemplate.substring(titleTemplate.indexOf(".") + 1));
        } else {
            if (extension.contains(".") && extension.indexOf(".") == 0) {
                extension.replaceFirst(".", "");
            }
            matcher = pattern.matcher(extension);
        }
        while (matcher.find()) {
            result.append(matcher.group());
        }
        return result.toString();
    }

    private void showHidePanel(boolean show) {
        this.setVisible(show);
        this.parentPanel.getTablePanel().setVisible(!show);
    }
}

