/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.sorm.server.upload.vasexpert;

import java.io.IOException;
import java.math.BigDecimal;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.api.common.util.MACParser;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.AbstractBalanceBean;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Payment;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.PaymentType;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.modules.inet.common.bean.InetServ;
import ru.bitel.bgbilling.modules.inet.common.service.InetServService;
import ru.bitel.bgbilling.modules.sorm.common.ConnectionStandard;
import ru.bitel.bgbilling.modules.sorm.common.UploadModulesTitle;
import ru.bitel.bgbilling.modules.sorm.common.bean.Bunch;
import ru.bitel.bgbilling.modules.sorm.common.bean.InstalledInstanceModule;
import ru.bitel.bgbilling.modules.sorm.common.bean.ServiceSorm;
import ru.bitel.bgbilling.modules.sorm.common.bean.SormProject;
import ru.bitel.bgbilling.modules.sorm.common.upload.vasexpert.VasExpertPaymentType;
import ru.bitel.bgbilling.modules.sorm.server.bean.InternalUser;
import ru.bitel.bgbilling.modules.sorm.server.bean.NumberRange;
import ru.bitel.bgbilling.modules.sorm.server.bean.SormCSVWriter;
import ru.bitel.bgbilling.modules.sorm.server.bean.SormContract;
import ru.bitel.bgbilling.modules.sorm.server.service.SormServiceImpl;
import ru.bitel.bgbilling.modules.sorm.server.upload.PaymentsToUpload;
import ru.bitel.bgbilling.modules.sorm.server.upload.Upload;
import ru.bitel.bgbilling.modules.sorm.server.upload.vasexpert.VasexpertConstants;
import ru.bitel.bgbilling.modules.sorm.server.upload.vasexpert.VasexpertFileTitle;
import ru.bitel.bgbilling.modules.sorm.server.utils.InternalUserAddressUtils;
import ru.bitel.bgbilling.modules.sorm.server.utils.SormUploadHelper;
import ru.bitel.bgbilling.modules.sorm.server.utils.SormUtils;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceAccount;
import ru.bitel.bgbilling.modules.voice.common.service.VoiceAccountService;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.inet.IpNet;
import ru.bitel.common.model.ContractId;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.Pair;
import ru.bitel.common.model.Period;
import ru.bitel.oss.kernel.entity.common.bean.AddressStruct;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrAddress;
import ru.bitel.oss.systems.inventory.resource.common.bean.Device;
import ru.bitel.oss.systems.inventory.resource.common.bean.IpCategory;
import ru.bitel.oss.systems.inventory.resource.common.bean.IpResource;
import ru.bitel.oss.systems.inventory.resource.common.bean.PhoneResourceSubscription;

public class VasexpertUpload
extends Upload {
    protected Logger logger = LogManager.getLogger();
    protected boolean useContractIdWithServiceId = this.config.get("sorm.upload.contractidwithservice", "0").equals("1");
    protected Path phoneNumberingFile;
    protected SormCSVWriter phoneNumberingWriter;
    protected Path emailsFile;
    protected SormCSVWriter emailsFileWriter;
    protected Path endUsersFile;
    protected SormCSVWriter endUsersFileWriter;

    public VasexpertUpload(int moduleId, SormProject sormProject, boolean isFullUpload) {
        super(moduleId, sormProject, isFullUpload);
    }

    @Override
    public Path abonents() {
        this.logger.info("\u0424\u043e\u0440\u043c\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u0444\u0430\u0439\u043b\u0430 \u0441 \u0430\u0431\u043e\u043d\u0435\u043d\u0442\u0430\u043c\u0438 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430");
        Path file = SormUtils.getUploadFile(this.localUserPath, VasexpertFileTitle.ABONENTS.getTitle(), "%s_%td%tm%tY%tH%tM%tS.txt");
        try (SormCSVWriter sormCSVWriter = SormUtils.getCSVFile(file);){
            Map<Integer, List<InetServ>> abonentServices = SormUtils.getPairsAbonentInetServices(this.config, this.contracts, this.serverContext);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("\u0412\u0441\u0435\u0433\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432 \u0434\u043b\u044f \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0438 \u043d\u0430\u0439\u0434\u0435\u043d\u043e: " + this.contracts.size());
            }
            if (Utils.notEmptyCollection((Collection)this.contracts)) {
                this.initPhoneNumberingFile();
                this.initEmailsFile();
                this.initEndUsersFile();
            }
            if (this.checkInstalledModule(UploadModulesTitle.INET)) {
                ConnectionStandard standart = ConnectionStandard.getConnectionStandart((int)this.config.getInt("sorm.upload.standart.inetconnection", 4));
                for (SormContract contract : this.contracts) {
                    this.helper.setCurrentContract(contract);
                    int cid = contract.getContractId();
                    List<InetServ> servList = abonentServices.get(cid);
                    if (Utils.isEmptyCollection(servList)) continue;
                    for (InetServ serv : servList) {
                        String login = serv.getLogin();
                        if (Utils.isBlankString((String)login)) {
                            login = String.valueOf(serv.getId());
                        }
                        String[] item = this.getAbonentItem(contract, login, serv.getId(), standart);
                        this.writeItemToFile(item, cid, VasexpertFileTitle.ABONENTS.getTitle(), sormCSVWriter);
                        this.uploadAdditionalAbonentInfo(item, contract, sormCSVWriter, serv.getId(), standart);
                    }
                }
            }
            if (this.checkInstalledModule(UploadModulesTitle.VOICE)) {
                ConnectionStandard connectionStandard = ConnectionStandard.getConnectionStandart((int)this.config.getInt("sorm.upload.standart.voiceconnection", 3));
                List<Integer> voiceMids = SormUtils.getTelephoneModulesIds(this.config).get(UploadModulesTitle.VOICE.getTitleModule());
                if (Utils.notEmptyCollection(voiceMids) && this.logger.isDebugEnabled()) {
                    this.logger.debug("\u0412\u044b\u0433\u0440\u0443\u0437\u043a\u0430 \u043b\u043e\u0433\u0438\u043d\u043e\u0432 \u0434\u043b\u044f \u043c\u043e\u0434\u0443\u043b\u044f Voice");
                }
                for (Integer voiceMid : voiceMids) {
                    VoiceAccountService accountService = (VoiceAccountService)this.serverContext.getService(VoiceAccountService.class, voiceMid.intValue());
                    for (SormContract contract : this.contracts) {
                        this.helper.setCurrentContract(contract);
                        for (VoiceAccount account : accountService.voiceAccountList(contract.getContractId(), 0, new Period(contract.getDateFrom(), contract.getDateTo()))) {
                            String number = account.getNumber() > 0L ? String.valueOf(account.getNumber()) : "";
                            String[] item = this.getAbonentItem(contract, number, 0, connectionStandard);
                            this.writeItemToFile(item, contract.getContractId(), VasexpertFileTitle.ABONENTS.getTitle(), sormCSVWriter);
                            this.uploadAdditionalAbonentInfo(item, contract, sormCSVWriter, account.getId(), connectionStandard);
                        }
                    }
                }
            }
            if (Utils.notEmptyCollection((Collection)this.contracts)) {
                SormUtils.updateContractLogTable(this);
            }
        }
        catch (Exception e) {
            String text = "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0435 \u0430\u0431\u043e\u043d\u0435\u043d\u0442\u043e\u0432: ";
            this.logger.error((Object)e);
            SormUtils.sendErrorToEmail(Setup.getSetup(), e, text, this.adminEmail);
        }
        this.logger.info("\u0417\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u043e");
        return file;
    }

    protected void uploadAdditionalAbonentInfo(String[] item, SormContract contract, SormCSVWriter csvFile, int serviceId, ConnectionStandard standard) throws BGException {
        int cid = contract.getContractId();
        if (!contract.isFiz() && item != null) {
            try {
                for (String[] internalUser : this.getInternalUsers(item, this.helper, serviceId)) {
                    this.writeToEndUsersFile(internalUser[1], item[1]);
                    this.writeItemToFile(internalUser, cid, VasexpertFileTitle.ABONENTS.getTitle(), csvFile);
                }
            }
            catch (Exception ex) {
                this.logger.error("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0435 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430: " + cid + " \u041e\u0448\u0438\u0431\u043a\u0430: " + String.valueOf(ex));
            }
        } else if (item != null) {
            Object identificator = String.valueOf(cid);
            if (this.useContractIdWithServiceId && standard.equals((Object)ConnectionStandard.STATIONARY) || standard.equals((Object)ConnectionStandard.UNDEFINED_STANDARD)) {
                identificator = cid + "_" + serviceId;
            }
            this.uploadFizAbonentsPhoneNumbers(contract, (String)identificator);
            this.uploadFizAbonentsEmails(contract, (String)identificator);
        }
    }

    protected void uploadFizAbonentsPhoneNumbers(SormContract contract, String identificator) {
        try {
            String phone = this.helper.getPhoneParam("sorm.upload.fiz.phone");
            if (Utils.isBlankString((String)phone)) {
                return;
            }
            this.writeItemToFile(this.getPhoneItem(identificator, this.normalizePhone(phone), contract.getDateFrom(), contract.getDateTo(), "Ethernet"), contract.getContractId(), VasexpertFileTitle.ABONENTS_PHONE_NUMBERING.getTitle(), this.phoneNumberingWriter);
        }
        catch (Exception ex) {
            String error = "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0435 \u043d\u043e\u043c\u0435\u0440\u0430 \u0442\u0435\u043b\u0435\u0444\u043e\u043d\u0430 \u0444\u0438\u0437.\u043b\u0438\u0446\u0430. cid:" + contract.getContractId() + ": " + String.valueOf(ex);
            this.logger.error(error);
            SormUtils.sendErrorToEmail(Setup.getSetup(), ex, error);
        }
    }

    protected void uploadFizAbonentsEmails(SormContract contract, String identificator) throws BGException {
        for (String email : this.helper.getEmails(true)) {
            String[] item = new String[]{"", identificator, Utils.maskBlank((String)email, (String)"").replaceAll("<", "").replaceAll(">", ""), contract.getDateFrom() != null ? TimeUtils.format((java.util.Date)contract.getDateFrom(), (String)"dd.MM.yyyy'T'HH:mm:ss") : "", contract.getDateTo() != null ? TimeUtils.format((java.util.Date)contract.getDateTo(), (String)"dd.MM.yyyy'T'HH:mm:ss") : ""};
            this.writeItemToFile(item, contract.getContractId(), VasexpertFileTitle.EMAILS.getTitle(), this.emailsFileWriter);
        }
    }

    protected String normalizePhone(String phone) {
        String result = phone.replaceAll("\\D", "");
        if (result.startsWith("8")) {
            result = result.replaceFirst("8", "7");
        }
        return result;
    }

    protected List<String[]> getInternalUsers(String[] item, SormUploadHelper uploadHelper, int serviceId) throws Exception {
        ArrayList<String[]> internalUsers = new ArrayList<String[]>();
        for (InternalUser internalUser : SormUtils.getInternalUsers(this.contractObjectDao, uploadHelper, this.config)) {
            String[] internalUserItem = Arrays.copyOfRange(item, 0, item.length);
            internalUserItem[1] = internalUser.getId() + "_" + serviceId;
            internalUserItem[7] = "0";
            internalUserItem[8] = "0";
            internalUserItem[9] = Utils.maskBlank((String)internalUser.getFirstName(), (String)"");
            internalUserItem[10] = Utils.maskBlank((String)internalUser.getMiddleName(), (String)"");
            internalUserItem[11] = Utils.maskBlank((String)internalUser.getLastName(), (String)"");
            internalUserItem[12] = "";
            internalUserItem[13] = internalUser.getBirthday() != null ? TimeUtils.format((java.util.Date)internalUser.getBirthday(), (String)"dd.MM.yyyy") : "";
            internalUserItem[14] = "0";
            internalUserItem[15] = Utils.maskBlank((String)internalUser.getDocumentSerial(), (String)"");
            internalUserItem[16] = Utils.maskBlank((String)internalUser.getDocumentNumber(), (String)"");
            internalUserItem[17] = internalUser.getDocumentWhenGive() != null ? TimeUtils.format((java.util.Date)internalUser.getDocumentWhenGive(), (String)"dd.MM.yyyy") : "";
            internalUserItem[18] = Utils.maskBlank((String)internalUser.getDocumentWhoGive(), (String)"");
            internalUserItem[19] = "";
            internalUserItem[20] = Utils.maskBlank((String)internalUser.getDocumentType(), (String)"");
            internalUserItem[22] = "";
            internalUserItem[23] = "";
            internalUserItem[24] = "";
            internalUserItem[25] = "";
            internalUserItem[26] = "";
            internalUserItem[27] = "";
            internalUserItem[28] = "";
            EntityAttrAddress entityAttrAddress = internalUser.getAddressStruct();
            if (entityAttrAddress != null) {
                String region = SormUtils.getParameterOfCity((Upload)this, entityAttrAddress.getHouseId(), "region");
                String zone = SormUtils.getParameterOfCity((Upload)this, entityAttrAddress.getHouseId(), "zone");
                InternalUserAddressUtils addressUtils = new InternalUserAddressUtils(entityAttrAddress, this.con);
                internalUserItem[29] = "0";
                internalUserItem[30] = addressUtils.getIndex();
                internalUserItem[31] = addressUtils.getCountry();
                internalUserItem[32] = "";
                internalUserItem[33] = Utils.maskBlank((String)region, (String)"");
                internalUserItem[34] = "";
                internalUserItem[35] = Utils.maskBlank((String)zone, (String)"");
                internalUserItem[36] = "";
                internalUserItem[37] = addressUtils.getCity();
                internalUserItem[38] = "";
                internalUserItem[39] = addressUtils.getStreet();
                internalUserItem[40] = addressUtils.getHouse();
                internalUserItem[41] = addressUtils.getFrac();
                internalUserItem[42] = "";
                internalUserItem[43] = addressUtils.getFlat();
                internalUserItem[44] = "";
            } else {
                internalUserItem[29] = "1";
                internalUserItem[30] = "";
                internalUserItem[31] = "";
                internalUserItem[32] = "";
                internalUserItem[33] = "";
                internalUserItem[34] = "";
                internalUserItem[35] = "";
                internalUserItem[36] = "";
                internalUserItem[37] = "";
                internalUserItem[38] = "";
                internalUserItem[39] = "";
                internalUserItem[40] = "";
                internalUserItem[41] = "";
                internalUserItem[42] = "";
                internalUserItem[43] = "";
                internalUserItem[44] = Utils.maskBlank((String)internalUser.getAddress(), (String)"");
            }
            AddressStruct address = this.helper.getCommutatorsAddress();
            if (SormUtils.checkValidAddress(address)) {
                String region = SormUtils.getParameterOfCity((Upload)this, address, "region");
                String zone = SormUtils.getParameterOfCity((Upload)this, address, "zone");
                internalUserItem[45] = "0";
                internalUserItem[46] = Utils.maskBlank((String)address.getIndex(), (String)"");
                internalUserItem[47] = Utils.maskBlank((String)address.getCountry(), (String)"");
                internalUserItem[48] = "";
                internalUserItem[49] = Utils.maskBlank((String)region, (String)"");
                internalUserItem[50] = "";
                internalUserItem[51] = Utils.maskBlank((String)zone, (String)"");
                internalUserItem[52] = "";
                internalUserItem[53] = Utils.maskBlank((String)address.getCity(), (String)"");
                internalUserItem[54] = "";
                internalUserItem[55] = Utils.maskBlank((String)address.getStreet(), (String)"");
                internalUserItem[56] = Utils.maskBlank((String)address.getHouse(), (String)"");
                internalUserItem[57] = Utils.maskBlank((String)address.getFrac(), (String)"");
                internalUserItem[58] = "";
                internalUserItem[59] = Utils.maskBlank((String)address.getFlat(), (String)"");
                internalUserItem[60] = "";
            } else {
                internalUserItem[45] = "1";
                internalUserItem[46] = "";
                internalUserItem[47] = "";
                internalUserItem[48] = "";
                internalUserItem[49] = "";
                internalUserItem[50] = "";
                internalUserItem[51] = "";
                internalUserItem[52] = "";
                internalUserItem[53] = "";
                internalUserItem[54] = "";
                internalUserItem[55] = "";
                internalUserItem[56] = "";
                internalUserItem[57] = "";
                internalUserItem[58] = "";
                internalUserItem[59] = "";
                internalUserItem[60] = "";
            }
            internalUserItem[61] = "1";
            internalUserItem[62] = "";
            internalUserItem[63] = "";
            internalUserItem[64] = "";
            internalUserItem[65] = "";
            internalUserItem[66] = "";
            internalUserItem[67] = "";
            internalUserItem[68] = "";
            internalUserItem[69] = "";
            internalUserItem[70] = "";
            internalUserItem[71] = "";
            internalUserItem[72] = "";
            internalUserItem[73] = "";
            internalUserItem[74] = "";
            internalUserItem[75] = "";
            internalUserItem[76] = "";
            internalUserItem[77] = "1";
            internalUserItem[78] = "";
            internalUserItem[79] = "";
            internalUserItem[80] = "";
            internalUserItem[81] = "";
            internalUserItem[82] = "";
            internalUserItem[83] = "";
            internalUserItem[84] = "";
            internalUserItem[85] = "";
            internalUserItem[86] = "";
            internalUserItem[87] = "";
            internalUserItem[88] = "";
            internalUserItem[89] = "";
            internalUserItem[90] = "";
            internalUserItem[91] = "";
            internalUserItem[92] = "";
            java.util.Date startDate = this.isFullUpload && internalUser.getDateFrom() != null ? internalUser.getDateFrom() : new java.util.Date();
            java.util.Date dateTo = internalUser.getDateTo() != null ? internalUser.getDateTo() : null;
            internalUserItem[93] = TimeUtils.format((java.util.Date)TimeUtils.clear_HOUR_MIN_MIL_SEC((java.util.Date)startDate), (String)"dd.MM.yyyy'T'HH:mm:ss");
            internalUserItem[94] = dateTo != null ? TimeUtils.format((java.util.Date)TimeUtils.clear_HOUR_MIN_MIL_SEC((java.util.Date)dateTo), (String)"dd.MM.yyyy'T'HH:mm:ss") : "";
            internalUsers.add(internalUserItem);
        }
        return internalUsers;
    }

    @Override
    public Path abonentsAddresses() {
        return null;
    }

    @Override
    public Path abonentLogins() {
        this.logger.info("\u0412\u044b\u0433\u0440\u0443\u0437\u043a\u0430 \u043b\u043e\u0433\u0438\u043d\u043e\u0432");
        Path file = SormUtils.getUploadFile(this.localUserPath, VasexpertFileTitle.BIND.getTitle(), VasexpertFileTitle.BIND.getTitle() + ".txt");
        List<SormContract> fullContractList = SormUtils.getUploadContracts(this, true);
        try (SormCSVWriter sormCSVWriter = SormUtils.getCSVFile(file, '\u0000');){
            if (this.checkInstalledModule(UploadModulesTitle.INET)) {
                HashMap<Object, String> loginWithIp = new HashMap<Object, String>();
                HashMap<Object, String> loginWithIPv6 = new HashMap<Object, String>();
                for (Integer inetMid : SormUtils.getSelectedInetModulesToUpload(this.config)) {
                    InetServService inetServService = (InetServService)this.serverContext.getService(InetServService.class, inetMid.intValue());
                    for (SormContract contract : fullContractList) {
                        List contractServices = inetServService.inetServList(contract.getContractId(), null);
                        for (InetServ serv : contractServices) {
                            IpNet ipNet;
                            String ip;
                            if (serv.getParentId() > 0 || serv.getDateTo() != null && serv.getDateTo().before(new java.util.Date())) continue;
                            Object login = serv.getLogin();
                            if (Utils.isBlankString((String)login)) {
                                login = this.useContractIdWithServiceId ? serv.getContractId() + "_" + serv.getId() : String.valueOf(contract.getContractId());
                            }
                            if (serv.getAddressFrom() != null && Utils.notBlankString((String)(ip = IpNet.newInstance((byte[])serv.getAddressFrom(), (byte[])serv.getAddressTo()).toString()))) {
                                String addressesForThisLogin = this.addToStringBetweenComma((String)loginWithIp.get(login), ip);
                                loginWithIp.put(login, addressesForThisLogin);
                            }
                            if (serv.getFramedIPv6Prefix() == null && serv.getDelegatedIPv6Prefix() == null) continue;
                            String val = (String)loginWithIPv6.get(login);
                            if (serv.getFramedIPv6Prefix() != null) {
                                ipNet = new IpNet(serv.getFramedIPv6Prefix(), (int)serv.getFramedIPv6PrefixLength());
                                val = this.addToStringBetweenComma(val, ipNet.toString());
                            }
                            if (serv.getDelegatedIPv6Prefix() != null) {
                                ipNet = new IpNet(serv.getDelegatedIPv6Prefix(), (int)serv.getDelegatedIPv6PrefixLength());
                                val = this.addToStringBetweenComma(val, ipNet.toString());
                            }
                            if (serv.getFramedIPv6Address() != null) {
                                ipNet = new IpNet(serv.getFramedIPv6Address(), 0);
                                val = this.addToStringBetweenComma(val, ipNet.toString());
                            }
                            loginWithIPv6.put(login, val);
                        }
                    }
                }
                for (String login : loginWithIp.keySet()) {
                    this.writeItemToFile(this.getLoginItem(login, (String)loginWithIp.get(login)), -1, VasexpertFileTitle.BIND.getTitle(), sormCSVWriter);
                }
                for (String login : loginWithIPv6.keySet()) {
                    this.writeItemToFile(this.getLoginItem(login, (String)loginWithIp.get(login)), -1, VasexpertFileTitle.BIND.getTitle(), sormCSVWriter);
                }
            }
            this.logger.info("\u0417\u0430\u043a\u043e\u043d\u0447\u0435\u043d\u0430 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0430 \u043b\u043e\u0433\u0438\u043d\u043e\u0432 \u0430\u0431\u043e\u043d\u0435\u043d\u0442\u043e\u0432");
        }
        catch (Exception e) {
            String text = "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0435 \u043b\u043e\u0433\u0438\u043d\u043e\u0432 \u0430\u0431\u043e\u043d\u0435\u043d\u0442\u043e\u0432";
            this.logger.error(text + "\n " + e.getMessage());
            SormUtils.sendErrorToEmail(Setup.getSetup(), e, text, this.adminEmail);
        }
        return file;
    }

    protected String addToStringBetweenComma(String parent, String value) {
        Object result = parent;
        result = Utils.notBlankString((String)parent) ? (String)result + "," + value : value;
        return result;
    }

    protected String[] getLoginItem(String login, String ip) {
        String[] item = new String[]{login, ip};
        return item;
    }

    @Override
    public Path services() {
        this.logger.info("\u0412\u044b\u0433\u0440\u0443\u0437\u043a\u0430 \u0443\u0441\u043b\u0443\u0433 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430");
        Path file = SormUtils.getUploadFile(this.localUserPath, VasexpertFileTitle.SERVICE_LIST.getTitle(), "%s_%td%tm%tY%tH%tM%tS.txt");
        try (SormCSVWriter sormCSVWriter = SormUtils.getCSVFile(file);){
            List<ServiceSorm> services = SormUtils.getSelectedServicesForUpload(this.config);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("\u0412\u0441\u0435\u0433\u043e \u0443\u0441\u043b\u0443\u0433 \u0434\u043b\u044f \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0438: " + services.size());
            }
            for (ServiceSorm service : services) {
                try {
                    String[] item = new String[6];
                    item[0] = String.valueOf(service.getId());
                    item[1] = service.getTitle();
                    item[2] = Utils.maskBlank((String)service.getDescription(), (String)"");
                    String operatorStartDate = this.config.get("sorm.upload.operator.startdate");
                    item[3] = Utils.isBlankString((String)operatorStartDate) ? "01.01.2005" : operatorStartDate;
                    item[4] = "";
                    String type = "unknown";
                    if (service.isPhoneServiceType()) {
                        type = "PSTN";
                    }
                    if (service.isInetServiceType()) {
                        type = "Ethernet";
                    }
                    item[5] = type;
                    this.writeItemToFile(item, -1, VasexpertFileTitle.SERVICE_LIST.getTitle(), sormCSVWriter);
                }
                catch (Exception ex) {
                    this.logger.error((Object)ex);
                }
            }
            this.logger.info("\u0412\u044b\u0433\u0440\u0443\u0437\u043a\u0430 \u0442\u0430\u0440\u0438\u0444\u043e\u0432 \u0438 \u0443\u0441\u043b\u0443\u0433 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430 \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0430");
        }
        catch (Exception e) {
            String text = "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0435 \u0442\u0430\u0440\u0438\u0444\u043e\u0432 \u0438 \u0443\u0441\u043b\u0443\u0433";
            this.logger.error(text + "\n " + String.valueOf(e));
            SormUtils.sendErrorToEmail(Setup.getSetup(), e, text, this.adminEmail);
        }
        return file;
    }

    @Override
    public Path abonentServices() {
        this.logger.info("\u0412\u044b\u0433\u0440\u0443\u0437\u043a\u0430 \u0443\u0441\u043b\u0443\u0433 \u0430\u0431\u043e\u043d\u0435\u043d\u0442\u043e\u0432");
        Path file = SormUtils.getUploadFile(this.localUserPath, VasexpertFileTitle.ABONENTS_TARIFFS.getTitle(), "%s_%td%tm%tY%tH%tM%tS.txt");
        try (SormCSVWriter sormCSVWriter = SormUtils.getCSVFile(file);){
            String idsServices = Utils.toString(SormUtils.getIdsServices(this.config));
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("\u0412\u044b\u0433\u0440\u0443\u0437\u043a\u0430 \u0443\u0441\u043b\u0443\u0433 \u0430\u0431\u043e\u043d\u0435\u043d\u0442\u043e\u0432. \u0412\u044b\u0433\u0440\u0443\u0436\u0430\u0435\u043c \u0443\u0441\u043b\u0443\u0433\u0438 \u0434\u043b\u044f \u0430\u0431\u043e\u043d\u0435\u043d\u0442\u043e\u0432, \u0443 \u043a\u043e\u0442\u043e\u0440\u044b\u0445 \u0435\u0441\u0442\u044c \u043a\u0430\u043a\u0430\u044f-\u043b\u0438\u0431\u043e \u0443\u0441\u043b\u0443\u0433\u0430 \u0438\u0437 \u0441\u043f\u0438\u0441\u043a\u0430: " + idsServices);
                this.logger.debug("\u0410\u0431\u043e\u043d\u0435\u043d\u0442\u043e\u0432 \u0432 \u0441\u043f\u0438\u0441\u043a\u0435: " + this.contracts.size());
            }
            Map<Integer, List<InetServ>> contractInetServices = SormUtils.getPairsAbonentInetServices(this.config, this.contracts, this.serverContext);
            List<InstalledInstanceModule> npayModules = new SormServiceImpl().getInstanceModules("npay");
            for (int x = 0; x < npayModules.size(); ++x) {
                String npayServiceTable = ServerUtils.getModuleTableName((String)"npay_service_object", (int)npayModules.get(x).getModuleId());
                if (!ServerUtils.tableExists((Connection)this.con, (String)npayServiceTable)) {
                    this.logger.error("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0442\u0430\u0431\u043b\u0438\u0446\u0430" + npayServiceTable + " \u0441 \u0443\u0441\u043b\u0443\u0433\u0430\u043c\u0438 \u043c\u043e\u0434\u0443\u043b\u044f Npay \u0434\u043b\u044f \u043c\u043e\u0434\u0443\u043b\u044f: " + npayModules.get(x).getModuleId());
                    continue;
                }
                String query = "SELECT nso.sid AS sid, s.title AS title, nso.date1 AS date1, nso.date2 AS date2 FROM " + npayServiceTable + " AS nso LEFT JOIN service AS s ON nso.sid=s.id WHERE cid=?";
                if (Utils.notBlankString((String)idsServices)) {
                    query = query + " AND sid in (" + idsServices + ")";
                }
                List<ServiceSorm> services = SormUtils.getSelectedServicesForUpload(this.config);
                HashMap servicesDescription = new HashMap();
                services.forEach(s -> servicesDescription.put(s.getId(), Utils.maskBlank((String)s.getDescription(), (String)"")));
                try (PreparedStatement ps = this.con.prepareStatement(query);){
                    for (SormContract contract : this.contracts) {
                        int cid = contract.getContractId();
                        ps.setInt(1, cid);
                        ResultSet rs = ps.executeQuery();
                        while (rs.next()) {
                            int sid = rs.getInt("sid");
                            Date date1 = rs.getDate("date1");
                            java.util.Date date2 = rs.getDate("date2");
                            if (date2 != null && TimeUtils.dateEqual((java.util.Date)date1, (java.util.Date)date2)) {
                                Calendar dateToCalendar = TimeUtils.convertDateToCalendar((java.util.Date)date2);
                                dateToCalendar.add(5, 1);
                                date2 = dateToCalendar.getTime();
                            }
                            String serviceTitle = rs.getString("title");
                            String[] item = new String[9];
                            item[0] = String.valueOf(sid);
                            item[2] = "";
                            item[3] = "";
                            item[4] = "";
                            item[5] = Utils.maskBlank((String)((String)servicesDescription.get(sid)), (String)serviceTitle);
                            item[6] = date1 != null ? TimeUtils.format((java.util.Date)date1, (String)"dd.MM.yyyy") : "31.12.1970";
                            item[7] = date2 != null ? TimeUtils.format((java.util.Date)date2, (String)"dd.MM.yyyy") : "";
                            item[8] = "";
                            List<InetServ> contractInetServiceList = contractInetServices.get(cid);
                            if (Utils.isEmptyCollection(contractInetServiceList)) {
                                item[1] = String.valueOf(cid);
                                this.writeItemToFile(item, cid, VasexpertFileTitle.ABONENTS_TARIFFS.getTitle(), sormCSVWriter);
                                continue;
                            }
                            for (InetServ serv : contractInetServiceList) {
                                item[1] = this.useContractIdWithServiceId ? cid + "_" + serv.getId() : String.valueOf(cid);
                                this.writeItemToFile(item, cid, VasexpertFileTitle.ABONENTS_TARIFFS.getTitle(), sormCSVWriter);
                            }
                        }
                    }
                    continue;
                }
            }
            this.logger.info("\u0412\u044b\u0433\u0440\u0443\u0437\u043a\u0430 \u0443\u0441\u043b\u0443\u0433 \u0430\u0431\u043e\u043d\u0435\u043d\u0442\u043e\u0432 \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0430");
        }
        catch (Exception e) {
            String text = "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0435 \u0443\u0441\u043b\u0443\u0433 \u0430\u0431\u043e\u043d\u0435\u043d\u0442\u043e\u0432";
            this.logger.error(text + "\n " + String.valueOf(e));
            SormUtils.sendErrorToEmail(Setup.getSetup(), e, text, this.adminEmail);
        }
        return file;
    }

    @Override
    public Path ipNumbering() {
        this.logger.info("\u0412\u044b\u0433\u0440\u0443\u0437\u043a\u0430 \u0434\u0430\u043d\u043d\u044b\u0445 \u043f\u043e ip-\u043d\u0443\u043c\u0435\u0440\u0430\u0446\u0438\u0438 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430");
        Path file = SormUtils.getUploadFile(this.localUserPath, VasexpertFileTitle.IP_NUMBERING.getTitle(), "%s_%td%tm%tY%tH%tM%tS.txt");
        try (SormCSVWriter sormCSVWriter = SormUtils.getCSVFile(file);){
            Map<IpCategory, List<IpResource>> categoriesWithResources = SormUtils.getIPResources(this.config, this.serverContext);
            for (Map.Entry<IpCategory, List<IpResource>> entry : categoriesWithResources.entrySet()) {
                String ipCategoryComment = entry.getKey().getComment();
                for (IpResource ip : entry.getValue()) {
                    try {
                        IpNet ipNet = IpNet.newInstance((byte[])ip.getAddressFrom(), (byte[])ip.getAddressTo());
                        String cidrNotation = ipNet.toString();
                        String[] item = new String[4];
                        item[0] = cidrNotation == null ? "" : cidrNotation;
                        String resourceComment = Utils.notBlankString((String)ip.getComment()) ? ip.getComment() : "";
                        String comment = Utils.isBlankString((String)ipCategoryComment) ? resourceComment : ipCategoryComment;
                        item[1] = SormUtils.trimField(comment, 256);
                        item[2] = ip.getDateFrom() == null ? "" : TimeUtils.format((java.util.Date)ip.getDateFrom(), (String)"dd.MM.yyyy'T'HH:mm:ss");
                        item[3] = ip.getDateFrom() == null ? "" : TimeUtils.format((java.util.Date)ip.getDateTo(), (String)"dd.MM.yyyy'T'HH:mm:ss");
                        this.writeItemToFile(item, -1, VasexpertFileTitle.IP_NUMBERING.getTitle(), sormCSVWriter);
                    }
                    catch (Exception ex) {
                        this.logger.error("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0435 \u0440\u0435\u0441\u0443\u0440\u0441\u0430: " + ip.getId());
                    }
                }
            }
        }
        catch (Exception ex) {
            String text = "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0435 \u0434\u0430\u043d\u043d\u044b\u0445 \u043f\u043e ip-\u043d\u0443\u043c\u0435\u0440\u0430\u0446\u0438\u0438 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430";
            this.logger.error(text + "\n " + ex.getMessage());
            SormUtils.sendErrorToEmail(Setup.getSetup(), ex, text, this.adminEmail);
        }
        return file;
    }

    @Override
    public Path abonentsIpNumbering() {
        this.logger.info("\u0412\u044b\u0433\u0440\u0443\u0437\u043a\u0430 ip-\u0430\u0434\u0440\u0435\u0441\u043e\u0432 \u0430\u0431\u043e\u043d\u0435\u043d\u0442\u043e\u0432 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430");
        Path file = SormUtils.getUploadFile(this.localUserPath, VasexpertFileTitle.ABONENTS_IP_ADDRESSES.getTitle(), "%s_%td%tm%tY%tH%tM%tS.txt");
        try (SormCSVWriter sormCSVWriter = SormUtils.getCSVFile(file);){
            for (Integer mid : SormUtils.getSelectedInetModulesToUpload(this.config)) {
                if (!this.checkInstalledModule(UploadModulesTitle.INET)) continue;
                InetServService inetServService = (InetServService)this.serverContext.getService(InetServService.class, mid.intValue());
                for (SormContract contract : this.contracts) {
                    for (InetServ serv : inetServService.inetServList(contract.getContractId(), null)) {
                        String ip;
                        if (serv.getAddressFrom() == null || Utils.isBlankString((String)(ip = IpNet.newInstance((byte[])serv.getAddressFrom(), (byte[])serv.getAddressTo()).toString())) || serv.getParentId() > 0) continue;
                        String[] item = new String[]{"", this.useContractIdWithServiceId ? serv.getContractId() + "_" + serv.getId() : String.valueOf(serv.getContractId()), ip, "1", serv.getDateFrom() != null ? TimeUtils.formatDate((java.util.Date)serv.getDateFrom()) + "T00:00:00" : "", serv.getDateTo() != null ? TimeUtils.formatDate((java.util.Date)serv.getDateTo()) + "T00:00:00" : "", serv.getMacAddressListBytes() == null ? "" : MACParser.macAddressToString((byte[])serv.getMacAddressListBytes()), ""};
                        this.writeItemToFile(item, serv.getContractId(), VasexpertFileTitle.ABONENTS_IP_ADDRESSES.getTitle(), sormCSVWriter);
                    }
                }
            }
            this.logger.info("\u0417\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0430 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0430 \u043f\u043e ip \u0430\u0434\u0440\u0435\u0441\u0430\u043c \u0430\u0431\u043e\u043d\u0435\u043d\u0442\u043e\u0432");
        }
        catch (Exception e) {
            String text = "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0435 ip-\u043d\u0443\u043c\u0435\u0440\u0430\u0446\u0438\u0438 \u0430\u0431\u043e\u043d\u0435\u043d\u0442\u043e\u0432 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430";
            this.logger.error(text + "\n " + e.getMessage());
            SormUtils.sendErrorToEmail(Setup.getSetup(), e, text, this.adminEmail);
        }
        return file;
    }

    @Override
    public Path switches() {
        this.logger.info("\u0412\u044b\u0433\u0440\u0443\u0437\u043a\u0430 \u0434\u0430\u043d\u043d\u044b\u0445 \u043f\u043e \u043a\u043e\u043c\u043c\u0443\u0442\u0430\u0442\u043e\u0440\u0430\u043c \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430");
        Path file = SormUtils.getUploadFile(this.localUserPath, VasexpertFileTitle.SWITCHES.getTitle(), "%s_%td%tm%tY%tH%tM%tS.txt");
        try (SormCSVWriter sormCSVWriter = SormUtils.getCSVFile(file);){
            if (this.config.get("sorm.upload.switches.enable", "").equals("1") && this.checkInstalledModule(UploadModulesTitle.INET)) {
                ArrayList voiceDeviceIds = new ArrayList();
                if (this.checkInstalledModule(UploadModulesTitle.VOICE)) {
                    voiceDeviceIds.addAll(SormUtils.getVoiceDevices(this.config, this.serverContext).stream().mapToInt(Id::getId).boxed().collect(Collectors.toList()));
                }
                List<Device<?, ?>> allInetDevices = SormUtils.getInetDevices(this.config, this.serverContext);
                for (Device<?, ?> device : allInetDevices) {
                    EntityAttrAddress address = SormUtils.getAddressFromDeviceAttributes(device);
                    String deviceComment = Utils.isBlankString((String)device.getComment()) ? "" : " " + device.getComment();
                    Object inetDeviceId = voiceDeviceIds.contains(device.getId()) ? "inet_" + device.getId() : String.valueOf(device.getId());
                    String[] item = this.getSwitchItem((String)inetDeviceId, device.getTitle() + deviceComment, "Ethernet", address != null ? address.toString() : "", device.getDateFrom(), device.getDateTo());
                    this.writeItemToFile(item, -1, VasexpertFileTitle.SWITCHES.getTitle(), sormCSVWriter);
                }
            }
            if (this.config.get("sorm.upload.commutators.enable").equals("1") && this.checkInstalledModule(UploadModulesTitle.VOICE)) {
                List<Device<?, ?>> voiceDeviceList = SormUtils.getVoiceDevices(this.config, this.serverContext);
                for (Device<?, ?> voiceDevice : voiceDeviceList) {
                    EntityAttrAddress address = SormUtils.getAddressFromDeviceAttributes(voiceDevice);
                    String deviceComment = Utils.isBlankString((String)voiceDevice.getComment()) ? "" : " " + voiceDevice.getComment();
                    String[] item = this.getSwitchItem(String.valueOf(voiceDevice.getId()), voiceDevice.getTitle() + deviceComment, "PSTN", address != null ? address.toString() : voiceDevice.getComment(), voiceDevice.getDateFrom(), voiceDevice.getDateTo());
                    this.writeItemToFile(item, -1, VasexpertFileTitle.SWITCHES.getTitle(), sormCSVWriter);
                }
            }
        }
        catch (Exception ex) {
            String text = "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0438 \u0434\u0430\u043d\u043d\u044b\u0445 \u043f\u043e \u043a\u043e\u043c\u043c\u0443\u0442\u0430\u0442\u043e\u0440\u0430\u043c \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430";
            this.logger.error(text + "\n " + ex.getMessage());
            SormUtils.sendErrorToEmail(Setup.getSetup(), ex, text, this.adminEmail);
        }
        return file;
    }

    protected String[] getSwitchItem(String id, String title, String netType, String address, java.util.Date dateFrom, java.util.Date dateTo) {
        String[] item = new String[]{id, "internal", netType, SormUtils.trimField(title, 256), SormUtils.trimField(address, 1024), "", TimeUtils.format((java.util.Date)(dateFrom != null ? dateFrom : VasexpertConstants.TELEPHONY_START_DATE.getTime()), (String)"dd.MM.yyyy'T'HH:mm:ss"), dateTo == null ? "" : TimeUtils.format((java.util.Date)dateTo, (String)"dd.MM.yyyy'T'HH:mm:ss")};
        return item;
    }

    @Override
    public Path gateways() {
        this.logger.info("\u0412\u044b\u0433\u0440\u0443\u0437\u043a\u0430 \u0448\u043b\u044e\u0437\u043e\u0432 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430");
        Path uploadFile = SormUtils.getUploadFile(this.localUserPath, VasexpertFileTitle.GATEWAYS.getTitle(), "%s_%td%tm%tY%tH%tM%tS.txt");
        try (SormCSVWriter sormCSVWriter = SormUtils.getCSVFile(uploadFile);){
            if (this.checkInstalledModule(UploadModulesTitle.INET)) {
                for (Device<?, ?> inetDevice : SormUtils.getSelectedGateways(this.config, this.serverContext)) {
                    EntityAttrAddress address = SormUtils.getAddressFromDeviceAttributes(inetDevice);
                    String[] item = this.getGatewayItem(inetDevice.getId(), inetDevice.getComment(), address != null ? address.toString() : "", inetDevice.getDateFrom(), inetDevice.getDateTo(), inetDevice.getHost() != null ? inetDevice.getHost() : "");
                    this.writeItemToFile(item, -1, VasexpertFileTitle.GATEWAYS.getTitle(), sormCSVWriter);
                }
            }
        }
        catch (IOException | BGException e) {
            String text = "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0435 \u0448\u043b\u044e\u0437\u043e\u0432 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430";
            this.logger.error(text + "\n " + e.getMessage());
            SormUtils.sendErrorToEmail(Setup.getSetup(), (Exception)e, text, this.adminEmail);
        }
        return uploadFile;
    }

    protected String[] getGatewayItem(int id, String comment, String address, java.util.Date dateFrom, java.util.Date dateTo, String ipv4) {
        String[] item = new String[]{String.valueOf(id), "aaa", SormUtils.trimField(comment, 256), address, dateFrom == null ? "" : TimeUtils.format((java.util.Date)dateFrom, (String)"dd.MM.yyyy'T'HH:mm:ss"), dateTo == null ? "" : TimeUtils.format((java.util.Date)dateTo, (String)"dd.MM.yyyy'T'HH:mm:ss"), ipv4};
        return item;
    }

    @Override
    public Path bunches() {
        this.logger.info("\u0412\u044b\u0433\u0440\u0443\u0437\u043a\u0430 \u043f\u0443\u0447\u043a\u043e\u0432 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430");
        Path uploadFile = SormUtils.getUploadFile(this.localUserPath, VasexpertFileTitle.BUNCHES.getTitle(), "%s_%td%tm%tY%tH%tM%tS.txt");
        try (SormCSVWriter sormCSVWriter = SormUtils.getCSVFile(uploadFile);){
            List<Bunch> bunches = SormUtils.getBunches(this.config);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("\u041f\u0443\u0447\u043a\u043e\u0432 \u0441\u0444\u043e\u0440\u043c\u0438\u0440\u043e\u0432\u0430\u043d\u043e: " + bunches.size());
            }
            for (Bunch bunch : bunches) {
                this.writeItemToFile(this.getBunchItem(bunch), -1, VasexpertFileTitle.BUNCHES.getTitle(), sormCSVWriter);
            }
        }
        catch (IOException | BGException e) {
            String text = "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0435 \u043f\u0443\u0447\u043a\u043e\u0432 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430 ";
            this.logger.error(text + "\n" + e.getMessage());
            SormUtils.sendErrorToEmail(Setup.getSetup(), (Exception)e, text, this.adminEmail);
        }
        return uploadFile;
    }

    protected String[] getBunchItem(Bunch bunch) {
        String[] item = new String[]{String.valueOf(bunch.getId()), Utils.maskBlank((String)bunch.getIdCommutator(), (String)""), bunch.getDirectional().getValue(), SormUtils.trimField(bunch.getTitle() + ". " + bunch.getDescription(), 256), Utils.maskBlank((String)bunch.getMac(), (String)""), "", "", TimeUtils.format((java.util.Date)bunch.getDateStart(), (String)"dd.MM.yyyy'T'HH:mm:ss"), TimeUtils.format((java.util.Date)bunch.getDateEnd(), (String)"dd.MM.yyyy'T'HH:mm:ss")};
        return item;
    }

    @Override
    public Path phoneNumbering() {
        this.logger.info("\u0412\u044b\u0433\u0440\u0443\u0437\u043a\u0430 \u043d\u043e\u043c\u0435\u0440\u043d\u043e\u0439 \u0451\u043c\u043a\u043e\u0441\u0442\u0438 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430");
        Path uploadFile = SormUtils.getUploadFile(this.localUserPath, VasexpertFileTitle.PHONE_NUMBERING.getTitle(), "%s_%td%tm%tY%tH%tM%tS.txt");
        ArrayList<NumberRange> resources = new ArrayList<NumberRange>();
        if (this.checkInstalledModule(UploadModulesTitle.VOICE)) {
            resources.addAll(SormUtils.getUploadVoiceNumberingResources(this.config, this.serverContext));
        }
        try (SormCSVWriter sormCSVWriter = SormUtils.getCSVFile(uploadFile);){
            for (NumberRange numberRange : resources) {
                String phoneNumberPrefix;
                String[] item = new String[]{"PSTN", SormUtils.trimField("RU", 2), SormUtils.trimField("RUS", 3), SormUtils.trimField("7", 3), phoneNumberPrefix = SormUtils.trimField(String.valueOf(numberRange.getFromNumber()), 14).substring(1, 4), String.valueOf(phoneNumberPrefix.length()), "11", "11", "-12", "12", "\u0420\u043e\u0441\u0441\u0438\u044f", SormUtils.trimField(String.valueOf(numberRange.getFromNumber()), 15), SormUtils.trimField(String.valueOf(numberRange.getToNumber()), 15), String.valueOf(numberRange.getToNumber() - numberRange.getFromNumber() + 1L), SormUtils.trimField(this.config.get("sorm.upload.operator.location", ""), 255), SormUtils.trimField("250", 3), SormUtils.trimField("000", 3), SormUtils.trimField("", 128), SormUtils.trimField("", 255), SormUtils.trimField("", 4), TimeUtils.format((java.util.Date)(numberRange.getDateFrom() != null ? numberRange.getDateFrom() : VasexpertConstants.TELEPHONY_START_DATE.getTime()), (String)"dd.MM.yyyy'T'HH:mm:ss"), numberRange.getDateTo() != null ? TimeUtils.format((java.util.Date)numberRange.getDateTo(), (String)"dd.MM.yyyy'T'HH:mm:ss") : ""};
                this.writeItemToFile(item, -1, VasexpertFileTitle.PHONE_NUMBERING.getTitle(), sormCSVWriter);
            }
        }
        catch (Exception e) {
            String text = "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0435 \u043d\u043e\u043c\u0435\u0440\u043d\u043e\u0439 \u0451\u043c\u043a\u043e\u0441\u0442\u0438 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430 ";
            this.logger.error(text + "\n" + e.getMessage());
            SormUtils.sendErrorToEmail(Setup.getSetup(), e, text, this.adminEmail);
        }
        return uploadFile;
    }

    protected void initPhoneNumberingFile() throws IOException {
        if (this.phoneNumberingFile == null) {
            this.phoneNumberingFile = SormUtils.getUploadFile(this.localUserPath, VasexpertFileTitle.ABONENTS_PHONE_NUMBERING.getTitle(), "%s_%td%tm%tY%tH%tM%tS.txt");
            this.phoneNumberingWriter = SormUtils.getCSVFile(this.phoneNumberingFile);
        }
    }

    protected void initEmailsFile() throws IOException {
        if (this.emailsFile == null) {
            this.emailsFile = SormUtils.getUploadFile(this.localUserPath, VasexpertFileTitle.EMAILS.getTitle(), "%s_%td%tm%tY%tH%tM%tS.txt");
            this.emailsFileWriter = SormUtils.getCSVFile(this.emailsFile);
        }
    }

    protected void initEndUsersFile() throws IOException {
        if (this.endUsersFile == null) {
            this.endUsersFile = SormUtils.getUploadFile(this.localUserPath, VasexpertFileTitle.END_USERS.getTitle(), "%s_%td%tm%tY%tH%tM%tS.txt");
            this.endUsersFileWriter = SormUtils.getCSVFile(this.endUsersFile);
        }
    }

    @Override
    public Path phoneNumberingAbonents() {
        try {
            this.initPhoneNumberingFile();
            if (!this.config.get("sorm.upload.phonenumbering.enable", "").equals("1")) {
                return this.phoneNumberingFile;
            }
            Map<String, List<Integer>> telephoneModules = SormUtils.getTelephoneModulesIds(this.config);
            Map<Integer, List<PhoneResourceSubscription>> subscriptions = SormUtils.getVoiceModuleSubscriptionList(telephoneModules.get(UploadModulesTitle.VOICE.getTitleModule()), this.serverContext, this.config);
            if (this.checkInstalledModule(UploadModulesTitle.VOICE)) {
                for (Integer voiceModule : telephoneModules.get(UploadModulesTitle.VOICE.getTitleModule())) {
                    VoiceAccountService accountService = (VoiceAccountService)this.serverContext.getService(VoiceAccountService.class, voiceModule.intValue());
                    for (PhoneResourceSubscription subscription : subscriptions.get(voiceModule)) {
                        VoiceAccount voiceAccount = accountService.voiceAccountGet(subscription.getSubscriberId());
                        if (voiceAccount == null) continue;
                        int contractId = voiceAccount.getContractId();
                        if (!SormUtils.checkThreeYearsAgo(voiceAccount.getDateFrom()) || !SormUtils.contractHasModule(this.con, this.getModuleId(), contractId)) continue;
                        this.writeItemToFile(this.getPhoneItem(contractId, String.valueOf(voiceAccount.getNumber()), voiceAccount.getDateFrom(), voiceAccount.getDateTo()), contractId, VasexpertFileTitle.ABONENTS_PHONE_NUMBERING.getTitle(), this.phoneNumberingWriter);
                    }
                }
            }
        }
        catch (Exception e) {
            String text = "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0435 \u0442\u0435\u043b\u0435\u0444\u043e\u043d\u043d\u044b\u0445 \u043d\u043e\u043c\u0435\u0440 \u0430\u0431\u043e\u043d\u0435\u043d\u0442\u043e\u0432 ";
            this.logger.error(text + "\n" + e.getMessage());
            SormUtils.sendErrorToEmail(Setup.getSetup(), e, text, this.adminEmail);
        }
        return this.phoneNumberingFile;
    }

    protected String[] getPhoneItem(String identificator, String number, java.util.Date dateFrom, java.util.Date dateTo, String type) {
        Object phoneNumber = Utils.maskBlank((String)number, (String)"");
        if (Utils.notBlankString((String)number) && !number.startsWith("7") && number.length() == 10) {
            phoneNumber = "7" + number;
        }
        String[] item = new String[]{"", identificator, SormUtils.trimField((String)phoneNumber, 15), dateFrom != null ? TimeUtils.format((java.util.Date)dateFrom, (String)"dd.MM.yyyy'T'HH:mm:ss") : "", dateTo != null ? TimeUtils.format((java.util.Date)dateTo, (String)"dd.MM.yyyy'T'HH:mm:ss") : "", type, "", ""};
        return item;
    }

    protected String[] getPhoneItem(Integer contractId, String number, java.util.Date dateFrom, java.util.Date dateTo, String type) {
        return this.getPhoneItem(String.valueOf(contractId), number, dateFrom, dateTo, type);
    }

    protected String[] getPhoneItem(Integer contractId, String number, java.util.Date dateFrom, java.util.Date dateTo) {
        return this.getPhoneItem(contractId, number, dateFrom, dateTo, "PSTN");
    }

    @Override
    public Path documentTypes() {
        return null;
    }

    @Override
    public Path paymentTypes() {
        return null;
    }

    @Override
    public Path abonentsPayments() {
        this.logger.info("\u0412\u044b\u0433\u0440\u0443\u0437\u043a\u0430 \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439 \u0430\u0431\u043e\u043d\u0435\u043d\u0442\u043e\u0432");
        Path file = SormUtils.getUploadFile(this.localUserPath, VasexpertFileTitle.PAYMENTS.getTitle(), "%s_%td%tm%tY%tH%tM%tS.txt");
        try (SormCSVWriter sormCSVWriter = SormUtils.getCSVFile(file);){
            Directory paymentTypeDirectory = this.serverContext.getDirectory(PaymentType.class, -1);
            List<Payment> payments = this.paymentsToUpload.getPaymentsToUpload(true);
            List<Integer> cids = Utils.isEmptyCollection((Collection)this.contracts) ? payments.stream().mapToInt(AbstractBalanceBean::getContractId).boxed().toList() : this.contracts.stream().mapToInt(ContractId::getContractId).boxed().toList();
            Map<Integer, List<InetServ>> abonentInetServices = SormUtils.getPairsAbonentInetServicesByContractIds(this.config, cids, this.serverContext);
            this.logger.debug("\u0412\u0441\u0435\u0433\u043e \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439 \u0434\u043b\u044f \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0438: {}", (Object)payments.size());
            ParameterMap parameterMap = this.config.subKeyed("sorm.upload.paytype.ratio").getOrDefault("", null);
            for (Payment payment : payments) {
                int cid = payment.getContractId();
                List<InetServ> servList = abonentInetServices.get(cid);
                if (Utils.isEmptyCollection(servList)) continue;
                for (InetServ serv : servList) {
                    try {
                        String payTypeDescription;
                        String paymentDate;
                        String[] item = new String[6];
                        item[0] = this.useContractIdWithServiceId ? cid + "_" + serv.getId() : String.valueOf(cid);
                        item[1] = "";
                        java.util.Date date = payment.getTimeChange();
                        ZonedDateTime zonedDateTime = date.toInstant().atZone(ZoneId.systemDefault());
                        ZonedDateTime zonedDateTime1 = zonedDateTime.withZoneSameInstant(ZoneId.of("UTC"));
                        item[2] = paymentDate = DateTimeFormatter.ofPattern("dd.MM.yyyy'T'HH:mm:ss").format(zonedDateTime1);
                        item[3] = Utils.formatBigDecimalSumm((BigDecimal)payment.getSum());
                        PaymentType paymentType = (PaymentType)paymentTypeDirectory.get(payment.getTypeId());
                        String string = payTypeDescription = paymentType != null ? paymentType.getTitle() : "";
                        if (paymentType != null && parameterMap != null) {
                            int ratioValue = parameterMap.getInt(String.valueOf(paymentType.getId()), -1);
                            VasExpertPaymentType vasExpertPaymentType = VasExpertPaymentType.getType((int)ratioValue);
                            payTypeDescription = vasExpertPaymentType != null ? vasExpertPaymentType.getDescription() : paymentType.getTitle();
                        }
                        item[4] = SormUtils.trimField(payTypeDescription.trim(), 256);
                        item[5] = SormUtils.trimField(PaymentsToUpload.getAdditionalPaymentData(payment), 512);
                        this.writeItemToFile(item, cid, VasexpertFileTitle.PAYMENTS.getTitle(), sormCSVWriter);
                    }
                    catch (Exception ex) {
                        this.logger.error("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0435 \u043f\u043b\u0430\u0442\u0435\u0436\u0430: " + payment.getId() + " \u041e\u0448\u0438\u0431\u043a\u0430: " + String.valueOf(ex));
                    }
                }
            }
            if (Utils.notEmptyCollection(payments)) {
                this.paymentsToUpload.updatePaymentsLogTable(payments.get(payments.size() - 1).getId());
            }
        }
        catch (Exception e) {
            String text = "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0435 \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439 \u0430\u0431\u043e\u043d\u0435\u043d\u0442\u043e\u0432: ";
            this.logger.error(text + e.getMessage());
            SormUtils.sendErrorToEmail(Setup.getSetup(), e, text);
        }
        return file;
    }

    @Override
    public Path operatorInfo() {
        return null;
    }

    protected String[] getAbonentItem(SormContract contract, String login, int serviceId, ConnectionStandard connectionStandard) throws Exception {
        String zone;
        String region;
        int cid = contract.getContractId();
        boolean isFiz = contract.isFiz();
        Object identificator = String.valueOf(cid);
        if (this.useContractIdWithServiceId && connectionStandard.equals((Object)ConnectionStandard.STATIONARY) || connectionStandard.equals((Object)ConnectionStandard.UNDEFINED_STANDARD)) {
            identificator = cid + "_" + serviceId;
        }
        String[] item = new String[95];
        item[0] = connectionStandard == null ? "0" : String.valueOf(connectionStandard.ordinal());
        item[1] = identificator;
        item[2] = Utils.notBlankString((String)login) && !connectionStandard.equals((Object)ConnectionStandard.TFoP_NET) ? login : "";
        item[3] = SormUtils.trimField(contract.getContractTitle(), 128);
        item[4] = this.helper.contractIsActive() ? "0" : "1";
        item[5] = contract.getDateFrom() != null ? TimeUtils.formatDate((java.util.Date)contract.getDateFrom()) : "";
        item[6] = contract.getDateTo() != null ? TimeUtils.formatDate((java.util.Date)contract.getDateTo()) : "";
        String string = item[7] = isFiz ? "0" : "1";
        if (isFiz) {
            String lastName = this.helper.getLastName();
            String firstName = this.helper.getFirstName();
            String middleName = this.helper.getMiddleName();
            if (Utils.notBlankString((String)lastName) && Utils.notBlankString((String)firstName)) {
                item[8] = "0";
                item[9] = SormUtils.trimField(firstName, 64);
                item[10] = SormUtils.trimField(middleName, 64);
                item[11] = SormUtils.trimField(lastName, 64);
                item[12] = "";
            } else {
                item[8] = "1";
                item[9] = "";
                item[10] = "";
                item[11] = "";
                item[12] = Utils.maskBlank((String)this.helper.getStringParam("sorm.upload.fiz.unstructfio"), (String)(middleName + " " + firstName + " " + lastName)).trim();
            }
            item[13] = this.helper.getBirthday("dd.MM.yyyy");
            String series = this.helper.getDocumentSerial();
            String number = this.helper.getDocumentNumber();
            String whenGive = this.helper.getDocumentWhenGive("dd.MM.yyyy");
            String whoGive = this.helper.getDocumentWhoGive();
            if (Utils.notBlankString((String)series) && Utils.notBlankString((String)number) && Utils.notBlankString((String)whenGive) && Utils.notBlankString((String)whoGive)) {
                item[14] = "0";
                item[15] = SormUtils.trimField(series, 32);
                item[16] = SormUtils.trimField(number, 64);
                item[17] = whenGive;
                item[18] = SormUtils.trimField(whoGive, 128);
                item[19] = "";
            } else {
                item[14] = "1";
                item[15] = "";
                item[16] = "";
                item[17] = "";
                item[18] = "";
                Object unstruct = this.helper.getStringParam("sorm.upload.fiz.documentunstruct");
                if (Utils.isBlankString((String)unstruct)) {
                    unstruct = series + " " + number + " " + whenGive + " " + whoGive;
                }
                item[19] = Utils.maskBlank((String)unstruct, (String)"");
            }
            String documentType = this.contractDao.getContractParameterListAsString(cid, this.config.getInt("sorm.upload.documenttype", -1)).orElse("");
            try (ContractDao contractDao = new ContractDao(this.con, 0);){
                documentType = contractDao.getContractParameterListAsString(cid, this.config.getInt("sorm.upload.documenttype", -1)).orElse("");
            }
            catch (BGException e) {
                this.logger.info("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u043e\u043f\u044b\u0442\u043a\u0435 \u0432\u0437\u044f\u0442\u044c \u0442\u0438\u043f \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430. " + e.getMessage());
            }
            item[20] = documentType;
            item[21] = "";
            item[22] = "";
            item[23] = "";
            item[24] = "";
            item[25] = "";
            item[26] = "";
            item[27] = "";
            item[28] = "";
        } else {
            item[8] = "";
            item[9] = "";
            item[10] = "";
            item[11] = "";
            item[12] = "";
            item[13] = "";
            item[14] = "";
            item[15] = "";
            item[16] = "";
            item[17] = "";
            item[18] = "";
            item[19] = "";
            item[20] = "";
            item[21] = this.helper.getBankTitle();
            item[22] = this.helper.getBankAccount();
            item[23] = this.helper.getFullTitleOrg();
            item[24] = this.helper.getINN();
            item[25] = this.helper.getStringParam("sorm.upload.org.contactface");
            item[26] = this.helper.getContactFacePhone();
            item[27] = this.helper.getBankTitle();
            item[28] = this.helper.getBankAccount();
        }
        AddressStruct address = this.helper.getAddress();
        if (address != null) {
            region = SormUtils.getParameterOfCity((Upload)this, address, "region");
            zone = SormUtils.getParameterOfCity((Upload)this, address, "zone");
            item[29] = "0";
            item[30] = Utils.maskBlank((String)address.getIndex(), (String)"");
            item[31] = address.getCountry();
            item[32] = "";
            item[33] = Utils.maskBlank((String)region, (String)"");
            item[34] = "";
            item[35] = SormUtils.trimField(Utils.maskBlank((String)zone, (String)""), 128);
            item[36] = "";
            item[37] = SormUtils.trimField(Utils.maskBlank((String)address.getCity(), (String)""), 128);
            item[38] = "";
            item[39] = SormUtils.trimField(Utils.maskBlank((String)address.getStreet(), (String)""), 128);
            item[40] = SormUtils.trimField(Utils.maskBlank((String)address.getHouse(), (String)""), 32);
            item[41] = SormUtils.trimField(Utils.maskBlank((String)address.getFrac(), (String)""), 32);
            item[42] = "";
            item[43] = SormUtils.trimField(Utils.maskBlank((String)address.getFlat(), (String)""), 32);
            item[44] = "";
        } else {
            item[29] = "1";
            item[30] = "";
            item[31] = "";
            item[32] = "";
            item[33] = "";
            item[34] = "";
            item[35] = "";
            item[36] = "";
            item[37] = "";
            item[38] = "";
            item[39] = "";
            item[40] = "";
            item[41] = "";
            item[42] = "";
            item[43] = "";
            item[44] = this.helper.getUnstructAddress();
        }
        address = this.helper.getCommutatorsAddress();
        if (SormUtils.checkValidAddress(address)) {
            region = SormUtils.getParameterOfCity((Upload)this, address, "region");
            zone = SormUtils.getParameterOfCity((Upload)this, address, "zone");
            item[45] = "0";
            item[46] = Utils.maskBlank((String)address.getIndex(), (String)"");
            item[47] = Utils.maskBlank((String)address.getCountry(), (String)"");
            item[48] = "";
            item[49] = Utils.maskBlank((String)region, (String)"");
            item[50] = "";
            item[51] = Utils.maskBlank((String)zone, (String)"");
            item[52] = "";
            item[53] = Utils.maskBlank((String)address.getCity(), (String)"");
            item[54] = "";
            item[55] = Utils.maskBlank((String)address.getStreet(), (String)"");
            item[56] = Utils.maskBlank((String)address.getHouse(), (String)"");
            item[57] = Utils.maskBlank((String)address.getFrac(), (String)"");
            item[58] = "";
            item[59] = Utils.maskBlank((String)address.getFlat(), (String)"");
            item[60] = "";
        } else {
            item[45] = "1";
            item[46] = "";
            item[47] = "";
            item[48] = "";
            item[49] = "";
            item[50] = "";
            item[51] = "";
            item[52] = "";
            item[53] = "";
            item[54] = "";
            item[55] = "";
            item[56] = "";
            item[57] = "";
            item[58] = "";
            item[59] = "";
            item[60] = this.helper.getUnstructCommutatorsAddress();
        }
        address = this.helper.getAddressBills();
        if (address != null) {
            region = SormUtils.getParameterOfCity((Upload)this, address, "region");
            zone = SormUtils.getParameterOfCity((Upload)this, address, "zone");
            item[61] = "0";
            item[62] = Utils.maskBlank((String)address.getIndex(), (String)"");
            item[63] = Utils.maskBlank((String)address.getCountry(), (String)"");
            item[64] = "";
            item[65] = Utils.maskBlank((String)region, (String)"");
            item[66] = "";
            item[67] = Utils.maskBlank((String)zone, (String)"");
            item[68] = "";
            item[69] = Utils.maskBlank((String)address.getCity(), (String)"");
            item[70] = "";
            item[71] = Utils.maskBlank((String)address.getStreet(), (String)"");
            item[72] = Utils.maskBlank((String)address.getHouse(), (String)"");
            item[73] = Utils.maskBlank((String)address.getFrac(), (String)"");
            item[74] = "";
            item[75] = Utils.maskBlank((String)address.getFlat(), (String)"");
            item[76] = "";
        } else {
            item[61] = "1";
            item[62] = "";
            item[63] = "";
            item[64] = "";
            item[65] = "";
            item[66] = "";
            item[67] = "";
            item[68] = "";
            item[69] = "";
            item[70] = "";
            item[71] = "";
            item[72] = "";
            item[73] = "";
            item[74] = "";
            item[75] = "";
            item[76] = this.helper.getUnstructAddressBills();
        }
        address = this.helper.getAddressBills();
        if (SormUtils.checkValidAddress(address)) {
            region = SormUtils.getParameterOfCity((Upload)this, address, "region");
            zone = SormUtils.getParameterOfCity((Upload)this, address, "zone");
            item[77] = "0";
            item[78] = Utils.maskBlank((String)address.getIndex(), (String)"");
            item[79] = Utils.maskBlank((String)address.getCountry(), (String)"");
            item[80] = "";
            item[81] = Utils.maskBlank((String)region, (String)"");
            item[82] = "";
            item[83] = Utils.maskBlank((String)zone, (String)"");
            item[84] = "";
            item[85] = Utils.maskBlank((String)address.getCity(), (String)"");
            item[86] = "";
            item[87] = Utils.maskBlank((String)address.getStreet(), (String)"");
            item[88] = Utils.maskBlank((String)address.getHouse(), (String)"");
            item[89] = Utils.maskBlank((String)address.getFrac(), (String)"");
            item[90] = "";
            item[91] = Utils.maskBlank((String)address.getFlat(), (String)"");
            item[92] = "";
        } else {
            item[77] = "1";
            item[78] = "";
            item[79] = "";
            item[80] = "";
            item[81] = "";
            item[82] = "";
            item[83] = "";
            item[84] = "";
            item[85] = "";
            item[86] = "";
            item[87] = "";
            item[88] = "";
            item[89] = "";
            item[90] = "";
            item[91] = "";
            item[92] = this.helper.getUnstructAddressBills();
        }
        item[93] = contract.getDateFrom() != null ? TimeUtils.format((java.util.Date)TimeUtils.clear_HOUR_MIN_MIL_SEC((java.util.Date)contract.getDateFrom()), (String)"dd.MM.yyyy'T'HH:mm:ss") : "";
        item[94] = "";
        return item;
    }

    protected void writeToEndUsersFile(String internalUserId, String parentUserId) {
        String[] item = new String[]{Utils.maskBlank((String)internalUserId, (String)""), "", Utils.maskBlank((String)parentUserId, (String)""), ""};
        this.endUsersFileWriter.writeNext(item);
    }

    @Override
    public List<Pair<String, Path>> getOtherFiles() {
        ArrayList<Pair<String, Path>> additionalFiles = new ArrayList<Pair<String, Path>>();
        if (this.endUsersFile != null) {
            if (this.endUsersFileWriter != null) {
                try {
                    this.endUsersFileWriter.close();
                }
                catch (IOException e) {
                    this.logger.error((Object)e);
                }
            }
            additionalFiles.add((Pair<String, Path>)new Pair((Object)VasexpertFileTitle.END_USERS.getFTPDirectory(), (Object)this.endUsersFile));
        }
        if (this.emailsFile != null) {
            if (this.emailsFileWriter != null) {
                try {
                    this.emailsFileWriter.close();
                }
                catch (IOException e) {
                    this.logger.error((Object)e);
                }
            }
            additionalFiles.add((Pair<String, Path>)new Pair((Object)VasexpertFileTitle.EMAILS.getFTPDirectory(), (Object)this.emailsFile));
        }
        return additionalFiles;
    }

    @Override
    public void closeResources() {
        try {
            if (this.phoneNumberingWriter != null) {
                this.phoneNumberingWriter.close();
            }
        }
        catch (IOException ex) {
            this.logger.error((Object)ex);
        }
        super.closeResources();
    }
}

