/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.tv.server.runtime;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.directory.api.common.ReferenceValueDirectory;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.tv.common.bean.TvChannelSpec;
import ru.bitel.bgbilling.modules.tv.server.TvUtils;
import ru.bitel.bgbilling.modules.tv.server.bean.TvChannelSpecDao;
import ru.bitel.bgbilling.modules.tv.server.runtime.ServiceSpecRuntime;
import ru.bitel.common.sql.ConnectionSet;
import ru.bitel.oss.systems.inventory.product.common.event.ServiceLinkModifiedEvent;
import ru.bitel.oss.systems.inventory.service.common.bean.ServiceSpec;

public class ServiceSpecRuntimeMap
extends ReferenceValueDirectory<ServiceSpec, ServiceSpecRuntime>
implements EventListener<Event> {
    private static final Logger logger = LogManager.getLogger();
    private static ServiceSpecRuntimeMap instance;
    private volatile Map<Integer, ServiceSpecRuntime.TvChannelSpecRuntimeList> linkMap;

    private ServiceSpecRuntimeMap(boolean realtime, Connection con) throws Exception {
        super(realtime, con, 0, ServiceSpec.class);
        this.init(con, 0, ServiceSpec.class);
        if (realtime) {
            new Thread(() -> {
                try {
                    EventProcessor.getInstance().addListener((EventListener)this, ServiceLinkModifiedEvent.class);
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }, "ServiceSpecRuntimeMap-init").start();
        }
    }

    public static ServiceSpecRuntimeMap getInstance(ConnectionSet connectionSet) throws Exception {
        if (instance == null) {
            instance = new ServiceSpecRuntimeMap(true, connectionSet.getConnection());
        }
        return instance;
    }

    static ServiceSpecRuntimeMap getInstance(Connection con) throws Exception {
        if (instance == null) {
            instance = new ServiceSpecRuntimeMap(true, con);
        }
        return instance;
    }

    protected ServiceSpecRuntime newValue(ServiceSpec value) {
        ServiceSpecRuntime.TvChannelSpecRuntimeList list = this.linkMap.get(value.getId());
        return new ServiceSpecRuntime(value, list);
    }

    protected void onUpdate(Connection con, int moduleId, List<ServiceSpec> list) throws BGException {
        HashMap<Integer, ServiceSpecRuntime.TvChannelSpecRuntimeList> linkMap = new HashMap<Integer, ServiceSpecRuntime.TvChannelSpecRuntimeList>();
        HashMap<Integer, TvChannelSpecDao> channelLinkDaoMap = new HashMap<Integer, TvChannelSpecDao>();
        GregorianCalendar utilCalendar = new GregorianCalendar();
        for (ServiceSpec serviceSpec : list) {
            TvChannelSpecDao tvChannelSpecDao = (TvChannelSpecDao)((Object)channelLinkDaoMap.get(serviceSpec.getModuleId()));
            if (tvChannelSpecDao == null) {
                tvChannelSpecDao = new TvChannelSpecDao(con, serviceSpec.getModuleId());
                channelLinkDaoMap.put(serviceSpec.getModuleId(), tvChannelSpecDao);
            }
            List<TvChannelSpec> tvChannelSpecList = tvChannelSpecDao.list(serviceSpec.getId(), null, null, null, null);
            ArrayList<ServiceSpecRuntime.TvChannelSpecRuntime> linkList = new ArrayList<ServiceSpecRuntime.TvChannelSpecRuntime>();
            if (tvChannelSpecList != null) {
                for (TvChannelSpec tvChannelSpec : tvChannelSpecList) {
                    ServiceSpecRuntime.TvChannelSpecRuntime link = new ServiceSpecRuntime.TvChannelSpecRuntime(tvChannelSpec, tvChannelSpec.getId(), TvUtils.dateFrom(tvChannelSpec.getDateFrom(), utilCalendar), TvUtils.dateTo(tvChannelSpec.getDateTo(), utilCalendar));
                    linkList.add(link);
                }
            }
            ServiceSpecRuntime.TvChannelSpecRuntimeList runtimeList = new ServiceSpecRuntime.TvChannelSpecRuntimeList(linkList);
            linkMap.put(serviceSpec.getId(), runtimeList);
        }
        this.linkMap = linkMap;
    }

    public void notify(Event e, EventListenerContext ctx) throws Exception {
        this.init(ctx.getConnection(), 0, ServiceSpec.class);
    }
}

