/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.documents.client.directory;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.plugins.documents.client.directory.DirectoryTableModel;
import ru.bitel.bgbilling.plugins.documents.common.bean.DocumentJournal;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.model.Id;

public class JournalEditor
extends BGUPanel {
    private BGUTable journalTable;
    private JournalTableModel journalTableModel = new JournalTableModel();

    protected void jbInit() throws Exception {
        this.journalTable = new BGUTable((TableModel)((Object)this.journalTableModel));
        this.journalTable.setSelectionMode(0);
        this.journalTable.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127) {
                    JournalEditor.this.performAction("delete");
                }
            }
        });
        this.setLayout(new GridBagLayout());
        this.add(new JScrollPane((Component)this.journalTable), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> this.journalTableModel.setData(((ClientContext)this.getContext()).getDirectory(DocumentJournal.class, -1).list()));
        new AbstractBGUPanel.BGActionNew((AbstractBGUPanel)this, e -> {
            List list = this.journalTableModel.getRows();
            if (list.size() == 0 || ((DocumentJournal)list.get(list.size() - 1)).getId() > 0) {
                this.journalTableModel.addRow(new DocumentJournal());
                this.journalTable.repaint();
                this.journalTable.updateUI();
            }
        });
        new AbstractBGUPanel.BGActionDelete((AbstractBGUPanel)this, e -> {
            DocumentJournal selectedRow = (DocumentJournal)this.journalTableModel.getSelectedRow();
            if (selectedRow.getId() > 0) {
                if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u0443\u044e \u0441\u0442\u0440\u043e\u043a\u0443?", "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u0441\u0442\u0440\u043e\u043a\u0438", 0) == 0) {
                    ((ClientContext)this.getContext()).getDirectory(DocumentJournal.class, -1).delete(selectedRow.getId());
                }
            } else if (selectedRow.getId() == 0) {
                this.journalTableModel.deleteSelectedRows();
            } else {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443 \u0432 \u0442\u0430\u0431\u043b\u0438\u0446\u0435!");
                return;
            }
            this.performAction("refresh");
        });
    }

    class JournalTableModel
    extends DirectoryTableModel<DocumentJournal> {
        public JournalTableModel() {
            super(JournalEditor.class.getName());
        }

        public void setValueAt(Object value, int rowIndex, int columnIndex) {
            DocumentJournal val = (DocumentJournal)this.getSelectedRow();
            String oldValue = val.getTitle();
            String newValue = (String)value;
            if (Utils.notBlankString((String)newValue)) {
                if (oldValue != null && oldValue.equals(newValue)) {
                    return;
                }
                val.setTitle(newValue);
                try {
                    ((ClientContext)JournalEditor.this.getContext()).getDirectory(DocumentJournal.class, -1).update((Id)val);
                }
                catch (Exception ex) {
                    ClientUtils.showErrorMessageDialog((Throwable)ex);
                }
            }
            JournalEditor.this.performAction("refresh");
        }
    }
}

