/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.inet.accounting.ip;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ru.bitel.bgbilling.apps.inet.accounting.InetConnectionRuntime;
import ru.bitel.bgbilling.apps.inet.accounting.IpRangeRuntime;
import ru.bitel.common.inet.IpAddress;
import ru.bitel.common.inet.IpAddressRangeSet;
import ru.bitel.common.util.Matcher;
import ru.bitel.common.util.RangeSet2;
import ru.bitel.common.util.Ranger;

public class ConnectionRangeSet
extends IpAddressRangeSet<IpRangeRuntime> {
    private static final Ranger<IpRangeRuntime, byte[]> addressRanger = new Ranger<IpRangeRuntime, byte[]>(){

        public byte[] getMinValue(IpRangeRuntime r) {
            return r.getAddressFrom();
        }

        public byte[] getMaxValue(IpRangeRuntime r) {
            return r.getAddressTo();
        }
    };

    protected ConnectionRangeSet() {
        super(IpRangeRuntime.class, addressRanger, false, 1);
    }

    public InetConnectionRuntime get(IpAddress address) {
        byte[] segmentKey = this.segmenter.segmentKey(address.address);
        IpAddress segment = new IpAddress(segmentKey);
        IpRangeRuntime result = (IpRangeRuntime)((Object)super.get((Object)segment, (Object)address.address));
        return result != null ? result.connectionRuntime : null;
    }

    public InetConnectionRuntime get(IpAddress address, long millis, long lockTimeout) {
        byte[] segmentKey = this.segmenter.segmentKey(address.address);
        AddressMatcher matcher = new AddressMatcher(segmentKey, millis, lockTimeout);
        IpRangeRuntime result = (IpRangeRuntime)((Object)super.get((Object)matcher, (Object)address.address, (Matcher)matcher));
        return result != null ? result.connectionRuntime : null;
    }

    public InetConnectionRuntime getWithTimeout(IpAddress address, long millis) {
        InetConnectionRuntime connectionRuntime;
        byte[] segmentKey = this.segmenter.segmentKey(address.address);
        List list = super.listContains((Object)new IpAddress(segmentKey), (Object)address.address);
        for (IpRangeRuntime r : list) {
            connectionRuntime = r.connectionRuntime;
            Date sessionStart = connectionRuntime.sessionStart;
            Date sessionStop = connectionRuntime.sessionStop;
            if (sessionStart.getTime() > millis || sessionStop != null && sessionStop.getTime() < millis) continue;
            connectionRuntime.inetServRuntime.lock();
            return connectionRuntime;
        }
        for (IpRangeRuntime r : list) {
            int initiationType;
            connectionRuntime = r.connectionRuntime;
            long connectionFinishTimeoutMillis = connectionRuntime.getConnectionFinishTimeoutMillis();
            if (connectionFinishTimeoutMillis == 0L || (initiationType = connectionRuntime.inetServRuntime.inetServTypeRef.get().inetServType.getSessionInitiationType()) != 0) continue;
            Date sessionStart = connectionRuntime.sessionStart;
            Date sessionStop = connectionRuntime.sessionStop;
            if (sessionStart.getTime() > millis || sessionStop != null && sessionStop.getTime() + connectionFinishTimeoutMillis < millis) continue;
            connectionRuntime.inetServRuntime.lock();
            return connectionRuntime;
        }
        return null;
    }

    public void removeAll(List<InetConnectionRuntime> ranges) {
        HashSet<IpRangeRuntime> notSegmented = new HashSet<IpRangeRuntime>();
        HashMap<IpAddress, HashSet<IpRangeRuntime>> segments = new HashMap<IpAddress, HashSet<IpRangeRuntime>>();
        for (InetConnectionRuntime inetConnectionRuntime : ranges) {
            if (inetConnectionRuntime.rangeSets == null) continue;
            for (IpRangeRuntime range : inetConnectionRuntime.rangeSets) {
                IpAddress key = this.segmenter.segmentKey((Object)range);
                if (key != null) {
                    HashSet<IpRangeRuntime> rangeSet = (HashSet<IpRangeRuntime>)segments.get(key);
                    if (rangeSet == null) {
                        rangeSet = new HashSet<IpRangeRuntime>();
                        segments.put(key, rangeSet);
                    }
                    rangeSet.add(range);
                    continue;
                }
                notSegmented.add(range);
            }
        }
        this.notSegmented.removeAll(notSegmented);
        for (Map.Entry entry : segments.entrySet()) {
            IpAddress key = (IpAddress)entry.getKey();
            RangeSet2 rangeSet = (RangeSet2)this.segments.get(key);
            if (rangeSet == null) continue;
            rangeSet.removeAll((Set)entry.getValue());
        }
    }

    public void addAllConnections(List<InetConnectionRuntime> ranges) {
        HashSet<IpRangeRuntime> notSegmented = new HashSet<IpRangeRuntime>();
        HashMap<IpAddress, HashSet<IpRangeRuntime>> segments = new HashMap<IpAddress, HashSet<IpRangeRuntime>>();
        for (InetConnectionRuntime inetConnectionRuntime : ranges) {
            if (inetConnectionRuntime.rangeSets == null) continue;
            for (IpRangeRuntime range : inetConnectionRuntime.rangeSets) {
                IpAddress key = this.segmenter.segmentKey((Object)range);
                if (key != null) {
                    HashSet<IpRangeRuntime> rangeSet = (HashSet<IpRangeRuntime>)segments.get(key);
                    if (rangeSet == null) {
                        rangeSet = new HashSet<IpRangeRuntime>();
                        segments.put(key, rangeSet);
                    }
                    rangeSet.add(range);
                    continue;
                }
                notSegmented.add(range);
            }
        }
        this.notSegmented.addAll(notSegmented);
        for (Map.Entry entry : segments.entrySet()) {
            RangeSet2 newRangeSet;
            IpAddress key = (IpAddress)entry.getKey();
            RangeSet2 rangeSet = (RangeSet2)this.segments.get(key);
            if (rangeSet == null && (rangeSet = this.segments.putIfAbsent(key, newRangeSet = new RangeSet2(this.ranger, this.comparator, this.clazz, byte[].class))) == null) {
                rangeSet = newRangeSet;
            }
            rangeSet.addAll((Set)entry.getValue());
        }
    }

    public static final ConnectionRangeSet newInstanceFromRanges(List<IpRangeRuntime> ranges) {
        ConnectionRangeSet result = new ConnectionRangeSet();
        result.addAll(ranges);
        return result;
    }

    public static final ConnectionRangeSet newInstance(List<InetConnectionRuntime> sessions) {
        ConnectionRangeSet result = new ConnectionRangeSet();
        result.addAllConnections(sessions);
        return result;
    }

    static final class AddressMatcher
    extends IpAddress
    implements Matcher<IpRangeRuntime> {
        private final long millis;
        private final long lockTimeout;

        AddressMatcher(byte[] segmentKey, long millis, long lockTimeout) {
            super(segmentKey);
            this.millis = millis;
            this.lockTimeout = lockTimeout;
        }

        public boolean matched(IpRangeRuntime x) {
            InetConnectionRuntime connectionRuntime = x.connectionRuntime;
            return connectionRuntime.lockIfSessionActive(this.millis, this.lockTimeout);
        }
    }
}

