/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.systems.inventory.subscription.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.dao.AbstractDirectoryIdDao;
import ru.bitel.oss.systems.inventory.subscription.common.bean.SubscriptionType;

public class SubscriptionTypeDao
extends AbstractDirectoryIdDao<SubscriptionType> {
    public SubscriptionTypeDao(Connection con, int moduleId) {
        super(con, moduleId, "tariff_option");
    }

    public List<SubscriptionType> list(Date date) throws BGException {
        java.sql.Date sqlDate = TimeUtils.convertDateToSqlDate((Date)date);
        return this.list("(date1 IS NULL OR date1<=?) AND (date2 IS NULL OR ?<=date2)", "title", new Object[]{sqlDate, sqlDate});
    }

    protected SubscriptionType getFromRS(ResultSet rs) throws SQLException {
        SubscriptionType result = new SubscriptionType();
        result.setId(rs.getInt("id"));
        result.setTitle(rs.getString("title"));
        result.setTariffIdSet(Utils.toIntegerSet((String)rs.getString("tariffIds")));
        result.setContractGroups(rs.getLong("contractGroups"));
        result.setComment(rs.getString("comment"));
        result.setDescription(rs.getString("description"));
        result.setDateFrom((Date)rs.getDate("dateFrom"));
        result.setDateTo((Date)rs.getDate("dateTo"));
        result.setDepends(Utils.toIntegerSet((String)rs.getString("depends")));
        result.setIncompatible(Utils.toIntegerSet((String)rs.getString("incompatible")));
        result.setHideForCustomer(rs.getBoolean("hideForCustomer"));
        result.setHideActivationForCustomer(rs.getBoolean("hideActivationForCustomer"));
        return result;
    }

    protected void updateImpl(SubscriptionType option) throws BGException, SQLException {
        PreparedStatement ps;
        if (option.getId() <= 0) {
            ps = this.con.prepareStatement("INSERT INTO " + this.tableName + " (title, tariffIds, contractGroups, comment, description, dateFrom, dateTo, depends, incompatible, hideForCustomer, hideActivationForCustomer) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", 1);
        } else {
            ps = this.con.prepareStatement("UPDATE " + this.tableName + " SET title=?, tariffIds=?, contractGroups=?, comment=?, description=?, dateFrom=?, dateTo=?, depends=?, incompatible=?, hideForCustomer=?, hideActivationForCustomer=? WHERE id=?");
            ps.setInt(12, option.getId());
        }
        ps.setString(1, option.getTitle());
        ps.setString(2, Utils.toString((Iterable)option.getTariffIdSet()));
        ps.setLong(3, option.getContractGroups());
        ps.setString(4, option.getComment());
        ps.setString(5, option.getDescription());
        ps.setDate(6, TimeUtils.convertDateToSqlDate((Date)option.getDateFrom()));
        ps.setDate(7, TimeUtils.convertDateToSqlDate((Date)option.getDateTo()));
        ps.setString(8, Utils.toString((Iterable)option.getDepends()));
        ps.setString(9, Utils.toString((Iterable)option.getIncompatible()));
        ps.setBoolean(10, option.isHideForCustomer());
        ps.setBoolean(11, option.isHideActivationForCustomer());
        ps.executeUpdate();
        if (option.getId() <= 0) {
            option.setId(ServerUtils.lastInsertId(ps));
        }
        ps.close();
    }

    public SubscriptionType get(String title) throws BGException {
        throw new UnsupportedOperationException();
    }

    public List<SubscriptionType> list() throws BGException {
        return this.list(null, "title", new Object[0]);
    }
}

