/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.psb.server.servlet;

import bitel.billing.server.contract.bean.PaymentManager;
import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.base.server.CommonExecutor;
import ru.bitel.bgbilling.kernel.contract.autopayment.common.bean.Autopayment;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Payment;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.PaymentDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.ContractBalanceChangedEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.PaymentEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.psb.common.bean.Transaction;
import ru.bitel.bgbilling.modules.psb.server.bean.AutopaymentManager;
import ru.bitel.bgbilling.modules.psb.server.bean.TransactionManager;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

@WebServlet(name="PSBExecutor", urlPatterns={"/psb/*"})
public class ModuleExecutor
extends CommonExecutor {
    private static final String[] SET_1 = new String[]{"AMOUNT", "CURRENCY", "ORDER", "MERCH_NAME", "MERCHANT", "TERMINAL", "EMAIL", "TRTYPE", "TIMESTAMP", "NONCE", "BACKREF", "RESULT", "RC", "RCTEXT", "AUTHCODE", "RRN", "INT_REF"};
    private static final String[] SET_22 = new String[]{"ORDER", "AMOUNT", "CURRENCY", "ORG_AMOUNT", "RRN", "INT_REF", "TRTYPE", "TERMINAL", "BACKREF", "EMAIL", "TIMESTAMP", "NONCE", "RESULT", "RC", "RCTEXT"};
    private static final String[] SET_0 = new String[]{"AMOUNT", "CURRENCY", "ORDER", "MERCH_NAME", "MERCHANT", "TERMINAL", "EMAIL", "TRTYPE", "TIMESTAMP", "NONCE", "BACKREF", "RESULT", "RC", "RCTEXT", "AUTHCODE", "RRN", "INT_REF"};
    private static final String[] SET_21 = new String[]{"ORDER", "AMOUNT", "CURRENCY", "ORG_AMOUNT", "RRN", "INT_REF", "TRTYPE", "TERMINAL", "BACKREF", "EMAIL", "TIMESTAMP", "NONCE", "RESULT", "RC", "RCTEXT"};
    private static final String[] SET_171 = new String[]{"AMOUNT", "CURRENCY", "ORDER", "MERCH_NAME", "MERCHANT", "TERMINAL", "EMAIL", "TRTYPE", "TIMESTAMP", "NONCE", "BACKREF", "RESULT", "RC", "RCTEXT", "AUTHCODE", "RRN", "INT_REF"};

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doPost(req, resp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Connection con = null;
        try {
            String CARD;
            String CHANNEL;
            String AUTHCODE;
            String RCTEXT;
            Date TIMESTAMP;
            Transaction transaction;
            TransactionManager transactionManager;
            StringBuilder buf;
            int moduleId;
            block39: {
                int TRTYPE;
                block40: {
                    int RESULT;
                    block38: {
                        moduleId = ModuleExecutor.getModuleId((HttpServletRequest)request);
                        buf = new StringBuilder();
                        for (Map.Entry entry : request.getParameterMap().entrySet()) {
                            buf.append((String)entry.getKey()).append(" = ");
                            String[] values = (String[])entry.getValue();
                            if (values != null) {
                                StringBuilder val = new StringBuilder();
                                for (String value : values) {
                                    if (val.length() > 0) {
                                        val.append("; ");
                                    }
                                    val.append(value);
                                }
                                buf.append((CharSequence)val);
                            }
                            buf.append("\n");
                        }
                        if (this.getLogger().isDebugEnabled()) {
                            this.getLogger().debug(buf.toString());
                        }
                        con = Setup.getSetup().getDBConnectionFromPool();
                        ModuleSetup moduleSetup = Setup.getSetup().getModuleSetup(Integer.valueOf(moduleId));
                        int paymentId = moduleSetup.getInt("psb.payment.type.id", 0);
                        if (paymentId < 1) {
                            String message = "No set param \"psb.payment.type.id\" in config";
                            this.getLogger().error(message);
                            response.sendError(500, message);
                            ServerUtils.closeConnection((Connection)con);
                            return;
                        }
                        String secret = moduleSetup.get("psb.secret");
                        if (Utils.isBlankString((String)secret)) {
                            String message = "No set param \"psb.secret\" in config";
                            this.getLogger().error(message);
                            response.sendError(500, message);
                            ServerUtils.closeConnection((Connection)con);
                            return;
                        }
                        String pSign = request.getParameter("P_SIGN");
                        TRTYPE = Utils.parseInt((String)request.getParameter("TRTYPE"), (int)-1);
                        if (!(TRTYPE == 0 && this.check(this.doDataMap(request, SET_0), (ParameterMap)moduleSetup, SET_0, pSign) || TRTYPE == 1 && this.check(this.doDataMap(request, SET_1), (ParameterMap)moduleSetup, SET_1, pSign) || TRTYPE == 21 && this.check(this.doDataMap(request, SET_21), (ParameterMap)moduleSetup, SET_21, pSign) || TRTYPE == 22 && this.check(this.doDataMap(request, SET_22), (ParameterMap)moduleSetup, SET_22, pSign) || TRTYPE == 171 && this.check(this.doDataMap(request, SET_171), (ParameterMap)moduleSetup, SET_171, pSign))) {
                            String message = "Error check sign";
                            this.getLogger().error(message);
                            response.sendError(500, message);
                            ServerUtils.closeConnection((Connection)con);
                            return;
                        }
                        String TERMINAL = moduleSetup.get("psb.terminal");
                        if (Utils.isBlankString((String)TERMINAL)) {
                            String message = "No set param \"psb.terminal\" in config";
                            this.getLogger().error(message);
                            response.sendError(500, message);
                            ServerUtils.closeConnection((Connection)con);
                            return;
                        }
                        if (!TERMINAL.equals(request.getParameter("TERMINAL"))) {
                            String message = "Value param \"psb.terminal\" in config not equals param \"TERMINAL\" in query";
                            this.getLogger().error(message);
                            response.sendError(500, message);
                            ServerUtils.closeConnection((Connection)con);
                            return;
                        }
                        transactionManager = new TransactionManager(con, moduleId);
                        String ORDER = request.getParameter("ORDER");
                        transaction = (Transaction)transactionManager.get(Utils.parseInt((String)ORDER));
                        if (transaction == null) {
                            String message = "Not found transaction for ID = " + ORDER;
                            this.getLogger().error(message);
                            response.sendError(500, message);
                            ServerUtils.closeConnection((Connection)con);
                            return;
                        }
                        RESULT = Utils.parseInt((String)request.getParameter("RESULT"), (int)-1);
                        TIMESTAMP = TimeUtils.parseDate((String)request.getParameter("TIMESTAMP"), (String)"yyyyMMddHHmmss", (TimeZone)TimeZone.getTimeZone("UTC"));
                        RCTEXT = request.getParameter("RCTEXT");
                        AUTHCODE = request.getParameter("AUTHCODE");
                        CHANNEL = request.getParameter("CHANNEL");
                        CARD = request.getParameter("CARD");
                        BigDecimal AMOUNT = new BigDecimal(request.getParameter("AMOUNT"));
                        if (TRTYPE != 1 && TRTYPE != 171) break block38;
                        if ((RESULT == 0 || RESULT == 1) && transaction.getPaymentId() < 0) {
                            Preferences modeDataMap;
                            int chainId;
                            Payment payment = new Payment().setDate(TIMESTAMP).setTypeId(paymentId).setContractId(transaction.getContractId()).setSum(AMOUNT).setUserId(0).setModuleId(Integer.valueOf(moduleId)).setTransactionId(String.valueOf(transaction.getId())).setComment(moduleSetup.get("psb.payment.comment", "\u041e\u043f\u043b\u0430\u0442\u0430 \u0447\u0435\u0440\u0435\u0437 \u043f\u043b\u0430\u0442\u0435\u0436\u043d\u044b\u0439 \u0441\u0435\u0440\u0432\u0438\u0441 \u041f\u0440\u043e\u043c\u0421\u0432\u044f\u0437\u044c\u0411\u0430\u043d\u043a\u0430 [\u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u044f #{TRANSACTION_ID}, \u043a\u0430\u0440\u0442\u0430 {CARD}]").replace("{TRANSACTION_ID}", String.valueOf(transaction.getId())).replace("{CARD}", String.valueOf(CARD)));
                            new PaymentDao(con).update((Object)payment);
                            ServerUtils.commitConnection((Connection)con);
                            try (BalanceUtils balanceUtils = new BalanceUtils(con);){
                                balanceUtils.updateBalance(payment.getDate(), payment.getContractId());
                            }
                            ServerUtils.commitConnection((Connection)con);
                            transaction.setAutopayment(TRTYPE == 171);
                            transaction.setPaymentId(payment.getId());
                            AutopaymentManager autopaymentManager = new AutopaymentManager(con, moduleId);
                            Autopayment autopayment = autopaymentManager.getCurrentAutopayment(transaction.getContractId());
                            if (autopayment != null && (chainId = (modeDataMap = autopayment.getModeData() != null ? new Preferences(autopayment.getModeData(), "\n") : new Preferences()).getInt("psb.autopayment.recurent.chain.id", -1)) > 0 && chainId == transaction.getId()) {
                                modeDataMap.set("psb.autopayment.recurent.chain.prn", request.getParameter("RRN"));
                                modeDataMap.set("psb.autopayment.recurent.chain.int.ref", request.getParameter("INT_REF"));
                                autopayment.setModeData(modeDataMap.toString());
                                autopaymentManager.update(autopayment);
                            }
                            EventProcessor.getInstance().publish((Event)new PaymentEvent(0, payment));
                            EventProcessor.getInstance().publish((Event)new ContractBalanceChangedEvent(transaction.getContractId(), 3, payment.getSum()));
                        }
                        break block39;
                    }
                    if (TRTYPE != 22) break block40;
                    if ((RESULT == 0 || RESULT == 1) && transaction.getPaymentId() > 0) {
                        new PaymentManager(con).deletePayment(transaction.getPaymentId());
                        try (BalanceUtils balanceUtils = new BalanceUtils(con);){
                            balanceUtils.updateBalance(TIMESTAMP, transaction.getContractId());
                        }
                        transaction.setPaymentId(-1);
                        EventProcessor.getInstance().publish((Event)new ContractBalanceChangedEvent(transaction.getContractId(), 3, transaction.getSum().negate()));
                    }
                    break block39;
                }
                if (TRTYPE == 0 || TRTYPE == 21) {
                    // empty if block
                }
            }
            transaction.setStatus(RCTEXT);
            transaction.setTransactionDate(TIMESTAMP);
            transaction.setCard(CHANNEL + " " + CARD);
            transaction.setAuthorizationCode(AUTHCODE);
            transaction.setParameters(buf.toString());
            transactionManager = new TransactionManager(con, moduleId);
            transactionManager.update(transaction);
            ServerUtils.closeConnection((Connection)con);
        }
        catch (Exception ex) {
            this.logError(ex);
            response.sendError(500, ex.getMessage());
            return;
        }
        response.setStatus(200);
        return;
        finally {
            ServerUtils.closeConnection(con);
        }
    }

    private Map<String, Object> doDataMap(HttpServletRequest request, String[] checkParams) {
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        for (String paramName : checkParams) {
            dataMap.put(paramName, request.getParameter(paramName));
        }
        return dataMap;
    }

    private boolean check(Map<String, Object> dataMap, ParameterMap moduleSetup, String[] checkParams, String pSign) throws BGException {
        return TransactionManager.doSign(TransactionManager.buildSignData(dataMap, checkParams), moduleSetup).equals(pSign);
    }
}

