/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.model;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ru.bitel.common.RangeUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.util.Ranger;

public interface Tied {
    public int getId();

    public Set<Integer> getDepends();

    public Set<Integer> getIncompatible();

    public static class Utils<T, TT extends Tied> {
        private final TieResolver<T, TT> resolver;
        private final Ranger<T, Date> ranger;

        public Utils(TieResolver<T, TT> resolver, Ranger<T, Date> ranger) {
            this.resolver = resolver;
            this.ranger = ranger;
        }

        public void checkAdd(List<T> currentList, T add, int field) throws TieUnresolvedException {
            this.checkAdd(currentList, (Iterable<T>)Collections.singleton(add), field);
        }

        public void checkAdd(List<T> currentList, Iterable<T> add, int field) throws TieUnresolvedException {
            Set<Object> set;
            ArrayList<Integer> incompatible;
            Set<Integer> currentPackets;
            Date date2;
            Date date1;
            Tied tied;
            HashMap dependsUnresolved = new HashMap();
            HashMap incompatibleUnresolved = new HashMap();
            ArrayList<T> all = new ArrayList<T>(currentList);
            for (T tied2 : add) {
                all.add(tied2);
            }
            for (T tied0 : add) {
                tied = (Tied)this.resolver.resolve(tied0);
                if (tied != null && tied.getDepends().size() > 0 && !Utils.haveDepends(this.resolver, this.ranger, all, tied0, tied, field)) {
                    HashSet<TT> set2 = (HashSet<TT>)dependsUnresolved.get(tied);
                    if (set2 == null) {
                        set2 = new HashSet<TT>();
                        dependsUnresolved.put(tied, set2);
                    }
                    for (Integer id : tied.getDepends()) {
                        set2.add(this.resolver.resolve(id));
                    }
                }
                if (tied == null || tied.getIncompatible().size() <= 0) continue;
                date1 = this.ranger.getMinValue(tied0);
                date2 = this.ranger.getMaxValue(tied0);
                currentPackets = this.ids(this.filterJoins(all, date1, date2, tied0, field));
                incompatible = new ArrayList<Integer>(tied.getIncompatible());
                incompatible.retainAll(currentPackets);
                if (incompatible.size() <= 0) continue;
                set = (HashSet<TT>)incompatibleUnresolved.get(tied);
                if (set == null) {
                    set = new HashSet<TT>();
                    incompatibleUnresolved.put(tied, set);
                }
                for (Integer id : incompatible) {
                    set.add(this.resolver.resolve(id));
                }
            }
            for (T tied0 : currentList) {
                tied = (Tied)this.resolver.resolve(tied0);
                if (tied == null || tied.getIncompatible().size() <= 0) continue;
                date1 = this.ranger.getMinValue(tied0);
                date2 = this.ranger.getMaxValue(tied0);
                currentPackets = this.ids(this.filterJoins(add, date1, date2, tied0, field));
                incompatible = new ArrayList<Integer>(tied.getIncompatible());
                incompatible.retainAll(currentPackets);
                if (incompatible.size() <= 0) continue;
                set = (Set)incompatibleUnresolved.get(tied);
                if (set == null) {
                    set = new HashSet();
                    incompatibleUnresolved.put(tied, set);
                }
                for (Integer id : incompatible) {
                    set.add(this.resolver.resolve(id));
                }
            }
            if (dependsUnresolved.size() > 0 || incompatibleUnresolved.size() > 0) {
                throw new TieUnresolvedException(dependsUnresolved, incompatibleUnresolved);
            }
        }

        public void checkRemove(List<T> currentList, T remove, int field) throws TieUnresolvedException {
            this.checkRemove(currentList, (Iterable<T>)Collections.singleton(remove), field);
        }

        public void checkRemove(List<T> currentList, Iterable<T> remove, int field) throws TieUnresolvedException {
            HashMap dependsUnresolved = new HashMap();
            ArrayList<T> all = new ArrayList<T>(currentList);
            for (Object tied0 : remove) {
                all.remove(tied0);
            }
            for (Object tied0 : all) {
                Tied tied = (Tied)this.resolver.resolve(tied0);
                if (tied == null || tied.getDepends().size() <= 0 || Utils.haveDepends(this.resolver, this.ranger, all, tied0, tied, field)) continue;
                HashSet<TT> set = (HashSet<TT>)dependsUnresolved.get(tied);
                if (set == null) {
                    set = new HashSet<TT>();
                    dependsUnresolved.put(tied, set);
                }
                for (Integer id : tied.getDepends()) {
                    set.add(this.resolver.resolve(id));
                }
            }
            if (dependsUnresolved.size() > 0) {
                throw new TieUnresolvedException(dependsUnresolved, Collections.emptyMap());
            }
        }

        public void checkClose(List<T> currentList, T close, Date date, int field) throws TieUnresolvedException {
            this.checkClose(currentList, (Iterable<T>)Collections.singleton(close), date, field);
        }

        public void checkClose(List<T> currentList, Iterable<T> close, Date date, int field) throws TieUnresolvedException {
            HashMap dependsUnresolved = new HashMap();
            ArrayList<T> all = new ArrayList<T>(currentList);
            for (T tied : close) {
                all.remove(tied);
            }
            for (Object tied0 : close) {
                all.add(tied0);
            }
            for (Object tied0 : all) {
                Tied tied = (Tied)this.resolver.resolve(tied0);
                if (tied == null || tied.getDepends().size() <= 0 || Utils.haveDepends(this.resolver, this.ranger, all, tied0, tied, field)) continue;
                HashSet<TT> set = (HashSet<TT>)dependsUnresolved.get(tied);
                if (set == null) {
                    set = new HashSet<TT>();
                    dependsUnresolved.put(tied, set);
                }
                for (Integer id : tied.getDepends()) {
                    set.add(this.resolver.resolve(id));
                }
            }
            if (dependsUnresolved.size() > 0) {
                throw new TieUnresolvedException(dependsUnresolved, Collections.emptyMap());
            }
        }

        private Set<Integer> ids(List<T> cardPacketList) {
            HashSet<Integer> result = new HashSet<Integer>();
            for (T cp : cardPacketList) {
                result.add(this.resolver.resolveId(cp));
            }
            return result;
        }

        private List<T> filterJoins(Iterable<T> cardPacketList, Date date1, Date date2, T without, int field) {
            GregorianCalendar cdate2;
            GregorianCalendar cdate1;
            ArrayList<T> result = new ArrayList<T>();
            GregorianCalendar p1 = new GregorianCalendar();
            GregorianCalendar p2 = new GregorianCalendar();
            if (date1 != null) {
                cdate1 = new GregorianCalendar();
                cdate1.setTime(date1);
            } else {
                cdate1 = null;
            }
            if (date2 != null) {
                cdate2 = new GregorianCalendar();
                cdate2.setTime(date2);
            } else {
                cdate2 = null;
            }
            for (T cp : cardPacketList) {
                if (without == cp) continue;
                Date cpDate1 = this.ranger.getMinValue(cp);
                Date cpDate2 = this.ranger.getMaxValue(cp);
                if (date1 != null && cpDate2 != null) {
                    p2.setTime(cpDate2);
                    if (TimeUtils.compare(cdate1, p2, field) > 0) continue;
                }
                if (date2 != null && cpDate1 != null) {
                    p1.setTime(cpDate1);
                    if (TimeUtils.compare(p1, cdate2, field) > 0) continue;
                }
                result.add(cp);
            }
            return result;
        }

        private static <T, TT extends Tied> boolean haveDepends(TieResolver<T, TT> resolver, Ranger<T, Date> ranger, List<T> currentList, T tied0, Tied tied, int field) {
            return Utils.haveDependsAND(resolver, ranger, currentList, tied0, tied, field);
        }

        private static <T, TT extends Tied> boolean haveDependsOR(TieResolver<T, TT> resolver, Ranger<T, Date> ranger, List<T> currentList, T tied0, Tied tied, final int field) {
            ArrayList<Date[]> periods = new ArrayList<Date[]>();
            GregorianCalendar cperiod0 = new GregorianCalendar();
            GregorianCalendar cperiod1 = new GregorianCalendar();
            GregorianCalendar cp0 = new GregorianCalendar();
            GregorianCalendar cp1 = new GregorianCalendar();
            Comparator<Calendar> comparator = new Comparator<Calendar>(){

                @Override
                public int compare(Calendar o1, Calendar o2) {
                    return TimeUtils.compare(o1, o2, field);
                }
            };
            block0: for (T t : currentList) {
                if (!tied.getDepends().contains(((Tied)resolver.resolve(t)).getId())) continue;
                Date[] period = new Date[]{ranger.getMinValue(t), ranger.getMaxValue(t)};
                block1: while (period != null) {
                    Iterator iter = periods.iterator();
                    while (iter.hasNext()) {
                        Date[] p = (Date[])iter.next();
                        if (p[0] != null && period[1] != null) {
                            cp0.setTime(p[0]);
                            ((Calendar)cp0).add(field, -1);
                            cperiod1.setTime(period[1]);
                            if (TimeUtils.compare(cp0, cperiod1, field) > 0) continue;
                        }
                        if (p[1] != null && period[0] != null) {
                            cperiod0.setTime(period[0]);
                            ((Calendar)cperiod0).add(field, -1);
                            cp1.setTime(p[1]);
                            if (TimeUtils.compare(cperiod0, cp1, field) > 0) continue;
                        }
                        if (p[0] == null || period[0] == null) {
                            p[0] = null;
                        } else {
                            Date date = p[0] = p[0].before(period[0]) ? p[0] : period[0];
                        }
                        p[1] = p[1] == null || period[1] == null ? null : (p[1].before(period[1]) ? period[1] : p[1]);
                        period = p;
                        iter.remove();
                        continue block1;
                    }
                    periods.add(period);
                    continue block0;
                }
            }
            Date period0 = ranger.getMinValue(tied0);
            Date period1 = ranger.getMaxValue(tied0);
            if (period0 != null) {
                cperiod0.setTime(period0);
            } else {
                cperiod0 = null;
            }
            if (period1 != null) {
                cperiod1.setTime(period1);
            } else {
                cperiod1 = null;
            }
            for (Date[] p : periods) {
                GregorianCalendar range1;
                GregorianCalendar range0;
                cp0.setTime(p[0]);
                if (p[0] != null) {
                    range0 = cp0;
                    range0.setTime(p[0]);
                } else {
                    range0 = null;
                }
                if (p[1] != null) {
                    range1 = cp1;
                    range1.setTime(p[1]);
                } else {
                    range1 = null;
                }
                if (!RangeUtils.inRange(comparator, cperiod0, cperiod1, range0, range1)) continue;
                return true;
            }
            return false;
        }

        private static <T, TT extends Tied> boolean haveDependsAND(TieResolver<T, TT> resolver, Ranger<T, Date> ranger, List<T> currentList, T tied0, Tied tied, int field) {
            HashMap<Integer, ArrayList<T>> map = new HashMap<Integer, ArrayList<T>>();
            for (T t : currentList) {
                Integer id = resolver.resolveId(t);
                if (!tied.getDepends().contains(id)) continue;
                ArrayList<T> list = (ArrayList<T>)map.get(id);
                if (list == null) {
                    list = new ArrayList<T>();
                    map.put(id, list);
                }
                list.add(t);
            }
            if (map.size() == 0) {
                return false;
            }
            for (List list : map.values()) {
                if (Utils.haveDependsOR(resolver, ranger, list, tied0, tied, field)) continue;
                return false;
            }
            return true;
        }
    }

    public static class TieUnresolvedException
    extends Exception {
        private final Map<? extends Tied, Set<Object>> dependsUnresolved;
        private final Map<? extends Tied, Set<Object>> incompatibleUnresolved;

        public TieUnresolvedException(Map<? extends Tied, Set<Object>> dependsUnresolved, Map<? extends Tied, Set<Object>> incompatibleUnresolved) {
            this.dependsUnresolved = dependsUnresolved;
            this.incompatibleUnresolved = incompatibleUnresolved;
        }

        public Map<? extends Tied, Set<Object>> getDependsUnresolved() {
            return this.dependsUnresolved;
        }

        public Map<? extends Tied, Set<Object>> getIncompatibleUnresolved() {
            return this.incompatibleUnresolved;
        }
    }

    public static interface TieResolver<T, TT> {
        public TT resolve(T var1);

        public int resolveId(T var1);

        public TT resolve(Integer var1);
    }
}

