/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.hd.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import ru.bitel.bgbilling.common.dao.AbstarctDaoConstant;
import ru.bitel.bgbilling.modules.hd.server.bean.CPDomain;
import ru.bitel.common.Utils;

public class CPDomainManager
extends AbstarctDaoConstant {
    public CPDomainManager(Connection con, int moduleId) {
        super(con, "hd_cp_domain", moduleId);
    }

    public CPDomain getDomain(int cpid) throws SQLException {
        CPDomain result = null;
        String query = "SELECT * FROM " + this.tableName + " WHERE cpid=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, cpid);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    result = this.getHdServiceDomainFromRS(rs);
                }
            }
        }
        return result;
    }

    public int checkDomain(String packages, int cpid, String domain) throws SQLException {
        int result = 0;
        String contractPackageTable = "hd_contract_package_" + this.moduleId;
        String query = "SELECT cp.cid FROM " + this.tableName + " AS domain INNER JOIN " + contractPackageTable + " AS cp ON domain.cpid=cp.id AND cp.status=? WHERE pid IN ( " + packages + ") AND domain.cpid!=? LIMIT 1";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, 1);
            ps.setInt(2, cpid);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    result = rs.getInt(1);
                }
            }
        }
        return result;
    }

    private CPDomain getHdServiceDomainFromRS(ResultSet rs) throws SQLException {
        CPDomain result = new CPDomain();
        result.setContractPackageId(rs.getInt("cpid"));
        result.setDomain(rs.getString("domain"));
        result.setAdminMail(rs.getString("admin_mail"));
        result.setRecords(Utils.stringToPairs((String)rs.getString("records")));
        return result;
    }

    public void deleteDomain(int cpid) throws SQLException {
        String query = "DELETE FROM " + this.tableName + " WHERE cpid=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, cpid);
            ps.executeUpdate();
        }
    }

    public void updateDomain(CPDomain domain) {
        try {
            this.deleteDomain(domain.getContractPackageId());
            String query = "INSERT INTO " + this.tableName + " (cpid, domain, admin_mail, records) VALUES (?, ?, ?, ?)";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, domain.getContractPackageId());
            ps.setString(2, domain.getDomain());
            ps.setString(3, domain.getAdminMail());
            ps.setString(4, Utils.pairToString(domain.getRecords()));
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

