<%@ page contentType="text/html; charset=UTF-8"%>
<%@ taglib prefix = "c" uri="jakarta.tags.core" %>
<%@ taglib prefix = "fmt" uri="jakarta.tags.fmt" %>

<html>
	<head>
		<meta http-equiv="content-type" content="text/html; charset=utf-8" />
		<style type="text/css">
            th, td { text-align: center; }
            tr.itogo td { background-color: #e0e0e0; }
            tr.itogo td:first-child { text-align: left; }
            table.session tr td:first-child { white-space: nowrap; }
            table.session tr td:nth-child(2) { text-align: left; } 
            table.session tr td:last-child { text-align: right; }
            table.session tr.service td { text-align: left; background-color: #e0e0e0; font-size: 130%; }
            table.session tr.aon td { text-align: left; background-color: #d0d0d0; font-size: 115%; }
        </style>
    </head>
    <body>
        <div style="text-align: center;">
        <h2>Договор:&#160;${contract.title}(${contract.comment})</h2>
        <div style="margin: 20px;">Период с: <fmt:formatDate pattern = "dd.MM.yyyy" value = "${dateFrom}"/> по <fmt:formatDate pattern = "dd.MM.yyyy" value = "${dateTo}"/></div>

            <table width="100%" border="1" cellspacing="0" cellpadding="3" class="session">
                <tr bgcolor="#f0f0f0">
                    <th>Дата/время звонка</th>
                    <th>Направление</th>
                    <th>Номер телефона A</th>
                    <th>Номер телефона B</th>
                    <th>Длительность, мин.</th>
                    <th>Длительность окр., мин.</th>
                    <th>Стоимость звонка, руб.</th>
                </tr>

                <%pageContext.getELContext().getImportHandler().importClass("ru.bitel.common.Utils");%>
                <c:forEach items="${result.list}" var="service">
                    <tr class="service"><td colspan="7">Услуга: ${service.service}</td></tr>
                    <c:forEach items="${service.result}" var="account">
                        <tr class="aon"><td colspan="7">Номер абонента: ${account.numberA}</td></tr>
                        <c:forEach items="${account.result}" var="item">
                            <tr>
                                <td><fmt:formatDate pattern = "dd.MM.yyyy HH:mm:ss" value = "${item.sessionStart}"/></td>
                                <td>${item.destination}</td>
                                <td>${item.numberA}</td>
                                <td>${item.numberB}</td> 
                                <td>${Utils.formatSessionTime( item.duration )}</td>
                                <td>${Utils.formatSessionTime( item.durationRound )}</td>
                                <td>${item.cost}</td>
                            </tr>
                        </c:forEach>
                        <tr class="itogo">
                            <td colspan="2">Итого по номеру:&#160;кол-во&#160;${account.count}</td>
                            <td></td>
                            <td></td>
                            <td>${Utils.formatSessionTime( account.amount )}</td>
                            <td>${Utils.formatSessionTime( account.amountRound )}</td>
                            <td>сумма&#160;${account.summ}</td>
                        </tr>
                    </c:forEach>
                    <tr class="itogo">
                        <td colspan="2">Итого по услуге:&#160;кол-во&#160;${service.count}</td>
                        <td></td>
                        <td></td>
                        <td>${Utils.formatSessionTime( service.amount )}</td>
                        <td>${Utils.formatSessionTime( service.amountRound )}</td>
                        <td>сумма&#160;${service.summ}</td>
                    </tr>
                </c:forEach>
            </table>
            <br/>
            <br/>
            Количество сессий:&#160;;${result.getAttribute("totalCount")}
            Итого [в секундах]:&#160;${result.getAttribute("totalTime")}&#160;
            Итого, окр. [в секундах]:&#160;${result.getAttribute("totalTimeRound")}&#160;
            Итого [в рублях]:&#160;${result.getAttribute("totalSum")}&#160;
        </div>
	</body>
</html>