/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.omega.server.servlet;

import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import org.apache.logging.log4j.LogManager;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.kernel.base.server.CommonExecutor;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.modules.omega.server.bean.OmegaManager;
import ru.bitel.bgbilling.server.util.Setup;

@WebServlet(name="omegaExecutor", urlPatterns={"/omega/*"})
public class ModuleExecutor
extends CommonExecutor {
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        JSONObject jsonObject = null;
        try {
            int moduleId = ModuleExecutor.getModuleId((HttpServletRequest)request);
            Connection con = Setup.getSetup().getDBConnectionFromPool();
            String method = request.getParameter("method");
            if (method == null) {
                jsonObject = this.auth(request, con, moduleId);
            } else {
                String hash = request.getParameter("hash");
                Contract contract = new OmegaManager(con, moduleId).getContract(hash);
                if (contract != null) {
                    JSONObject params = new JSONObject(request.getParameter("params"));
                    if ("getStatusCredit".equals(method)) {
                        jsonObject = this.getStatusCredit(contract, params, request, con, moduleId);
                    } else if ("setCredit".equals(method)) {
                        jsonObject = this.setCredit(contract, params, request, con, moduleId);
                    } else if ("changeTarif".equals(method)) {
                        jsonObject = this.changeTarif(contract, params, request, con, moduleId);
                    } else if ("getActiveTariff".equals(method)) {
                        jsonObject = this.getActiveTariff(contract, params, request, con, moduleId);
                    } else if ("getInetStatus".equals(method)) {
                        jsonObject = this.getInetStatus(contract, params, request, con, moduleId);
                    } else if ("getActiveServices".equals(method)) {
                        jsonObject = this.getActiveServices(contract, params, request, con, moduleId);
                    } else if ("deactivateService".equals(method)) {
                        jsonObject = this.deactivateService(contract, params, request, con, moduleId);
                    } else if ("getServicesAvailableToActivate".equals(method)) {
                        jsonObject = this.getServicesAvailableToActivate(contract, params, request, con, moduleId);
                    } else if ("createNewService".equals(method)) {
                        jsonObject = this.createNewService(contract, params, request, con, moduleId);
                    }
                }
            }
        }
        catch (Exception e) {
            LogManager.getLogger().error((Object)e);
        }
        response.setContentType("application/json; charset=utf-8");
        PrintWriter out = response.getWriter();
        out.print(jsonObject != null ? jsonObject.toString() : "{}");
        out.flush();
        out.close();
    }

    private JSONObject auth(HttpServletRequest request, Connection con, int moduleId) {
        String login = request.getParameter("login");
        String password = request.getParameter("password");
        String key = request.getParameter("key");
        int result = 0;
        String hash = "";
        try (ContractDao contractDao = new ContractDao(con, 0);){
            Contract contract = contractDao.getByTitle(login);
            if (contract != null) {
                result = contract.getPassword().equals(password) ? 0 : 1;
                OmegaManager omegaManager = new OmegaManager(con, moduleId);
                hash = omegaManager.getHash(contract, key);
            }
        }
        catch (Exception e) {
            result = 1;
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("result", result);
        jsonObject.put("hash", (Object)hash);
        return jsonObject;
    }

    private JSONObject getStatusCredit(Contract contract, JSONObject params, HttpServletRequest request, Connection con, int moduleId) {
        return this.result(new OmegaManager(con, moduleId).getStatusCredit(contract));
    }

    private JSONObject setCredit(Contract contract, JSONObject params, HttpServletRequest request, Connection con, int moduleId) {
        return this.result(new OmegaManager(con, moduleId).setCredit(contract, params.optInt("days")));
    }

    private JSONObject changeTarif(Contract contract, JSONObject params, HttpServletRequest request, Connection con, int moduleId) {
        return this.result(new OmegaManager(con, moduleId).changeTarif(contract, params.optString("proceeddate"), params.optString("newTarif")));
    }

    private JSONObject getActiveTariff(Contract contract, JSONObject params, HttpServletRequest request, Connection con, int moduleId) {
        return this.result("tarifs", new OmegaManager(con, moduleId).getActiveTariff(contract));
    }

    private JSONObject getInetStatus(Contract contract, JSONObject params, HttpServletRequest request, Connection con, int moduleId) {
        return new OmegaManager(con, moduleId).getInetStatus(contract);
    }

    private JSONObject getActiveServices(Contract contract, JSONObject params, HttpServletRequest request, Connection con, int moduleId) {
        return this.result("data", new OmegaManager(con, moduleId).getActiveServices(contract));
    }

    private JSONObject deactivateService(Contract contract, JSONObject params, HttpServletRequest request, Connection con, int moduleId) {
        return this.result(new OmegaManager(con, moduleId).deactivateService(contract, params.optString("ServiceId")));
    }

    private JSONObject getServicesAvailableToActivate(Contract contract, JSONObject params, HttpServletRequest request, Connection con, int moduleId) {
        return this.result("data", new OmegaManager(con, moduleId).getServicesAvailableToActivate(contract));
    }

    private JSONObject createNewService(Contract contract, JSONObject params, HttpServletRequest request, Connection con, int moduleId) {
        return this.result(new OmegaManager(con, moduleId).createNewService(contract, params.optString("serviceTypeId")));
    }

    private JSONObject result(int enable) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("enable", enable);
        return jsonObject;
    }

    private JSONObject result(String text) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("result", text == null ? 0 : 1);
        if (text != null) {
            jsonObject.put("text", (Object)text);
        }
        return jsonObject;
    }

    private JSONObject result(String key, JSONArray jsonArray) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("result", jsonArray == null ? 0 : 1);
        if (jsonArray != null) {
            jsonObject.put(key, (Object)jsonArray);
        }
        return jsonObject;
    }
}

