/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.server.event.om;

import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;
import javax.jms.JMSException;
import javax.jms.Message;
import ru.bitel.bgbilling.apps.voice.access.om.AccountOrderEvent;
import ru.bitel.bgbilling.kernel.event.EventType;
import ru.bitel.bgbilling.kernel.event.common.QueueEvent;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceAccount;
import ru.bitel.bgbilling.modules.voice.common.bean.enums.VoiceAccountState;
import ru.bitel.bgbilling.modules.voice.server.runtime.VoiceAccountRuntime;
import ru.bitel.bgbilling.modules.voice.server.runtime.VoiceApplication;

@EventType(autoAcknowledge=false)
@XmlRootElement
public class OmVoiceAccountStateModifyEvent
extends QueueEvent {
    @XmlAttribute
    private final int deviceId;
    @XmlAttribute
    private final int voiceAccountId;
    @XmlAttribute
    private final short state;

    private OmVoiceAccountStateModifyEvent() {
        this(-1, -1, -1, -1, VoiceAccountState.STATE_DELETED.getCode());
    }

    public OmVoiceAccountStateModifyEvent(int moduleId, VoiceAccount account, short state) {
        this(moduleId, account.getContractId(), account.getDeviceId(), account.getId(), state);
    }

    public OmVoiceAccountStateModifyEvent(int moduleId, int contractId, int deviceId, int voiceAccountId, short state) {
        super(moduleId, contractId, -1);
        this.deviceId = deviceId;
        this.voiceAccountId = voiceAccountId;
        this.state = state;
    }

    public void prepareMessage(Message message) throws JMSException {
        super.prepareMessage(message);
        message.setIntProperty("deviceId", this.deviceId);
    }

    public AccountOrderEvent toAccountOrderEvent(VoiceApplication application) {
        VoiceAccountRuntime accountRuntime = application.getVoiceAccountRuntimeMap().get(this.voiceAccountId);
        if (accountRuntime == null) {
            this.getLogger().error("accountRuntime is null for " + this.voiceAccountId);
            return null;
        }
        VoiceAccountState oldState = ((VoiceAccount)accountRuntime.getAccount()).getDeviceState();
        VoiceAccountState newState = VoiceAccountState.getVoiceAccountState((int)this.state);
        int eventType = 2;
        if (!(oldState != VoiceAccountState.STATE_ENABLE && oldState != VoiceAccountState.STATE_DISABLE || newState != VoiceAccountState.STATE_ENABLE && newState != VoiceAccountState.STATE_DISABLE)) {
            if (oldState == newState) {
                this.getLogger().debug("VoiceAccount state already " + String.valueOf(newState));
                return null;
            }
            eventType = 4;
        }
        AccountOrderEvent result = new AccountOrderEvent(this.deviceId, eventType, (VoiceAccount)accountRuntime.getAccount(), (VoiceAccount)accountRuntime.getAccount(), oldState, newState);
        return result;
    }

    protected void toString(StringBuilder sb) {
        sb.append("; deviceId: ").append(this.deviceId);
        sb.append("; accountId: ").append(this.voiceAccountId);
        sb.append("; state: ").append(VoiceAccountState.getVoiceAccountState((int)this.state));
    }
}

