/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.hd.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.common.dao.AbstarctDaoConstant;
import ru.bitel.bgbilling.modules.hd.common.bean.Zone;
import ru.bitel.common.TimeUtils;

public class ZoneDAO
extends AbstarctDaoConstant {
    private String deletedZoneTableName = "hd_deleted_zones_";

    public ZoneDAO(Connection con, int moduleId) {
        super(con, "hd_zone", moduleId);
        this.deletedZoneTableName = this.deletedZoneTableName + moduleId;
    }

    public List<Zone> getZoneList() {
        ArrayList<Zone> result = new ArrayList<Zone>();
        try {
            Statement st = this.con.createStatement();
            ResultSet rs = st.executeQuery("SELECT " + "*" + " FROM " + this.tableName);
            while (rs.next()) {
                result.add(this.getZoneFromRs(rs));
            }
            rs.close();
            st.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public List<Zone> getZoneList(int contractId) throws SQLException {
        ArrayList<Zone> result = new ArrayList<Zone>();
        StringBuilder query = new StringBuilder().append("SELECT ").append("*").append(" FROM ").append(this.tableName).append(" WHERE ").append("contract_id=?").append(" ORDER BY ").append("zone");
        try (PreparedStatement ps = this.con.prepareStatement(query.toString());){
            int index = 1;
            ps.setInt(index++, contractId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result.add(this.getZoneFromRs(rs));
                }
            }
        }
        return result;
    }

    public List<Zone> getModifiedZoneList(boolean avto) {
        ArrayList<Zone> result = new ArrayList<Zone>();
        try {
            StringBuilder query = new StringBuilder("SELECT *");
            query.append(" FROM " + this.tableName);
            query.append(" WHERE ");
            query.append("last_update <> '1970-01-01 05:00:00'");
            if (avto) {
                query.append(" AND avto=1");
            }
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(this.getZoneFromRs(rs));
            }
            rs.close();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public Zone getZoneById(int zoneId) {
        Zone zone = new Zone();
        try {
            StringBuilder query = new StringBuilder("SELECT ");
            query.append("*");
            query.append(" FROM ");
            query.append(this.tableName);
            query.append(" WHERE ");
            query.append("id=?");
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            ps.setInt(1, zoneId);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                zone = this.getZoneFromRs(rs);
            }
            rs.close();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return zone;
    }

    public void addZone(Zone zone) {
        try {
            int index = 1;
            StringBuilder query = new StringBuilder("INSERT INTO ").append(this.tableName);
            query.append(" SET ").append("contract_id=?, zone=?, comment=?, date_from=?, date_to=?, data=?, config=?, whois=?, last_update=?");
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            ps.setInt(index++, zone.getContractId());
            ps.setString(index++, zone.getZone());
            ps.setString(index++, zone.getComment());
            ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)zone.getPeriod().getDateFrom()));
            ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)zone.getPeriod().getDateTo()));
            ps.setString(index++, zone.getData());
            ps.setString(index++, zone.getConfig());
            ps.setInt(index++, zone.isLoadWhois() ? 1 : 0);
            ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)zone.getLastUpdate()));
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void deleteZone(int zoneId) {
        try {
            Zone zone = this.getZoneById(zoneId);
            StringBuilder query = new StringBuilder("INSERT INTO ");
            query.append(this.deletedZoneTableName);
            query.append(" VALUES ");
            query.append("(" + zone.getZone() + ")");
            query.delete(0, query.length());
            query.append("DELETE FROM ");
            query.append(this.tableName);
            query.append(" WHERE ");
            query.append("id=?");
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            ps.setInt(1, zoneId);
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void updateZone(Zone zone) {
        this.updateZone(zone, null);
    }

    public boolean updateZone(Zone zone, Date lastUpdate) {
        boolean result = false;
        try {
            int index = 1;
            StringBuilder query = new StringBuilder("UPDATE ").append(this.tableName);
            query.append(" SET ").append("contract_id=?, zone=?, comment=?, date_from=?, date_to=?, data=?, config=?, whois=?, whois_last_update=?, whois_registrar=?, free_date=?, avto=?, last_update=?");
            query.append(" WHERE ").append("id=?");
            if (lastUpdate != null) {
                query.append(" AND last_update=?");
            }
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            ps.setInt(index++, zone.getContractId());
            ps.setString(index++, zone.getZone());
            ps.setString(index++, zone.getComment());
            ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)zone.getPeriod().getDateFrom()));
            ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)zone.getPeriod().getDateTo()));
            ps.setString(index++, zone.getData());
            ps.setString(index++, zone.getConfig());
            ps.setInt(index++, zone.isLoadWhois() ? 1 : 0);
            ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)zone.getWhoisLastUpdate()));
            ps.setString(index++, zone.getRegistrar());
            ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)zone.getFreeDate()));
            ps.setInt(index++, zone.isAvto() ? 1 : 0);
            ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)zone.getLastUpdate()));
            ps.setInt(index++, zone.getId());
            if (lastUpdate != null) {
                ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)lastUpdate));
            }
            result = ps.executeUpdate() == 1;
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public List<Integer> getZoneIdListByWhoisLastUpdate(String zoneMask, int limit) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        try {
            StringBuilder query = new StringBuilder("SELECT ");
            query.append("id");
            query.append(" FROM ");
            query.append(this.tableName);
            query.append(" WHERE ");
            query.append("zone REGEXP ?");
            query.append(" AND whois=?");
            query.append(" AND ( ISNULL(date_from) OR date_from<NOW() )");
            query.append(" AND ( ISNULL(date_to) OR date_to>NOW() )");
            query.append(" ORDER BY ");
            query.append("whois_last_update");
            query.append(" LIMIT ");
            query.append(limit);
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            ps.setString(1, zoneMask);
            ps.setInt(2, 1);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                list.add(rs.getInt(1));
            }
            rs.close();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return list;
    }

    private Zone getZoneFromRs(ResultSet rs) throws SQLException {
        Zone zone = new Zone();
        zone.setId(rs.getInt("id"));
        zone.setContractId(rs.getInt("contract_id"));
        zone.setZone(rs.getString("zone"));
        zone.setComment(rs.getString("comment"));
        zone.setConfig(rs.getString("config"));
        zone.setData(rs.getString("data"));
        zone.setLoadWhois(rs.getBoolean("whois"));
        zone.setWhoisLastUpdate((Date)rs.getTimestamp("whois_last_update"));
        zone.setRegistrar(rs.getString("whois_registrar"));
        zone.setFreeDate((Date)rs.getDate("free_date"));
        zone.setAvto(rs.getBoolean("avto"));
        zone.setPeriod(this.getPeriod(rs));
        zone.setLastUpdate((Date)rs.getTimestamp("last_update"));
        return zone;
    }
}

