/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.rscm.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import ru.bitel.bgbilling.common.dao.AbstarctDaoConstant;
import ru.bitel.bgbilling.modules.rscm.common.bean.RSCMService;
import ru.bitel.bgbilling.server.util.ServerUtils;

public class RSCMServiceManager
extends AbstarctDaoConstant {
    public RSCMServiceManager(Connection con, int moduleId) {
        super(con, "rscm_service", moduleId);
    }

    private RSCMService getServiceFromRS(ResultSet rs) throws SQLException {
        return new RSCMService().setId(rs.getInt("id")).setServiceId(rs.getInt("sid")).setServiceTitle(rs.getString("title")).setUnit(rs.getString("unit")).setInstallmentData(rs.getString("installment"));
    }

    public List<RSCMService> getServiceList() throws SQLException {
        return this.getServiceList(null);
    }

    public List<RSCMService> getServiceList(Boolean isusing) throws SQLException {
        ArrayList<RSCMService> result = new ArrayList<RSCMService>();
        StringBuilder query = new StringBuilder("SELECT rscm.*, service.title FROM ").append(this.tableName).append(" AS rscm ").append(" LEFT JOIN service ON service.id=rscm.sid");
        if (isusing != null) {
            query.append(" WHERE service.isusing=").append(isusing != false ? 0 : 1);
        }
        query.append(" ORDER BY service.title");
        try (Statement st = this.con.createStatement();
             ResultSet rs = st.executeQuery(query.toString());){
            while (rs.next()) {
                result.add(this.getServiceFromRS(rs));
            }
        }
        return result;
    }

    public void updateService(RSCMService rscmService) throws SQLException {
        if (rscmService == null) {
            return;
        }
        boolean update = rscmService.getId() > 0;
        String query = (update ? "UPDATE " : "INSERT INTO ") + this.tableName + " SET sid=?, unit=?, installment=?" + (update ? " WHERE id=?" : "");
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            int parameterIndex = 1;
            ps.setInt(parameterIndex++, rscmService.getServiceId());
            ps.setString(parameterIndex++, rscmService.getUnit());
            ps.setString(parameterIndex++, rscmService.getInstallmentData());
            if (update) {
                ps.setInt(parameterIndex++, rscmService.getId());
            }
            ps.executeUpdate();
            if (!update) {
                rscmService.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
            }
        }
    }

    public void deleteService(int id) throws SQLException {
        String query = "DELETE FROM " + this.tableName + " WHERE id=" + id;
        try (Statement st = this.con.createStatement();){
            st.executeUpdate(query);
        }
    }

    public RSCMService getService(int id) throws SQLException {
        RSCMService result = null;
        String query = "SELECT rscm.*, service.title FROM " + this.tableName + " AS rscm  LEFT JOIN service ON service.id=rscm.sid  WHERE rscm.id=" + id;
        try (Statement st = this.con.createStatement();
             ResultSet rs = st.executeQuery(query);){
            if (rs.next()) {
                result = this.getServiceFromRS(rs);
            }
        }
        return result;
    }

    public RSCMService getServiceByServiceId(int serviceId) {
        RSCMService result = null;
        try (Statement st = this.con.createStatement();){
            String query = "SELECT rscm.*, service.title FROM rscm_service_" + this.moduleId + " as rscm LEFT JOIN service ON service.id=rscm.sid  WHERE rscm.sid=" + serviceId;
            ResultSet rs = st.executeQuery(query);
            if (rs.next()) {
                result = this.getServiceFromRS(rs);
            }
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return result;
    }
}

