/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.sorm.client;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellRenderer;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGSplitPaneNoBorder;
import ru.bitel.bgbilling.client.common.BGToolTip;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.BooleanTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.modules.sorm.client.AdditionalUploadFiles;
import ru.bitel.bgbilling.modules.sorm.client.SormProjectsPanel;
import ru.bitel.bgbilling.modules.sorm.client.upload.AbonentsConfigurePanel;
import ru.bitel.bgbilling.modules.sorm.client.upload.CDRConfigurePanel;
import ru.bitel.bgbilling.modules.sorm.client.upload.ConfigurePanelFactory;
import ru.bitel.bgbilling.modules.sorm.client.upload.DirectoryConfigurePanel;
import ru.bitel.bgbilling.modules.sorm.client.upload.bastion.BastionDirectoryConfigurePanel;
import ru.bitel.bgbilling.modules.sorm.client.upload.elkom.ElkomDirectoryConfigurePanel;
import ru.bitel.bgbilling.modules.sorm.client.upload.shiftsystems.ShiftSystemsDirectoryConfigurePanel;
import ru.bitel.bgbilling.modules.sorm.common.SormManufacturer;
import ru.bitel.bgbilling.modules.sorm.common.bean.InstalledInstanceModule;
import ru.bitel.bgbilling.modules.sorm.common.bean.SormProject;
import ru.bitel.bgbilling.modules.sorm.common.service.SormService;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.GuiTitlable;
import ru.bitel.common.model.IdTitle;

public class SormSettingsPanel
extends BGUPanel {
    private static final String CREATE_UPLOAD_PANEL = "createUploadPanel";
    public final Font comboBoxFont = new Font("Arial", 0, 11);
    private final GridBagConstraints constraints = new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 3, 3, 3), 0, 0);
    private final JLabel projectIdLabel = new JLabel();
    private final JTextField projectTitleLabel = new JTextField();
    private final FileTransferConfigurePanel fileTransferConfigurePanel = new FileTransferConfigurePanel();
    private final JTextField adminEmail = new JTextField();
    private final BGUComboBox<SormManufacturer> manufacturer = new BGUComboBox();
    private final JTextArea comment = new JTextArea();
    private final AdditionalUploadFiles additionalUploadFiles = new AdditionalUploadFiles();
    private final BGButton save = new BGButton("\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044e");
    private final BGButton cancel = new BGButton("\u0417\u0430\u043a\u0440\u044b\u0442\u044c");
    private BGUTable table;
    private BGTableModel<InstalledInstanceModule> tableModel;
    public JTabbedPane rightPanel;
    private AbonentsConfigurePanel abonentsConfigurePanel = null;
    private DirectoryConfigurePanel directoryConfigurePanel = null;
    private CDRConfigurePanel cdrConfigurePanel = null;
    private final SormProjectsPanel sormProjectsPanel;
    private SormService sormService;
    private SormProject sormProject;
    AbstractBGUPanel.AsyncAction<Window> createUploadPanel = new AbstractBGUPanel.AsyncAction<Window>("createUploadPanel", "\u0421\u043e\u0437\u0434\u0430\u043d\u0438\u0435 \u043f\u0430\u043d\u0435\u043b\u0435\u0439 \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0438"){

        protected Window doInBackground() {
            Window waitwindow = ClientUtils.showWaitWindow((String)"\u0417\u0430\u0433\u0440\u0443\u0437\u043a\u0430...");
            SormSettingsPanel.this.createUploadPanel();
            return waitwindow;
        }

        protected void done(Window window) {
            window.dispose();
        }
    };

    public SormSettingsPanel(SormProjectsPanel sormProjectsPanel) {
        this.sormProjectsPanel = sormProjectsPanel;
    }

    protected void jbInit() {
        this.rightPanel = new JTabbedPane();
        this.setLayout(new GridBagLayout());
        this.manufacturer.setFont(this.comboBoxFont);
        this.manufacturer.setData(Arrays.asList(SormManufacturer.values()));
        this.manufacturer.addItemListener(e -> {
            if (e.getStateChange() == 1 && this.abonentsConfigurePanel != null && this.directoryConfigurePanel != null) {
                this.sormProject.setConfig(this.buildConfig().toString());
                this.performAction(CREATE_UPLOAD_PANEL);
            }
        });
        this.initTableWithInstalledModules();
        this.save.addActionListener(e -> this.updateSormConfig());
        this.cancel.addActionListener(e -> {
            this.sormProjectsPanel.showPanel("list_projects_panel");
            this.sormProjectsPanel.performAction("refresh");
        });
        BGSplitPaneNoBorder splitPane = new BGSplitPaneNoBorder(1, (Component)this.getSettingsPanel(), (Component)this.rightPanel, 350L);
        this.add((Component)splitPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void initTableWithInstalledModules() {
        this.tableModel = new BGTableModel<InstalledInstanceModule>("\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043d\u044b\u0435 \u043c\u043e\u0434\u0443\u043b\u0438"){

            protected void initColumns() {
                this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u044d\u043a\u0437\u0435\u043c\u043f\u043b\u044f\u0440\u0430", 150, 250, 250, "title", false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
                this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043c\u043e\u0434\u0443\u043b\u044f", 150, 250, 250, "titleModule", false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
                this.addColumn("", 10, 30, 30, "isSelected", false, (TableCellRenderer)new BooleanTableCellRenderer());
            }
        };
        this.table = new BGUTable(this.tableModel);
        this.tableModel.setData(this.getService().getInstalledSormModules());
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e)) {
                    InstalledInstanceModule instanceModule;
                    instanceModule.setSelected(!(instanceModule = (InstalledInstanceModule)SormSettingsPanel.this.tableModel.getSelectedRow()).isSelected());
                    SormSettingsPanel.this.table.repaint();
                    if (SormSettingsPanel.this.directoryConfigurePanel != null && !SormSettingsPanel.this.checkNonUploadDirectoryPanel()) {
                        SormSettingsPanel.this.sormProject.setConfig(SormSettingsPanel.this.buildConfig().toString());
                        SormSettingsPanel.this.directoryConfigurePanel.setSormProject(SormSettingsPanel.this.sormProject);
                        SormSettingsPanel.this.directoryConfigurePanel.performAction("reset");
                        SormSettingsPanel.this.directoryConfigurePanel.performAction("refresh");
                    }
                }
            }
        });
    }

    private boolean checkNonUploadDirectoryPanel() {
        return ElkomDirectoryConfigurePanel.class.isAssignableFrom(((Object)((Object)this.directoryConfigurePanel)).getClass()) || ShiftSystemsDirectoryConfigurePanel.class.isAssignableFrom(((Object)((Object)this.directoryConfigurePanel)).getClass()) || BastionDirectoryConfigurePanel.class.isAssignableFrom(((Object)((Object)this.directoryConfigurePanel)).getClass());
    }

    private JPanel getSettingsPanel() {
        JScrollPane uploadSettingsScroll = new JScrollPane(this.getUploadSettingPanel());
        uploadSettingsScroll.getVerticalScrollBar().setUnitIncrement(16);
        JPanel settingsPanel = new JPanel(new GridBagLayout());
        settingsPanel.add((Component)this.getMainSettingPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 1, new Insets(3, 3, 0, 0), 0, 0));
        settingsPanel.add((Component)uploadSettingsScroll, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(3, 3, 0, 0), 0, 0));
        settingsPanel.add((Component)this.getButtonPanel(), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 16, 2, new Insets(0, 3, 3, 0), 0, 0));
        return settingsPanel;
    }

    private JPanel getMainSettingPanel() {
        JPanel mainSettings = new JPanel(new GridBagLayout());
        mainSettings.setBorder(BorderFactory.createLineBorder(Color.GRAY, 1, true));
        mainSettings.add((Component)this.projectIdLabel, this.constraints);
        mainSettings.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043f\u0440\u043e\u0435\u043a\u0442\u0430:"), this.constraints);
        mainSettings.add((Component)this.projectTitleLabel, this.constraints);
        mainSettings.add((Component)new JLabel("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439:"), this.constraints);
        this.comment.setLineWrap(true);
        JScrollPane commentScrollPane = new JScrollPane(this.comment);
        Dimension dimension = new Dimension(385, 110);
        commentScrollPane.setMinimumSize(dimension);
        commentScrollPane.setPreferredSize(dimension);
        commentScrollPane.setHorizontalScrollBarPolicy(31);
        mainSettings.add((Component)commentScrollPane, this.constraints);
        return mainSettings;
    }

    private JPanel getUploadSettingPanel() {
        JPanel uploadSettings = new JPanel(new GridBagLayout());
        uploadSettings.setBorder(BorderFactory.createLineBorder(Color.GRAY, 1, true));
        uploadSettings.add((Component)this.fileTransferConfigurePanel, this.constraints);
        this.constraints.weighty = 0.0;
        this.constraints.insets.top = 3;
        uploadSettings.add((Component)new JLabel("Email (\u0434\u043b\u044f \u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0438 \u043e\u0442\u0447\u0451\u0442\u0430 \u043e\u0431 \u043e\u0448\u0438\u0431\u043a\u0430\u0445)"), this.constraints);
        uploadSettings.add((Component)this.adminEmail, this.constraints);
        uploadSettings.add((Component)new JLabel("\u041f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a \u043e\u0431\u043e\u0440\u0443\u0434\u043e\u0432\u0430\u043d\u0438\u044f"), this.constraints);
        uploadSettings.add((Component)this.manufacturer, this.constraints);
        uploadSettings.add((Component)new JLabel("\u0412\u044b\u0431\u0440\u0430\u0442\u044c \u043c\u043e\u0434\u0443\u043b\u0438 \u0434\u043b\u044f \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0438"), this.constraints);
        JScrollPane tableScrollPane = new JScrollPane((Component)this.table);
        Dimension dimension = new Dimension(375, 180);
        tableScrollPane.setMinimumSize(dimension);
        tableScrollPane.setPreferredSize(dimension);
        uploadSettings.add((Component)tableScrollPane, this.constraints);
        uploadSettings.add((Component)this.additionalUploadFiles, this.constraints);
        uploadSettings.add(Box.createGlue(), this.constraints);
        this.constraints.weighty = 1.0;
        return uploadSettings;
    }

    private JPanel getButtonPanel() {
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        buttonPanel.add((Component)this.save, new GridBagConstraints(0, 0, 1, 1, 0.5, 0.5, 17, 2, new Insets(0, 0, 0, 3), 0, 0));
        buttonPanel.add((Component)this.cancel, new GridBagConstraints(1, 0, 1, 1, 0.5, 0.5, 17, 2, new Insets(0, 3, 0, 0), 0, 0));
        return buttonPanel;
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionNew((AbstractBGUPanel)this, e -> {
            this.sormProject = new SormProject();
            this.projectIdLabel.setText("");
            this.projectTitleLabel.setText("");
            this.comment.setText("");
            this.fileTransferConfigurePanel.refresh(null);
            this.adminEmail.setText("");
            this.manufacturer.setSelectedIndex(-1);
            this.tableModel.getRows().forEach(m -> m.setSelected(false));
            this.table.repaint();
            this.additionalUploadFiles.setData(null);
            this.performAction(CREATE_UPLOAD_PANEL);
        });
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> {
            if (this.sormProject == null) {
                return;
            }
            Preferences config = this.sormProject.getLoadedConfig();
            this.projectTitleLabel.setText(this.sormProject.getTitle());
            this.comment.setText(this.sormProject.getComment());
            this.fileTransferConfigurePanel.refresh(config);
            this.adminEmail.setText(config.get("sorm.report.email"));
            this.projectIdLabel.setText("ID \u043f\u0440\u043e\u0435\u043a\u0442\u0430: " + this.sormProject.getId());
            SormManufacturer sormManufacturer = SormManufacturer.getType((int)Utils.parseInt((String)config.get("sorm.manufacturer"), (int)0));
            this.manufacturer.setSelectedItem((Object)sormManufacturer);
            List uploadModules = this.getService().getInstalledSormModules();
            if (Utils.notEmptyCollection((Collection)uploadModules)) {
                List selectedIds = Utils.toList((String)config.get("sorm.upload.modules"), (String)",");
                uploadModules.stream().filter(m -> selectedIds.contains(String.valueOf(m.getModuleId()))).forEach(m -> m.setSelected(true));
                this.tableModel.setData(uploadModules);
            }
            this.additionalUploadFiles.setData(config);
            this.performAction(CREATE_UPLOAD_PANEL);
        });
    }

    private void createUploadPanel() {
        SormManufacturer sormManufacturer = (SormManufacturer)this.manufacturer.getSelectedItem();
        if (sormManufacturer == null) {
            sormManufacturer = SormManufacturer.VASEXPERTS;
        }
        this.abonentsConfigurePanel = ConfigurePanelFactory.getAbonentsConfigurePanel(this, sormManufacturer, this.sormProject);
        this.directoryConfigurePanel = ConfigurePanelFactory.getDirectoryConfigurePanel(this, sormManufacturer, this.sormProject);
        this.cdrConfigurePanel = ConfigurePanelFactory.getCDRConfigurePanel(this, sormManufacturer, this.sormProject);
        this.rightPanel.removeAll();
        JScrollPane abonentsScrollPane = new JScrollPane((Component)((Object)this.abonentsConfigurePanel));
        abonentsScrollPane.getVerticalScrollBar().setUnitIncrement(35);
        this.rightPanel.addTab("\u0412\u044b\u0433\u0440\u0443\u0437\u043a\u0430 \u0430\u0431\u043e\u043d\u0435\u043d\u0442\u043e\u0432", abonentsScrollPane);
        JScrollPane directoryScrollPane = new JScrollPane((Component)((Object)this.directoryConfigurePanel));
        directoryScrollPane.getVerticalScrollBar().setUnitIncrement(35);
        this.rightPanel.addTab("\u0421\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0438", directoryScrollPane);
        if (this.cdrConfigurePanel != null) {
            JScrollPane cdrScrollPane = new JScrollPane((Component)((Object)this.cdrConfigurePanel));
            cdrScrollPane.getVerticalScrollBar().setUnitIncrement(35);
            this.rightPanel.addTab("CDR(\u043c\u043e\u0434\u0443\u043b\u044c Voice)", cdrScrollPane);
        }
        this.rightPanel.repaint();
        this.rightPanel.revalidate();
        this.abonentsConfigurePanel.setSormProject(this.sormProject);
        this.abonentsConfigurePanel.performAction("refresh");
        this.directoryConfigurePanel.setSormProject(this.sormProject);
        this.directoryConfigurePanel.performAction("refresh");
        if (this.cdrConfigurePanel != null) {
            this.cdrConfigurePanel.setSormProject(this.sormProject);
            this.cdrConfigurePanel.performAction("refresh");
        }
    }

    private void updateSormConfig() {
        if (Utils.isBlankString((String)this.projectTitleLabel.getText())) {
            ClientUtils.showErrorMessageDialog((String)"\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043f\u0443\u0441\u0442\u044b\u043c!");
            return;
        }
        SormManufacturer selectedManufacturer = (SormManufacturer)this.manufacturer.getSelectedItem();
        if (selectedManufacturer == null) {
            ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a\u0430 \u043e\u0431\u043e\u0440\u0443\u0434\u043e\u0432\u0430\u043d\u0438\u044f!");
            return;
        }
        if (this.tableModel.getRows().stream().noneMatch(InstalledInstanceModule::isSelected)) {
            ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043c\u043e\u0434\u0443\u043b\u0438 \u0434\u043b\u044f \u0440\u0430\u0431\u043e\u0442\u044b \u0441 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u043e\u0439!");
            return;
        }
        if (this.sormProject == null || this.sormProject.getId() <= 0) {
            this.sormProject = new SormProject();
        }
        this.sormProject.setConfig(this.buildConfig().toString());
        this.sormProject.setComment(this.comment.getText());
        this.sormProject.setTitle(this.projectTitleLabel.getText());
        this.sormProject.setComment(this.comment.getText());
        this.sormProject.setProjectType(selectedManufacturer.ordinal());
        try {
            int id = this.getService().updateSormProject(this.sormProject);
            this.sormProject.setId(id);
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((String)("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u043f\u0440\u043e\u0435\u043a\u0442\u0430: " + String.valueOf(ex)));
            return;
        }
        BGToolTip.showMessage((JComponent)this.save, (String)"\u0421\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u043e!");
    }

    private Preferences buildConfig() {
        Preferences preferences = new Preferences();
        this.fileTransferConfigurePanel.buildConfig(preferences);
        preferences.set("sorm.report.email", this.adminEmail.getText());
        preferences.set("sorm.manufacturer", this.manufacturer.getSelectedIndex() >= 0 ? String.valueOf(((SormManufacturer)this.manufacturer.getSelectedItem()).ordinal()) : "");
        List selectedIds = this.tableModel.getRows().stream().filter(InstalledInstanceModule::isSelected).mapToInt(InstalledInstanceModule::getModuleId).boxed().collect(Collectors.toList());
        preferences.set("sorm.upload.modules", Utils.toString(selectedIds, (String)","));
        this.abonentsConfigurePanel.buildConfig(preferences);
        this.directoryConfigurePanel.buildConfig(preferences);
        this.additionalUploadFiles.buildConfig(preferences);
        if (this.cdrConfigurePanel != null) {
            this.cdrConfigurePanel.buildConfig(preferences);
        }
        return preferences;
    }

    private SormService getService() {
        if (this.sormService == null) {
            this.sormService = (SormService)((ClientContext)this.getContext()).getPort(SormService.class);
        }
        return this.sormService;
    }

    public void setSormProject(SormProject sormProject) {
        this.sormProject = sormProject;
    }

    class FileTransferConfigurePanel
    extends JPanel {
        BGUComboBox<GuiTitlable> protocol = new BGUComboBox();
        JTextField host = new JTextField();
        JTextField port = new JTextField();
        JTextField login = new JTextField();
        JPasswordField pass = new JPasswordField();
        BGUComboBox<IdTitle> ftpMode = new BGUComboBox();
        JTextField localDirectory = new JTextField();
        JCheckBox deleteLocalFilesAfterUpload = new JCheckBox("\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u043b\u043e\u043a\u0430\u043b\u044c\u043d\u044b\u0435 \u0444\u0430\u0439\u043b\u044b \u043f\u043e\u0441\u043b\u0435 \u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0438? ");
        JTextField ftpDirectory = new JTextField();
        JCheckBox enableUploadToFTP = new JCheckBox("\u0412\u043a\u043b\u044e\u0447\u0438\u0442\u044c \u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0443 \u0444\u0430\u0439\u043b\u043e\u0432 \u043d\u0430 \u0443\u0434\u0430\u043b\u0435\u043d\u043d\u044b\u0439 \u0441\u0435\u0440\u0432\u0435\u0440?");

        FileTransferConfigurePanel() {
            this.setLayout(new GridBagLayout());
            BGSwingUtilites.wrapBorder((JPanel)this, (String)"\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0430 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u044f \u043a \u0443\u0434\u0430\u043b\u0435\u043d\u043d\u043e\u043c\u0443 \u0441\u0435\u0440\u0432\u0435\u0440\u0443");
            JLabel helpFtpLabel = BGSwingUtilites.createHelpLabel((String)"\u0415\u0441\u043b\u0438 \u043e\u0441\u0442\u0430\u0432\u0438\u0442\u044c \u0434\u0430\u043d\u043d\u043e\u0435 \u043f\u043e\u043b\u0435 \u043f\u0443\u0441\u0442\u044b\u043c, \u0442\u043e \u0444\u0430\u0439\u043b\u044b \u0431\u0443\u0434\u0443 \u0432\u044b\u0433\u0440\u0443\u0436\u0435\u043d\u044b \u043f\u043e \u043f\u0440\u0435\u0434\u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043d\u044b\u043c \u043f\u0443\u0442\u044f\u043c. \u0414\u043b\u044f \u043d\u0435\u043a\u043e\u0442\u043e\u0440\u044b\u0445 \u043f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a\u043e\u0432 \u043a\u0430\u0442\u0430\u043b\u043e\u0433 \u0434\u043b\u044f \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0438 \u043c\u0435\u043d\u044f\u0435\u0442\u0441\u044f \u0432 \u0437\u0430\u0432\u0438\u0441\u0438\u043c\u043e\u0441\u0442\u0438 \u043e\u0442 \u0444\u0430\u0439\u043b\u0430, \u0432 \u0442\u0430\u043a\u043e\u043c \u0441\u043b\u0443\u0447\u0430\u0435 \u0434\u0430\u043d\u043d\u043e\u0435 \u043f\u043e\u043b\u0435 \u0441\u043b\u0435\u0434\u0443\u0435\u0442 \u043e\u0441\u0442\u0430\u0432\u043b\u044f\u0442\u044c \u043f\u0443\u0441\u0442\u044b\u043c.", (int)-1);
            this.ftpMode.addItem((Object)new IdTitle(0, "\u041f\u0430\u0441\u0441\u0438\u0432\u043d\u044b\u0439"));
            this.ftpMode.addItem((Object)new IdTitle(1, "\u0410\u043a\u0442\u0438\u0432\u043d\u044b\u0439"));
            this.protocol.setData(List.of(() -> "FTP", () -> "SFTP"));
            this.protocol.setSelectedIndex(0);
            this.add((Component)new JLabel("\u0425\u043e\u0441\u0442"), SormSettingsPanel.this.constraints);
            this.add((Component)this.host, SormSettingsPanel.this.constraints);
            this.add((Component)new JLabel("\u041f\u043e\u0440\u0442"), SormSettingsPanel.this.constraints);
            this.add((Component)this.port, SormSettingsPanel.this.constraints);
            this.add((Component)new JLabel("\u041b\u043e\u0433\u0438\u043d"), SormSettingsPanel.this.constraints);
            this.add((Component)this.login, SormSettingsPanel.this.constraints);
            this.add((Component)new JLabel("\u041f\u0430\u0440\u043e\u043b\u044c"), SormSettingsPanel.this.constraints);
            this.add((Component)this.pass, SormSettingsPanel.this.constraints);
            this.add((Component)new JLabel("\u0420\u0435\u0436\u0438\u043c \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u044f"), SormSettingsPanel.this.constraints);
            this.add((Component)this.ftpMode, SormSettingsPanel.this.constraints);
            this.add((Component)new JLabel("\u041a\u0430\u0442\u0430\u043b\u043e\u0433 \u043d\u0430 \u0443\u0434\u0430\u043b\u0435\u043d\u043d\u043e\u043c \u0441\u0435\u0440\u0432\u0435\u0440\u0435"), SormSettingsPanel.this.constraints);
            this.add((Component)helpFtpLabel, new GridBagConstraints(0, 10, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 0, 3), 0, 0));
            this.add((Component)this.ftpDirectory, SormSettingsPanel.this.constraints);
            this.add((Component)new JLabel("\u041a\u0430\u0442\u0430\u043b\u043e\u0433 \u043d\u0430 \u043b\u043e\u043a\u0430\u043b\u044c\u043d\u043e\u043c \u0441\u0435\u0440\u0432\u0435\u0440\u0435"), SormSettingsPanel.this.constraints);
            this.add((Component)this.localDirectory, SormSettingsPanel.this.constraints);
            this.add((Component)this.enableUploadToFTP, SormSettingsPanel.this.constraints);
            this.add((Component)this.deleteLocalFilesAfterUpload, SormSettingsPanel.this.constraints);
            this.add((Component)new JLabel("\u041f\u0440\u043e\u0442\u043e\u043a\u043e\u043b \u043f\u0435\u0440\u0435\u0434\u0430\u0447\u0438 \u0444\u0430\u0439\u043b\u043e\u0432"), SormSettingsPanel.this.constraints);
            this.add((Component)this.protocol, SormSettingsPanel.this.constraints);
            this.deleteLocalFilesAfterUpload.setHorizontalTextPosition(2);
            this.deleteLocalFilesAfterUpload.setFont(SormSettingsPanel.this.comboBoxFont);
            this.enableUploadToFTP.setHorizontalTextPosition(2);
            this.enableUploadToFTP.setFont(SormSettingsPanel.this.comboBoxFont);
        }

        private void buildConfig(Preferences config) {
            config.set("sorm.ftp.upload.enable", this.enableUploadToFTP.isSelected() ? "1" : "0");
            config.set("sorm.file.transfer.protocol", this.protocol.getSelectedItem().getGuiTitle().equals("FTP") ? "0" : "1");
            config.set("sorm.ftp.host", this.host.getText());
            config.set("sorm.ftp.port", this.port.getText());
            config.set("sorm.ftp.login", this.login.getText());
            config.set("sorm.ftp.password", this.pass.getText());
            config.set("sorm.ftp.mode", String.valueOf(((IdTitle)this.ftpMode.getSelectedItem()).getId()));
            config.set("sorm.local.catalog", this.localDirectory.getText());
            config.set("sorm.upload.deletelocalfiles", this.deleteLocalFilesAfterUpload.isSelected() ? "1" : "0");
            config.set("sorm.ftp.catalog", Utils.isBlankString((String)this.ftpDirectory.getText()) ? "" : this.ftpDirectory.getText());
        }

        private void refresh(Preferences config) {
            this.protocol.setSelectedIndex(config != null && config.get("sorm.file.transfer.protocol") != null && config.get("sorm.file.transfer.protocol").equals("1") ? 1 : 0);
            this.enableUploadToFTP.setSelected(config != null && config.getInt("sorm.ftp.upload.enable", -1) == 1);
            this.host.setText(config != null ? config.get("sorm.ftp.host") : "");
            this.port.setText(config != null ? config.get("sorm.ftp.port") : "");
            this.login.setText(config != null ? config.get("sorm.ftp.login") : "");
            this.pass.setText(config != null ? config.get("sorm.ftp.password") : "");
            int mode = 0;
            if (config != null) {
                mode = Utils.parseInt((String)config.get("sorm.ftp.mode"), (int)0);
            }
            this.ftpMode.setSelectedIndex(mode);
            this.ftpDirectory.setText(config != null ? config.get("sorm.ftp.catalog") : "");
            this.localDirectory.setText(config != null ? config.get("sorm.local.catalog") : "");
            this.deleteLocalFilesAfterUpload.setSelected(config != null && config.getInt("sorm.upload.deletelocalfiles", -1) == 1);
        }
    }
}

