/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.payture.server.servlet;

import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.util.Date;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.base.server.CommonExecutor;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Charge;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Payment;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.ChargeDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.PaymentDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.ChargeEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.ContractBalanceChangedEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.PaymentEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.payture.common.bean.Transaction;
import ru.bitel.bgbilling.modules.payture.common.bean.TransactionStatus;
import ru.bitel.bgbilling.modules.payture.server.bean.TransactionManager;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;

@WebServlet(name="PaytureExecutor", urlPatterns={"/payture/*"})
public class ModuleExecutor
extends CommonExecutor {
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Connection con = null;
        try {
            int moduleId = 0;
            TransactionManager transactionManager = null;
            con = Setup.getSetup().getDBConnectionFromPool();
            this.getLogger().debug("\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 mid \u0438\u0437 \u0441\u0442\u0440\u043e\u043a\u0438 \u0437\u0430\u043f\u0440\u043e\u0441\u0430");
            try {
                moduleId = ModuleExecutor.getModuleId((HttpServletRequest)request);
                transactionManager = new TransactionManager(con, moduleId);
            }
            catch (BGMessageException ex) {
                this.logError((Exception)((Object)ex));
            }
            ModuleSetup moduleSetup = Setup.getSetup().getModuleSetup(Integer.valueOf(moduleId));
            String orderid = request.getParameter("OrderId");
            int pos = -1;
            int contractId = 0;
            if (orderid != null && (pos = orderid.indexOf(95)) > -1) {
                contractId = Utils.parseInt((String)orderid.substring(0, pos - 1));
                orderid = pos < orderid.length() - 1 ? orderid.substring(pos + 1) : "";
            }
            String notification = request.getParameter("Notification");
            String success = request.getParameter("Success");
            Transaction transaction = transactionManager.get(Utils.parseInt((String)orderid));
            if ("EnginePaySuccess".equals(notification) && transaction == null && contractId > 0) {
                transaction = new Transaction().setContractId(contractId).setTransactionDate(new Date()).setStatus(TransactionStatus.NEW.getCode()).setSum(Utils.parseBigDecimal((String)request.getParameter("Amount"), (BigDecimal)BigDecimal.ZERO).setScale(2).multiply(new BigDecimal(100)));
                transactionManager.update(transaction);
                success = "True";
            }
            if (transaction != null && notification != null && success != null) {
                BalanceUtils balanceUtils;
                if (transaction.getStatus().equals(TransactionStatus.NEW.getCode()) && ("MerchantPay".equals(notification) || "EnginePaySuccess".equals(notification)) && success.equals("True")) {
                    transaction.setStatus(TransactionStatus.CHARGED.getCode());
                    transactionManager.update(transaction);
                    Payment payment = new Payment().setDate(transaction.getTransactionDate()).setTypeId(moduleSetup.getInt("payture.payment.type.id", 0)).setContractId(transaction.getContractId()).setSum(transaction.getSum()).setUserId(0).setModuleId(Integer.valueOf(moduleId)).setTransactionId(String.valueOf(transaction.getId())).setComment(moduleSetup.get("payture.payment.comment", "\u041e\u043f\u043b\u0430\u0442\u0430 \u0447\u0435\u0440\u0435\u0437 \u043f\u043b\u0430\u0442\u0435\u0436\u043d\u044b\u0439 \u0441\u0435\u0440\u0432\u0438\u0441 Payture [\u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u044f #{TRANSACTION_ID}]").replace("{TRANSACTION_ID}", String.valueOf(transaction.getId())));
                    new PaymentDao(con).update((Object)payment);
                    ServerUtils.commitConnection((Connection)con);
                    balanceUtils = new BalanceUtils(con);
                    try {
                        balanceUtils.updateBalance(transaction.getTransactionDate(), transaction.getContractId());
                    }
                    finally {
                        balanceUtils.close();
                    }
                    ServerUtils.commitConnection((Connection)con);
                    EventProcessor.getInstance().publish((Event)new PaymentEvent(0, payment));
                    EventProcessor.getInstance().publish((Event)new ContractBalanceChangedEvent(transaction.getContractId(), 3, payment.getSum()));
                    response.setStatus(200);
                }
                if (transaction.getStatus().equals(TransactionStatus.CHARGED.getCode()) && notification.contains("MerchantRefund") && success.equals("True")) {
                    transaction.setStatus(TransactionStatus.REFUNDED.getCode());
                    transactionManager.update(transaction);
                    Charge charge = new Charge().setDate(new Date()).setTypeId(moduleSetup.getInt("payture.charge.type.id", 0)).setComment(moduleSetup.get("payture.charge.comment", "\u0412\u043e\u0437\u0432\u0440\u0430\u0442 \u0434\u0435\u043d\u0435\u0433 \u0438\u0437 \u043f\u043b\u0430\u0442\u0435\u0436\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u044b [\u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u044f #{TRANSACTION_ID}]").replace("{TRANSACTION_ID}", String.valueOf(transaction.getId()))).setContractId(transaction.getContractId()).setSum(transaction.getSum()).setUserId(0);
                    new ChargeDao(con).update((Object)charge);
                    ServerUtils.commitConnection((Connection)con);
                    balanceUtils = new BalanceUtils(con);
                    balanceUtils.updateBalance(new Date(), transaction.getContractId());
                    balanceUtils.close();
                    ServerUtils.commitConnection((Connection)con);
                    EventProcessor.getInstance().publish((Event)new ChargeEvent(0, charge));
                    EventProcessor.getInstance().publish((Event)new ContractBalanceChangedEvent(transaction.getContractId(), 4, charge.getSum()));
                    response.setStatus(200);
                }
            }
            ServerUtils.commitConnection((Connection)con);
        }
        catch (Exception ex) {
            try {
                this.logError(ex);
            }
            catch (Throwable throwable) {
                ServerUtils.closeConnection(con);
                throw throwable;
            }
            ServerUtils.closeConnection((Connection)con);
        }
        ServerUtils.closeConnection((Connection)con);
    }
}

