/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.bonus.client;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.border.Border;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.client.common.BGControlPanelListSelect;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.model.BGUListItem;
import ru.bitel.bgbilling.kernel.contract.pattern.client.PatternPluginTabPanel;
import ru.bitel.bgbilling.plugins.bonus.common.bean.BonusProgram;
import ru.bitel.bgbilling.plugins.bonus.common.service.BonusService;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;

public class PatternPluginTabPanelItemFactory
implements PatternPluginTabPanel.PatternPluginTabPanelItemFactory {
    public Collection<PatternPluginTabPanel.PatternPluginTabPanelItem> getPatternPluginTabPanelItems(int pid, String pluginTitle) {
        return Collections.singleton(new BonusPanel(pid, pluginTitle));
    }

    private class BonusPanel
    extends PatternPluginTabPanel.PatternPluginTabPanelItem {
        private JCheckBox turnOnOff;
        private BGControlPanelListSelect programListSelect;
        private List<BonusProgram> programList;
        private final ClientContext context;

        public BonusPanel(int pid, String pluginTitle) {
            super((LayoutManager)new GridBagLayout());
            this.turnOnOff = new JCheckBox("\u0412\u043a\u043b\u044e\u0447\u0435\u043d", false);
            this.programListSelect = new BGControlPanelListSelect();
            this.context = new ClientContext("ru.bitel.bgbilling.plugins.bonus", 0, 0, 0, ((Object)((Object)this)).getClass().getPackage());
        }

        protected void init() {
            this.programListSelect.setBorder((Border)new BGTitleBorder(" \u0411\u043e\u043d\u0443\u0441\u043d\u044b\u0435 \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u044b "));
            this.add(this.turnOnOff, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
            this.add((Component)this.programListSelect, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 5, 0, 5), 0, 0));
            this.add(Box.createVerticalGlue(), new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 5, 0, 5), 0, 0));
        }

        protected boolean isItemEnabled() {
            return false;
        }

        protected void setData(Element element) {
            try {
                this.programList = ((BonusService)this.context.getPort(BonusService.class)).programList(new Date());
                this.setProgramInListSelect();
                Element bonus = XMLUtils.selectElement((Node)element, (String)"data/plugins/bonus");
                if (bonus != null) {
                    this.turnOnOff.setSelected(Utils.parseBoolean((String)bonus.getAttribute("include")));
                    Element addBonusProgram = XMLUtils.selectElement((Node)element, (String)"data/plugins/bonus/addBonusProgram");
                    ArrayList<String> idList = new ArrayList<String>();
                    if (addBonusProgram != null) {
                        for (Element item : XMLUtils.selectElements((Node)addBonusProgram, (String)"program")) {
                            idList.add(item.getAttribute("programId"));
                        }
                    }
                    this.programListSelect.setListValues(Utils.toString(idList));
                }
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        }

        protected void reset() {
        }

        protected void serialise(Element element) {
            Document doc = element.getOwnerDocument();
            Element bonus = doc.createElement("bonus");
            element.appendChild(bonus);
            bonus.setAttribute("include", String.valueOf(this.turnOnOff.isSelected()));
            Element addBonusProgram = doc.createElement("addBonusProgram");
            bonus.appendChild(addBonusProgram);
            for (BGUListItem item : this.programListSelect.getList().getData()) {
                if (!item.isSelected()) continue;
                Element program = XMLUtils.createElement((Element)addBonusProgram, (String)"program");
                program.setAttribute("programId", String.valueOf(item.getId()));
            }
        }

        public String getTitle() {
            return "\u0432\u043a\u043b/\u0432\u044b\u043a\u043b \u043f\u043b\u0430\u0433\u0438\u043d\u0430, \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u044b";
        }

        private void setProgramInListSelect() {
            this.programListSelect.getList().setData(this.programList.stream().map(a -> new BGUListItem(a.getId(), a.getTitle(), false)).toList());
        }
    }
}

