/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.wifi.dhcp;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.kernel.wifi.GlobalConfig;
import ru.bitel.bgbilling.kernel.wifi.dhcp.DHCPChecker;
import ru.bitel.bgbilling.kernel.wifi.dhcp.DHCPListener;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.logging.BGNestedContext;

public class RelayAgent
extends Thread {
    public static final String DHCP_LOG_NAME = "dhcp";
    private static Logger log = LogManager.getLogger();
    public static final int SERVER_PORT = 67;
    public static final int CLIENT_PORT = 68;

    @Override
    public void run() {
        BGNestedContext.push((String)DHCP_LOG_NAME);
        log.info("Starting DHCP Relay agent...");
        DHCPChecker checker = new DHCPChecker();
        DHCPListener listener = new DHCPListener();
        listener.init(67, checker);
        listener.start();
        Setup setup = GlobalConfig.getGlobalConfig().getSetup();
        int serverPort = setup.getInt("dhcp.server.port", 67);
        if (serverPort != 67) {
            listener = new DHCPListener();
            listener.init(serverPort, checker);
            listener.start();
        }
        checker.start();
        BGNestedContext.pop();
    }
}

