/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.module.common.bean;

import jakarta.xml.bind.annotation.XmlAttribute;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import ru.bitel.bgbilling.kernel.module.common.enums.ComponentType;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.model.IdTitle;

public class BGInstalledModule
extends IdTitle {
    private boolean enabled = true;
    private ComponentType type;
    private String name;
    private String version;
    private String packageClient;
    private String packageServer;
    private String build;
    private Map<String, Element> clientExtensionMap;
    private Map<String, Element> serverExtensionMap;

    @XmlAttribute
    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @XmlAttribute
    public ComponentType getType() {
        return this.type;
    }

    public BGInstalledModule setType(ComponentType type) {
        this.type = type;
        return this;
    }

    @XmlAttribute
    public String getName() {
        return this.name;
    }

    public BGInstalledModule setName(String name) {
        this.name = name;
        return this;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @XmlAttribute
    public String getPackageClient() {
        return this.packageClient;
    }

    public void setPackageClient(String packageClient) {
        this.packageClient = packageClient;
    }

    @XmlAttribute
    public String getPackageServer() {
        return this.packageServer;
    }

    public BGInstalledModule setPackageServer(String packageServer) {
        this.packageServer = packageServer;
        return this;
    }

    public String getBuild() {
        return this.build;
    }

    public BGInstalledModule setBuild(String build) {
        this.build = build;
        return this;
    }

    private void setDocument(Document document) throws Exception {
        Element rootElement = document.getDocumentElement();
        this.name = rootElement.getAttribute("name");
        this.version = rootElement.getAttribute("version");
        for (Element extension : XMLUtils.selectElements(document.getDocumentElement(), "/module/extension")) {
            String point = extension.getAttribute("point");
            if (!Utils.notBlankString(point)) continue;
            this.serverExtensionMap.put(point, extension);
        }
    }

    public Map<String, Element> getServerExtensionMap() {
        if (this.serverExtensionMap != null) {
            return this.serverExtensionMap;
        }
        this.serverExtensionMap = new HashMap<String, Element>();
        this.doLoadServerModuleXml();
        return this.serverExtensionMap;
    }

    public Map<String, Element> getClientExtensionMap() throws Exception {
        if (this.clientExtensionMap != null) {
            return this.clientExtensionMap;
        }
        this.clientExtensionMap = new HashMap<String, Element>();
        InputStream moduleXml = this.getInputStream(this.packageClient);
        if (moduleXml != null) {
            Document document = XMLUtils.parseDocument(new InputSource(moduleXml));
            for (Element extension : XMLUtils.selectElements(document.getDocumentElement(), "/module/extension")) {
                String point = extension.getAttribute("point");
                if (point == null || point.trim().length() <= 0) continue;
                this.clientExtensionMap.put(point, extension);
            }
        }
        return this.clientExtensionMap;
    }

    private void doLoadServerModuleXml() {
        InputStream moduleXml = this.getInputStream(this.packageServer);
        if (moduleXml != null) {
            try {
                this.setDocument(XMLUtils.parseDocument(new InputSource(moduleXml)));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private InputStream getInputStream(String packageName) {
        InputStream moduleXml = null;
        try {
            moduleXml = BGInstalledModule.class.getResourceAsStream("/" + packageName.replace('.', '/') + "/module.xml");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return moduleXml;
    }

    @Override
    public BGInstalledModule setTitle(String title) {
        super.setTitle(title);
        return this;
    }
}

