/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.kernel.entity.common.bean;

import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.bitel.common.model.IdTitle;
import ru.bitel.oss.kernel.entity.common.bean.enums.EntitySpecAttrType;

public class AbstractSpecAttr
extends IdTitle {
    private int type;
    private boolean history;
    private String comment;

    @XmlElement
    public String getComment() {
        return this.comment;
    }

    @XmlAttribute
    public int getType() {
        return this.type;
    }

    public String getTypeName() {
        return this.getTypeName(this.type);
    }

    public String getTypeName(int type) {
        return EntitySpecAttrType.optEntitySpecAttrType(type).map(a -> a.getTypeName()).orElse("unknown");
    }

    @XmlAttribute
    public boolean isHistory() {
        return this.history;
    }

    public AbstractSpecAttr setComment(String comment) {
        this.comment = comment;
        return this;
    }

    public AbstractSpecAttr setHistory(boolean history) {
        this.history = history;
        return this;
    }

    public AbstractSpecAttr setType(int type) {
        this.type = type;
        return this;
    }

    public static <A extends AbstractSpecAttr> Map<Integer, List<A>> toTypeMap(List<A> entitySpecAttrList) {
        HashMap<Integer, List<A>> result = new HashMap<Integer, List<A>>();
        for (AbstractSpecAttr sa : entitySpecAttrList) {
            ArrayList<AbstractSpecAttr> list = (ArrayList<AbstractSpecAttr>)result.get(sa.getType());
            if (list == null) {
                list = new ArrayList<AbstractSpecAttr>();
                result.put(sa.getType(), list);
            }
            list.add(sa);
        }
        return result;
    }
}

