/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.admin;

import bitel.billing.module.common.TransferData;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import org.json.JSONObject;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import ru.bitel.bgbilling.client.runner.BGClientRunnerCipher;
import ru.bitel.bgbilling.client.runner.BGClientRunnerDbInfo;
import ru.bitel.common.Preferences;
import ru.bitel.common.model.GuiTitlable;

public class DBInfo
extends BGClientRunnerDbInfo
implements GuiTitlable {
    private String dbServerEmail = null;
    private TransferData transferData = null;
    private Node menuBarNode = null;
    private Node toolBarNode = null;
    private Node paramsNode = null;
    private Node modulesNode = null;
    private Node pluginsNode = null;
    private TimeZone timeZone = null;
    private boolean localItem = false;
    private boolean saveAccount = false;
    private String firmTitle;
    private String serverVersion;
    private String user;

    public DBInfo() {
    }

    public DBInfo(DBInfo info) {
        this.setDbServerKey(info.getDbServerKey());
        this.setDbServerTitle(info.getDbServerTitle());
        this.setDbServerURL(info.getDbServerURL());
        this.setDbServerProxyHost(info.getDbServerProxyHost());
        this.setDbServerProxyPort(info.getDbServerProxyPort());
        this.setDbServerLogin(info.getDbServerLogin());
        this.setDbServerPassword(info.getDbServerPassword());
        this.dbServerEmail = info.dbServerEmail;
        this.transferData = info.transferData;
        this.menuBarNode = info.menuBarNode;
        this.toolBarNode = info.toolBarNode;
        this.paramsNode = info.paramsNode;
        this.modulesNode = info.modulesNode;
        this.pluginsNode = info.pluginsNode;
        this.setLocalItem(info.isLocalItem());
        this.saveAccount = info.saveAccount;
        this.setFavorite(info.isFavorite());
    }

    private void createTransferData() {
        try {
            this.transferData = new TransferData(URI.create(this.getDbServerURL()).toURL());
            this.transferData.setUser(this.getDbServerLogin(), this.getDbServerPassword());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getDbServerEmail() {
        return this.dbServerEmail;
    }

    public String getFirmTitle() {
        return this.firmTitle;
    }

    @Override
    public String getGuiTitle() {
        return this.getDbServerTitle();
    }

    public Node getMenuBarNode() {
        return this.menuBarNode;
    }

    public Map<String, Preferences> getModulesParamsMap() {
        return this.getModulesParamsMap(true);
    }

    private Map<String, Preferences> getModulesParamsMap(boolean isModule) {
        Node node = isModule ? this.modulesNode : this.pluginsNode;
        String elementsByTagName = isModule ? "module" : "plugin";
        HashMap<String, Preferences> resultMap = new HashMap<String, Preferences>();
        Element modulesElement = (Element)node;
        if (node != null && node.hasChildNodes()) {
            NodeList list = modulesElement.getElementsByTagName(elementsByTagName);
            for (int index = 0; index < list.getLength(); ++index) {
                NodeList listParam = ((Element)list.item(index)).getElementsByTagName("param");
                HashMap<String, String> paramsMap = new HashMap<String, String>();
                for (int paramIndex = 0; paramIndex < listParam.getLength(); ++paramIndex) {
                    Element element = (Element)listParam.item(paramIndex);
                    paramsMap.put(element.getAttribute("key"), element.getAttribute("value"));
                }
                resultMap.put(((Element)list.item(index)).getAttribute("id"), new Preferences(paramsMap));
            }
        }
        return resultMap;
    }

    public Map<String, String> getParamsMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        Element paramElement = (Element)this.paramsNode;
        if (this.paramsNode != null && this.paramsNode.hasChildNodes()) {
            NodeList list = paramElement.getElementsByTagName("param");
            for (int index = 0; index < list.getLength(); ++index) {
                Element element = (Element)list.item(index);
                map.put("dbinfo." + element.getAttribute("key"), element.getAttribute("value"));
            }
        }
        return map;
    }

    public Map<String, Preferences> getPluginsParamsMap() {
        return this.getModulesParamsMap(false);
    }

    public String getServerVersion() {
        return this.serverVersion;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public Node getToolBarNode() {
        return this.toolBarNode;
    }

    public TransferData getTransferData() {
        if (this.transferData == null) {
            this.createTransferData();
        }
        return this.transferData;
    }

    public String getUser() {
        return this.user;
    }

    public boolean isLocalItem() {
        return this.localItem;
    }

    @Override
    public boolean isSaveAccount() {
        return this.saveAccount;
    }

    public void setConnected(boolean connected) {
        if (connected) {
            this.createTransferData();
        } else {
            this.transferData = null;
        }
    }

    public DBInfo setDbServerEmail(String dbServerEmail) {
        this.dbServerEmail = dbServerEmail;
        return this;
    }

    public DBInfo setFirmTitle(String firmTitle) {
        this.firmTitle = firmTitle;
        return this;
    }

    public DBInfo setLocalItem(boolean localItem) {
        this.localItem = localItem;
        return this;
    }

    public DBInfo setMenuBarNode(Node node) {
        this.menuBarNode = node;
        return this;
    }

    public DBInfo setModulesNode(Node modulesNode) {
        this.modulesNode = modulesNode;
        return this;
    }

    public DBInfo setParamsNode(Node paramsNode) {
        this.paramsNode = paramsNode;
        return this;
    }

    public DBInfo setPluginsNode(Node pluginsNode) {
        this.pluginsNode = pluginsNode;
        return this;
    }

    @Override
    public DBInfo setSaveAccount(boolean saveAccount) {
        this.saveAccount = saveAccount;
        return this;
    }

    public DBInfo setServerVersion(String serverVersion) {
        this.serverVersion = serverVersion;
        return this;
    }

    public DBInfo setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
        return this;
    }

    public DBInfo setToolBarNode(Node node) {
        this.toolBarNode = node;
        return this;
    }

    public DBInfo setUser(String user) {
        this.user = user;
        return this;
    }

    @Override
    public DBInfo setDbServerKey(String dbServerKey) {
        super.setDbServerKey(dbServerKey);
        return this;
    }

    @Override
    public DBInfo setDbServerTitle(String dbServerTitle) {
        super.setDbServerTitle(dbServerTitle);
        return this;
    }

    @Override
    public DBInfo setDbServerURL(String dbServerURL) {
        super.setDbServerURL(dbServerURL);
        return this;
    }

    @Override
    public DBInfo setDbServerProxyHost(String dbServerProxyHost) {
        super.setDbServerProxyHost(dbServerProxyHost);
        return this;
    }

    @Override
    public DBInfo setDbServerProxyPort(String dbServerProxyPort) {
        super.setDbServerProxyPort(dbServerProxyPort);
        return this;
    }

    @Override
    public DBInfo setDbServerJavaHome(String dbServerJavaHome) {
        super.setDbServerJavaHome(dbServerJavaHome);
        return this;
    }

    public static DBInfo parseDBInfoFromJson(JSONObject dbInfoJSONObject) {
        DBInfo dbInfo = null;
        if (dbInfoJSONObject != null) {
            dbInfo = new DBInfo().setDbServerKey(dbInfoJSONObject.optString("key", "")).setDbServerTitle(dbInfoJSONObject.optString("title", "")).setDbServerURL(dbInfoJSONObject.optString("url", "")).setDbServerProxyHost(dbInfoJSONObject.optString("proxyHost", "")).setDbServerProxyPort(dbInfoJSONObject.optString("proxyPort", "")).setDbServerJavaHome(dbInfoJSONObject.optString("javaHome", "")).setSaveAccount(Boolean.valueOf(dbInfoJSONObject.optString("safe", "false")));
            String auth = dbInfoJSONObject.optString("auth", null);
            if (auth != null) {
                String[] loginPassword = BGClientRunnerCipher.cipher(auth, true).split("\t", -1);
                dbInfo.setDbServerLogin(loginPassword[0]);
                dbInfo.setDbServerPassword(loginPassword[1]);
            }
        }
        return dbInfo;
    }
}

