/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.client.runner;

import ru.bitel.bgbilling.client.runner.BGClientRunnerCipher;
import ru.bitel.bgbilling.client.runner.json.JSONObject;

public class BGClientRunnerDbInfo {
    protected static final String KEY_KEY = "key";
    protected static final String KEY_FAVORITE = "favorite";
    protected static final String KEY_SAVEACCOUNT = "safe";
    protected static final String KEY_JAVA_HOME = "javaHome";
    protected static final String KEY_PROXY_PORT = "proxyPort";
    protected static final String KEY_PROXY_HOST = "proxyHost";
    protected static final String KEY_AUTH = "auth";
    protected static final String KEY_URL = "url";
    protected static final String KEY_TITLE = "title";
    protected static final String KEY_TYPE = "type";
    protected static final String KEY_VM_ARGS = "VMArgs";
    private String dbServerKey = null;
    private String dbServerTitle = null;
    private String dbServerURL = null;
    private String dbServerJavaHome = null;
    private String dbServerProxyHost = null;
    private String dbServerProxyPort = null;
    private String dbServerLogin = null;
    private String dbServerPassword = null;
    private String dbServerType = null;
    private String dbServerVMArgs = null;
    private boolean favorite = false;
    private boolean saveAccount = false;

    public void setProxy() {
        System.getProperties().setProperty("proxySet", "false");
        if (this.dbServerProxyHost != null && this.dbServerProxyHost.trim().length() > 0 && this.dbServerProxyPort != null && this.dbServerProxyPort.trim().length() > 0) {
            System.getProperties().put("proxySet", "true");
            System.getProperties().put(KEY_PROXY_HOST, this.dbServerProxyHost);
            System.getProperties().put(KEY_PROXY_PORT, this.dbServerProxyPort);
        }
    }

    public String getDbServerKey() {
        return this.dbServerKey;
    }

    public BGClientRunnerDbInfo setDbServerKey(String dbServerKey) {
        this.dbServerKey = dbServerKey;
        return this;
    }

    public String getDbServerTitle() {
        return this.dbServerTitle;
    }

    public BGClientRunnerDbInfo setDbServerTitle(String dbServerTitle) {
        this.dbServerTitle = dbServerTitle;
        return this;
    }

    public String getDbServerURL() {
        return this.dbServerURL;
    }

    public BGClientRunnerDbInfo setDbServerURL(String dbServerURL) {
        this.dbServerURL = dbServerURL;
        return this;
    }

    public String getDbServerJavaHome() {
        return this.dbServerJavaHome;
    }

    public BGClientRunnerDbInfo setDbServerJavaHome(String dbServerJavaHome) {
        this.dbServerJavaHome = dbServerJavaHome;
        return this;
    }

    public String getDbServerProxyHost() {
        return this.dbServerProxyHost;
    }

    public BGClientRunnerDbInfo setDbServerProxyHost(String dbServerProxyHost) {
        this.dbServerProxyHost = dbServerProxyHost;
        return this;
    }

    public String getDbServerProxyPort() {
        return this.dbServerProxyPort;
    }

    public BGClientRunnerDbInfo setDbServerProxyPort(String dbServerProxyPort) {
        this.dbServerProxyPort = dbServerProxyPort;
        return this;
    }

    public String getDbServerLogin() {
        return this.dbServerLogin;
    }

    public BGClientRunnerDbInfo setDbServerLogin(String dbServerLogin) {
        this.dbServerLogin = dbServerLogin;
        return this;
    }

    public String getDbServerPassword() {
        return this.dbServerPassword;
    }

    public BGClientRunnerDbInfo setDbServerPassword(String dbServerPassword) {
        if (dbServerPassword == null) {
            dbServerPassword = "";
        }
        this.dbServerPassword = dbServerPassword.trim();
        return this;
    }

    public BGClientRunnerDbInfo setDbServerPassword(char[] dbServerPassword) {
        this.setDbServerPassword(dbServerPassword != null ? String.valueOf(dbServerPassword) : null);
        return this;
    }

    public boolean isFavorite() {
        return this.favorite;
    }

    public BGClientRunnerDbInfo setFavorite(boolean favorite) {
        this.favorite = favorite;
        return this;
    }

    public String getDbServerType() {
        return this.dbServerType;
    }

    public BGClientRunnerDbInfo setDbServerType(String dbServerType) {
        this.dbServerType = dbServerType;
        return this;
    }

    public String getDbServerVMArgs() {
        return this.dbServerVMArgs;
    }

    public BGClientRunnerDbInfo setDbServerVMArgs(String dbServerVMArgs) {
        this.dbServerVMArgs = dbServerVMArgs;
        return this;
    }

    public boolean isSaveAccount() {
        return this.saveAccount;
    }

    public BGClientRunnerDbInfo setSaveAccount(boolean saveAccount) {
        this.saveAccount = saveAccount;
        return this;
    }

    public String toString() {
        return this.getDbServerTitle() != null ? this.getDbServerTitle() : "-";
    }

    public static BGClientRunnerDbInfo parseBGClientRunnerDbInfoFromJson(JSONObject jsonObject) {
        BGClientRunnerDbInfo bgClientRunnerDbInfo = null;
        if (jsonObject != null) {
            bgClientRunnerDbInfo = new BGClientRunnerDbInfo().setDbServerKey(jsonObject.optString(KEY_KEY, "")).setDbServerTitle(jsonObject.optString(KEY_TITLE, "")).setDbServerURL(jsonObject.optString(KEY_URL, "")).setDbServerJavaHome(jsonObject.optString(KEY_JAVA_HOME, "")).setDbServerProxyHost(jsonObject.optString(KEY_PROXY_HOST, "")).setDbServerProxyPort(jsonObject.optString(KEY_PROXY_PORT, "")).setDbServerType(jsonObject.optString(KEY_TYPE, null)).setDbServerVMArgs(jsonObject.optString(KEY_VM_ARGS, "")).setFavorite(Boolean.valueOf(jsonObject.optString(KEY_FAVORITE, "false"))).setSaveAccount(Boolean.valueOf(jsonObject.optString(KEY_SAVEACCOUNT, "false")));
            String auth = jsonObject.optString(KEY_AUTH, null);
            if (auth != null) {
                String[] loginPassword = BGClientRunnerCipher.cipher(auth, true).split("\t", -1);
                bgClientRunnerDbInfo.setDbServerLogin(loginPassword[0]);
                bgClientRunnerDbInfo.setDbServerPassword(loginPassword[1]);
            }
        }
        return bgClientRunnerDbInfo;
    }

    public JSONObject toJsonObject() {
        JSONObject serverJSONObject = new JSONObject();
        serverJSONObject.put(KEY_KEY, this.getDbServerKey());
        serverJSONObject.put(KEY_TITLE, this.getDbServerTitle());
        serverJSONObject.put(KEY_URL, this.getDbServerURL());
        serverJSONObject.put(KEY_JAVA_HOME, this.getDbServerJavaHome());
        serverJSONObject.put(KEY_PROXY_HOST, this.getDbServerProxyHost());
        serverJSONObject.put(KEY_PROXY_PORT, this.getDbServerProxyPort());
        serverJSONObject.put(KEY_TYPE, this.getDbServerType());
        serverJSONObject.put(KEY_VM_ARGS, this.getDbServerVMArgs());
        serverJSONObject.put(KEY_FAVORITE, String.valueOf(this.isFavorite()));
        serverJSONObject.put(KEY_SAVEACCOUNT, String.valueOf(this.isSaveAccount()));
        if (this.isSaveAccount()) {
            serverJSONObject.put(KEY_AUTH, BGClientRunnerCipher.cipher(this.getDbServerLogin() + "\t" + this.getDbServerPassword(), false));
        }
        return serverJSONObject;
    }
}

