/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.reports.client.include;

import bitel.billing.module.admin.TransferManager;
import bitel.billing.module.common.CheckTree;
import bitel.billing.module.common.ModTreeNode;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import org.w3c.dom.Document;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.modules.reports.client.include.ReportFilter;
import ru.bitel.bgbilling.modules.reports.client.include.ReportFilterParameterName;
import ru.bitel.bgbilling.modules.reports.client.include.ReportFilterTitle;
import ru.bitel.bgbilling.modules.reports.client.include.ReportFilterTitleName;
import ru.bitel.bgbilling.modules.reports.client.include.SetData;
import ru.bitel.bgbilling.modules.reports.client.modules.kernel.ReportParams_Default;

@ReportFilterTitle(reportTitle="module")
public class RFModule
extends JPanel
implements ReportFilter,
SetData {
    @ReportFilterTitleName
    private String title;
    @ReportFilterParameterName
    private String paramName1;
    private int moduleId = -1;
    private ModTreeNode treeTopNode = new ModTreeNode();
    private CheckTree tree = new CheckTree(this.treeTopNode);
    private String nodeContent;

    public RFModule() {
        this("\u041c\u043e\u0434\u0443\u043b\u0438", "", "", 0);
    }

    public RFModule(String title, String name, String serializedNodeContent, int moduleId) {
        this.title = title;
        this.paramName1 = name;
        this.moduleId = moduleId;
        this.tree.setDefaultTree("\u0412\u0441\u0435 \u043c\u043e\u0434\u0443\u043b\u0438");
        this.setLayout(new GridBagLayout());
        this.setBorder((Border)new BGTitleBorder(title));
        this.add((Component)new JScrollPane((Component)this.tree), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.nodeContent = serializedNodeContent;
    }

    @Override
    public void putParams(Map<String, Object> params) {
        params.put(this.paramName1, this.tree.getCodes(true));
    }

    @Override
    public void setData(ReportParams_Default d) {
        Request request = new Request().setModule("reports").setModuleId(this.moduleId).setAction("GetModulesAndServicesTree").setAttribute("nodeContent", this.nodeContent);
        Document doc = TransferManager.getDocument((Request)request);
        if (ClientUtils.checkStatus((Document)doc)) {
            try {
                this.tree.setTreeFromDocument(doc, "//modules");
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        }
    }

    @Override
    public String getFilterTitle() {
        return "module";
    }

    @Override
    public String[] getFilterParameterNames() {
        return new String[]{this.paramName1};
    }

    public String getGuiTitle() {
        return this.title;
    }
}

