/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.yoomoney.server;

import bitel.billing.server.BGPaymentModule;
import bitel.billing.server.ModuleBase;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.bean.TransactionUtils;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.contract.autopayment.server.bean.AbstractAutopaymentManager;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Charge;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Payment;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.ChargeDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.PaymentEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.contract.function.server.bean.PaymentMethod;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.event.events.system.ContractCreateEvent;
import ru.bitel.bgbilling.kernel.event.events.system.ContractDeleteEvent;
import ru.bitel.bgbilling.kernel.module.common.bean.BGModule;
import ru.bitel.bgbilling.modules.yoomoney.common.bean.Transaction;
import ru.bitel.bgbilling.modules.yoomoney.server.bean.AutopaymentManager;
import ru.bitel.bgbilling.modules.yoomoney.server.bean.Constants;
import ru.bitel.bgbilling.modules.yoomoney.server.bean.TransactionManager;
import ru.bitel.bgbilling.modules.yoomoney.server.event.worker.YoomoneyAutopaymentEventWorker;
import ru.bitel.bgbilling.modules.yoomoney.server.event.worker.YoomoneyCheckEventWorker;
import ru.bitel.bgbilling.modules.yoomoney.server.service.YoomoneyServiceImpl;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.jmx.MBeanPaymentModule;

@BGPaymentModule
public class Module
extends ModuleBase
implements MBeanPaymentModule {
    public static final String MODULE_NAME = "yoomoney";
    final String[] loggerName = new String[]{Module.class.getName(), TransactionManager.class.getName(), YoomoneyServiceImpl.class.getName()};

    public String[] getServerPackages() {
        return new String[]{"ru.bitel.bgbilling.modules.yoomoney.server"};
    }

    public void start(Connection con, BGModule module) throws BGException {
        this.registerMBean(module);
        new YoomoneyCheckEventWorker(Setup.getSetup(), module.getId());
        new YoomoneyAutopaymentEventWorker(Setup.getSetup(), module.getId());
    }

    public void moduleAction(ServerContext serverContext, int moduleId, Event event) throws Exception {
        int contractId = event.getContractId();
        if (event instanceof ContractCreateEvent) {
            Connection con = serverContext.getConnection();
            ContractCreateEvent contractCreateEvent = (ContractCreateEvent)event;
            if (!contractCreateEvent.isCheck()) {
                this.enableAutopayment(contractCreateEvent.getPattern().getData(), MODULE_NAME, moduleId, contractId, con, serverContext.getUserId());
            }
        } else if (event instanceof ContractDeleteEvent) {
            ContractDeleteEvent contractDeleteEvent = (ContractDeleteEvent)event;
            if (!contractDeleteEvent.isCheck()) {
                String cidStr = String.valueOf(event.getContractId());
                ServerUtils.deleteRowsFromTable((Connection)serverContext.getConnection(), (String)("yoomoney_transactions_" + moduleId), (String)"contract_id", (String)cidStr, null);
            }
        } else if (event instanceof PaymentEvent) {
            PaymentEvent paymentEvent = (PaymentEvent)event;
            ModuleSetup moduleSetup = Setup.getSetup().getModuleSetup(Integer.valueOf(moduleId));
            int chargeTypeId = moduleSetup.getInt("yoomoney.commission.charge.type.id", 0);
            if (moduleSetup.getBoolean("yoomoney.commission.charge.enable", false) && chargeTypeId > 0) {
                Payment payment = paymentEvent.getPayment();
                try (Connection con = serverContext.getConnection();
                     BalanceUtils balanceUtils = new BalanceUtils(con);){
                    ChargeDao chargeDao = new ChargeDao(con);
                    Transaction transaction = new TransactionManager(con, moduleId).getTransactionByPaymentId(payment.getId());
                    if (transaction != null) {
                        JSONObject json = new JSONObject(transaction.getRawRequest());
                        Object amountValue = json.optQuery("/amount/value");
                        Object incomeAmountValue = json.optQuery("/income_amount/value");
                        if (amountValue != null && incomeAmountValue != null) {
                            BigDecimal sum = new BigDecimal(String.valueOf(amountValue)).subtract(new BigDecimal(String.valueOf(incomeAmountValue)));
                            Charge charge = new Charge().setContractId(payment.getContractId()).setDate(new Date()).setTypeId(chargeTypeId).setSum(sum).setComment("\u041a\u043e\u043c\u043c\u0438c\u0441\u0438\u044f \u0437\u0430 \u043f\u043b\u0430\u0442\u0435\u0436 (#" + payment.getId() + ")").setUserId(0);
                            chargeDao.update((Object)charge);
                            balanceUtils.updateBalance(charge.getDate(), charge.getContractId());
                        }
                    }
                }
                catch (Exception ex) {
                    this.logError(ex);
                }
            }
        }
    }

    public void serializeContract(Connection con, int contractId, int moduleId, XMLStreamWriter tables, boolean onlyCurrent) throws SQLException, XMLStreamException {
    }

    public List<PaymentMethod> getPaymentMethods(int moduleId) {
        return this.getPaymentMethods(moduleId, MODULE_NAME, Constants.class);
    }

    public Map<String, Object> getContractAutopaymentData(int moduleId, int contractId, Connection con) {
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        try {
            AutopaymentManager autopaymentManager = new AutopaymentManager(con, moduleId);
            TransactionUtils.setAutopaymentData((int)moduleId, (int)contractId, dataMap, (Connection)con, (String)MODULE_NAME, (AbstractAutopaymentManager)autopaymentManager, Constants.class);
        }
        catch (Exception ex) {
            this.logError(ex);
        }
        return dataMap;
    }

    public String[] getLoggerNames() {
        return this.loggerName;
    }
}

